/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jface.util.Assert;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.LargeIconType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.SmallIconType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.RefElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowModelManager;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowTransform;

public class FC2PFTransformer {
    private static final boolean DEBUG = false;
    private static FC2PFTransformer _instance;
    private boolean listenToNotify;
    private boolean isInEvent;
    boolean pageflowChanged = false;
    private Map mapPaths2PF = new HashMap();
    private Map mapCases2Links = new HashMap();
    private Pageflow pageflow;
    FacesConfigType facesConfig;

    private void refreshPFAdapter(EObject object) {
        TreeIterator rules = object.eAllContents();
        while (rules.hasNext()) {
            Object next = rules.next();
            this.adapt((EObject)next);
        }
    }

    private void refreshFCAdapter(EObject object) {
        EList rules = this.facesConfig.getNavigationRule();
        int i = 0;
        while (i < rules.size()) {
            NavigationRuleType rule = (NavigationRuleType)rules.get(i);
            this.adapt((EObject)rule);
            TreeIterator children = rule.eAllContents();
            while (children.hasNext()) {
                this.adapt((EObject)children.next());
            }
            ++i;
        }
    }

    public void setFacesConfig(FacesConfigType facesConfig) {
        this.facesConfig = facesConfig;
    }

    public void setPageflow(Pageflow pageflow) {
        this.pageflow = pageflow;
    }

    public void adapt(EObject object) {
        if (object != null && !this.isAdapted(object)) {
            if (object instanceof PageflowElement) {
                object.eAdapters().add((Object)new PF2FCSynchronizer());
            } else {
                object.eAdapters().add((Object)new FC2PFSynchronizer());
            }
        }
    }

    public void unAdapt(EObject object) {
        Iterator adapters = object.eAdapters().iterator();
        while (adapters.hasNext()) {
            Object adapter = adapters.next();
            if (!(adapter instanceof FC2PFSynchronizer) && !(adapter instanceof PF2FCSynchronizer)) continue;
            adapters.remove();
        }
    }

    public boolean isAdapted(EObject object) {
        Iterator adapters = object.eAdapters().iterator();
        while (adapters.hasNext()) {
            Object adapter = adapters.next();
            if (!(adapter instanceof FC2PFSynchronizer) && !(adapter instanceof PF2FCSynchronizer)) continue;
            return true;
        }
        return false;
    }

    public void clearCaches() {
        this.mapPaths2PF.clear();
        this.mapCases2Links.clear();
    }

    public static FC2PFTransformer getInstance() {
        if (_instance == null) {
            _instance = new FC2PFTransformer();
        }
        return _instance;
    }

    public void dispose() {
        this.clearCaches();
        _instance = null;
    }

    public void setListenToNotify(boolean listenToNotify) {
        this.listenToNotify = listenToNotify;
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void setTarget(Notifier newTarget) {
    }

    public PageflowPage findPage(String path, Pageflow pageflow) {
        EList nodes = pageflow.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            if (nodes.get(i) instanceof PageflowPage && path != null && path.equals(((PageflowPage)nodes.get(i)).getPath())) {
                return (PageflowPage)nodes.get(i);
            }
            ++i;
        }
        return null;
    }

    public FromViewIdType getSource(NavigationCaseType caseType) {
        if (caseType.eContainer() instanceof NavigationRuleType) {
            NavigationRuleType rule = (NavigationRuleType)caseType.eContainer();
            return rule.getFromViewId();
        }
        return null;
    }

    public PageflowNode findCaseEnd(PageflowPage action, FromOutcomeType outcome, Pageflow pageflow) {
        EList links = action.getOutlinks();
        int i = 0;
        while (i < links.size()) {
            PageflowLink link = (PageflowLink)links.get(i);
            String outcomeStr = "";
            if (outcome != null) {
                outcomeStr = outcome.getTextContent();
            }
            if (link.getOutcome().equals(outcomeStr)) {
                return link.getTarget();
            }
            ++i;
        }
        return null;
    }

    private PageflowPage getOrCreateStartPage(NavigationCaseType navCase) {
        PageflowPage startPageflowNode = null;
        String path = "*";
        NavigationRuleType rule = (NavigationRuleType)navCase.eContainer();
        FromViewIdType source = this.getSource(navCase);
        if (source != null) {
            path = source.getTextContent();
        }
        if (!this.hasValidCache(path)) {
            startPageflowNode = this.findPage(path, this.pageflow);
            if (startPageflowNode == null) {
                startPageflowNode = PageflowTransform.getInstance().createPFPage(path);
                this.pageflowChanged = true;
            }
            this.mapPaths2PF.put(path, startPageflowNode);
            PageflowTransform.getInstance().updatePageflowSourcePage(startPageflowNode, rule);
        } else {
            startPageflowNode = (PageflowPage)this.mapPaths2PF.get(path);
        }
        if (source != null) {
            RefElement element = new RefElement(startPageflowNode);
            element.add((EObject)source);
            startPageflowNode.setReferenceLink(element.resolveReferenceString());
            startPageflowNode.getFCElements().add((EObject)source);
        }
        return startPageflowNode;
    }

    private boolean hasValidCache(Object key) {
        EObject element = (EObject)this.mapPaths2PF.get(key);
        boolean result = false;
        while (element != null) {
            if (element == this.pageflow) {
                result = true;
            }
            element = element.eContainer();
        }
        return result;
    }

    private PageflowPage getOrCreateEndPage(NavigationCaseType navCase) {
        PageflowPage endPageflowNode = null;
        ToViewIdType target = navCase.getToViewId();
        if (target != null) {
            String path = target.getTextContent();
            if (!this.hasValidCache(path)) {
                endPageflowNode = this.findPage(path, this.pageflow);
                if (endPageflowNode == null) {
                    endPageflowNode = PageflowTransform.getInstance().createPFPage(path);
                    this.pageflowChanged = true;
                }
                this.mapPaths2PF.put(path, endPageflowNode);
                PageflowTransform.getInstance().updatePageflowTargetPage(endPageflowNode, navCase);
            } else {
                endPageflowNode = (PageflowPage)this.mapPaths2PF.get(path);
            }
            if (target != null) {
                RefElement element = new RefElement(endPageflowNode);
                element.add((EObject)target);
                endPageflowNode.setReferenceLink(element.resolveReferenceString());
                endPageflowNode.getFCElements().add((EObject)target);
            }
        }
        return endPageflowNode;
    }

    public boolean updatePageflowElements(Pageflow pageflow, NavigationCaseType caseFC) {
        this.pageflowChanged = false;
        this.pageflow = pageflow;
        ToViewIdType target = caseFC.getToViewId();
        if (target == null) {
            return false;
        }
        PageflowPage start = null;
        PageflowPage end = null;
        start = this.getOrCreateStartPage(caseFC);
        String action = null;
        if (caseFC.getFromAction() != null) {
            action = caseFC.getFromAction().getTextContent();
        }
        String fromOutCome = null;
        if (caseFC.getFromOutcome() != null) {
            fromOutCome = caseFC.getFromOutcome().getTextContent();
        }
        end = this.getOrCreateEndPage(caseFC);
        PageflowLink link = null;
        link = this.findUnmappedLink(start, end, caseFC);
        if (link == null && end != null) {
            link = this.createPFLink(start, end, action, fromOutCome);
            this.pageflowChanged = true;
        }
        if (link != null) {
            link.getFCElements().clear();
            link.getFCElements().add((EObject)caseFC);
            this.mapCases2Links.put(caseFC, link);
        }
        this.adapt(start);
        this.adapt(end);
        this.adapt((EObject)caseFC);
        this.adapt(link);
        return this.pageflowChanged;
    }

    private PageflowLink findUnmappedLink(PageflowPage start, PageflowPage end, NavigationCaseType caseFC) {
        EList links = start.getOutlinks();
        int i = 0;
        int n = links.size();
        while (i < n) {
            PageflowLink link = (PageflowLink)links.get(i);
            if (link.getSource() == start && link.getTarget() == end && link.getFCElements().isEmpty()) {
                return link;
            }
            ++i;
        }
        return null;
    }

    private boolean isSame(Object first, Object second) {
        return first == null && second == null || first != null && second != null && first.equals(second);
    }

    public FromViewIdType createRLFromViewID(String value) {
        FromViewIdType fromView = FacesConfigFactory.eINSTANCE.createFromViewIdType();
        fromView.setTextContent(value);
        return fromView;
    }

    public PageflowLink createPFLink(PageflowNode start, PageflowNode target, NavigationCaseType caseFC) {
        PageflowLink link = null;
        String fromOutcome = caseFC.getFromOutcome() != null ? caseFC.getFromOutcome().getTextContent() : null;
        String action = caseFC.getFromAction() != null ? caseFC.getFromAction().getTextContent() : null;
        NavigationRuleType rule = (NavigationRuleType)caseFC.eContainer();
        link = this.createPFLink(fromOutcome);
        link.setFromaction(action);
        link.setSource(start);
        link.setTarget(target);
        start.getOutlinks().add((Object)link);
        target.getInlinks().add((Object)link);
        link.getFCElements().add((EObject)caseFC);
        start.getFCElements().add((EObject)rule.getFromViewId());
        target.getFCElements().add((EObject)caseFC.getToViewId());
        return link;
    }

    public PageflowLink createPFLink(PageflowNode start, PageflowNode target, String action, String fromOutcome) {
        Assert.isTrue((start != null && target != null ? 1 : 0) != 0);
        PageflowLink link = null;
        link = this.createPFLink(fromOutcome);
        link.setFromaction(action);
        link.setSource(start);
        link.setTarget(target);
        start.getOutlinks().add((Object)link);
        target.getInlinks().add((Object)link);
        return link;
    }

    public PageflowLink createPFLink(String fromOutcome) {
        PageflowLink link = null;
        link = PageflowModelManager.getFactory().createPFLink();
        if (fromOutcome != null && fromOutcome.length() > 0) {
            link.setOutcome(fromOutcome.trim());
        }
        this.pageflow.getLinks().add((Object)link);
        return link;
    }

    public ToViewIdType createFCToViewID(String value) {
        ToViewIdType toView = FacesConfigFactory.eINSTANCE.createToViewIdType();
        toView.setTextContent(value);
        return toView;
    }

    class PF2FCSynchronizer
    implements Adapter {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public Notifier getTarget() {
            return null;
        }

        public boolean isAdapterForType(Object type) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.FC2PFTransformer$PF2FCSynchronizer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return type == clazz;
        }

        private void addPage(Notification notification, PageflowElement element) {
        }

        private String getFromViewID(NavigationRuleType rule) {
            String result = "*";
            if (rule.getFromViewId() != null) {
                result = rule.getFromViewId().getTextContent();
            }
            return result;
        }

        private String getToViewID(NavigationCaseType navCase) {
            String result = "*";
            if (navCase.getToViewId() != null) {
                result = navCase.getToViewId().getTextContent();
            }
            return result;
        }

        public List findFacesPages(String path) {
            EList rules = FC2PFTransformer.this.facesConfig.getNavigationRule();
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < rules.size()) {
                NavigationRuleType rule = (NavigationRuleType)rules.get(i);
                String fromViewID = this.getFromViewID(rule);
                if (fromViewID.equals(path)) {
                    result.add(rule.getFromViewId());
                }
                EList cases = rule.getNavigationCase();
                int j = 0;
                while (j < cases.size()) {
                    NavigationCaseType navCase = (NavigationCaseType)cases.get(j);
                    String toViewID = this.getToViewID(navCase);
                    if (toViewID.equals(path)) {
                        result.add(navCase.getToViewId());
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }

        private void updateFacesRule(NavigationRuleType navigationRule, PageflowPage pageSource) {
            FacesConfigFactory factory = FacesConfigFactory.eINSTANCE;
            if (pageSource.getComment() != null) {
                DescriptionType description = factory.createDescriptionType();
                description.setTextContent(pageSource.getComment());
                navigationRule.getDescription().clear();
                navigationRule.getDescription().add((Object)description);
            }
            if (pageSource.getLargeicon() != null || pageSource.getSmallicon() != null) {
                IconType icon = factory.createIconType();
                if (pageSource.getLargeicon() != null) {
                    LargeIconType largeicon = factory.createLargeIconType();
                    largeicon.setTextContent(pageSource.getLargeicon());
                    icon.setLargeIcon(largeicon);
                }
                if (pageSource.getSmallicon() != null) {
                    SmallIconType smallicon = factory.createSmallIconType();
                    smallicon.setTextContent(pageSource.getSmallicon());
                    icon.setSmallIcon(smallicon);
                }
                navigationRule.getIcon().clear();
                navigationRule.getIcon().add((Object)icon);
            }
            if (pageSource.getName() != null) {
                DisplayNameType displayName = factory.createDisplayNameType();
                displayName.setTextContent(pageSource.getName());
                navigationRule.getDisplayName().clear();
                navigationRule.getDisplayName().add((Object)displayName);
            }
        }

        private void createFacesCase(PageflowLink link, PageflowPage source, PageflowPage target) {
            NavigationRuleType rule = FacesConfigFactory.eINSTANCE.createNavigationRuleType();
            FromViewIdType from = FacesConfigFactory.eINSTANCE.createFromViewIdType();
            from.setTextContent(source.getPath());
            rule.setFromViewId(from);
            NavigationCaseType navCase = FacesConfigFactory.eINSTANCE.createNavigationCaseType();
            ToViewIdType toView = FacesConfigFactory.eINSTANCE.createToViewIdType();
            toView.setTextContent(target.getPath());
            navCase.setToViewId(toView);
            rule.getNavigationCase().add((Object)navCase);
            FC2PFTransformer.this.facesConfig.getNavigationRule().add((Object)rule);
            this.updateFacesRule(rule, source);
            source.getFCElements().add((EObject)from);
            target.getFCElements().add((EObject)toView);
            link.getFCElements().add((EObject)navCase);
            FC2PFTransformer.this.mapCases2Links.put(navCase, link);
        }

        private void removePageToPageLink(PageflowPage start, PageflowLink link, PageflowPage target) {
            if (!link.getFCElements().isEmpty()) {
                FC2PFTransformer.getInstance().unAdapt(link);
                NavigationCaseType caseFC = (NavigationCaseType)link.getFCElements().getData().get(0);
                link.getFCElements().remove((EObject)caseFC);
                FC2PFTransformer.this.mapCases2Links.remove(caseFC);
                this.removeCase(caseFC);
            }
        }

        private void removeCase(NavigationCaseType navCase) {
            NavigationRuleType rule = (NavigationRuleType)navCase.eContainer();
            rule.getNavigationCase().remove((Object)navCase);
            if (rule.getNavigationCase().size() == 0) {
                FC2PFTransformer.this.facesConfig.getNavigationRule().remove((Object)rule);
            }
        }

        private void propertyChanged(Notification notification, PageflowElement element) {
            if (notification.getNewValue() != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                notification.getFeatureID((Class)clazz);
                if (element instanceof PageflowPage || element instanceof PageflowLink) {
                    // empty if block
                }
            }
        }

        private void addPageToPageLink(PageflowPage source, PageflowPage target, PageflowLink value) {
            if (source != null && target != null && value != null) {
                this.createFacesCase(value, source, target);
            }
        }

        private void addInLink(Notification notification, PageflowElement element) {
            PageflowNode source;
            Object value = notification.getNewValue();
            PageflowLink link = (PageflowLink)value;
            if (element instanceof PageflowPage && (source = link.getSource()) instanceof PageflowPage) {
                this.addPageToPageLink((PageflowPage)source, (PageflowPage)element, link);
            }
        }

        private void addOutLink(Notification notification, PageflowElement element) {
            PageflowNode target;
            Object value = notification.getNewValue();
            PageflowLink link = (PageflowLink)value;
            if (element instanceof PageflowPage && (target = link.getTarget()) instanceof PageflowPage) {
                this.addPageToPageLink((PageflowPage)element, (PageflowPage)target, link);
            }
        }

        private void removePage(Notification notification, PageflowElement element) {
        }

        private void removeInLink(Notification notification, PageflowElement element) {
            PageflowNode source;
            Object value = notification.getOldValue();
            PageflowLink link = (PageflowLink)value;
            if (element instanceof PageflowPage && (source = link.getSource()) instanceof PageflowPage) {
                this.removePageToPageLink((PageflowPage)source, link, (PageflowPage)element);
            }
        }

        private void removeOutLink(Notification notification, PageflowElement element) {
            PageflowNode target;
            Object value = notification.getOldValue();
            PageflowLink link = (PageflowLink)value;
            if (element instanceof PageflowPage && (target = link.getTarget()) instanceof PageflowPage) {
                this.removePageToPageLink((PageflowPage)element, link, (PageflowPage)target);
            }
        }

        public void notifyChanged(Notification notification) {
            if (!FC2PFTransformer.this.listenToNotify || FC2PFTransformer.this.isInEvent) {
                return;
            }
            FC2PFTransformer.this.isInEvent = true;
            if (!(notification.getNotifier() instanceof PageflowElement)) {
                return;
            }
            PageflowElement element = (PageflowElement)notification.getNotifier();
            int type = notification.getEventType();
            block2 : switch (type) {
                case 3: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    int featureId = notification.getFeatureID((Class)clazz);
                    switch (featureId) {
                        case 8: {
                            this.addPage(notification, element);
                            break block2;
                        }
                        case 9: {
                            this.addOutLink(notification, element);
                            break block2;
                        }
                        case 10: {
                            this.addInLink(notification, element);
                            break block2;
                        }
                    }
                    break;
                }
                case 1: {
                    if (notification.getNewValue() == null) break;
                    this.propertyChanged(notification, element);
                    break;
                }
                case 4: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    int featureId = notification.getFeatureID((Class)clazz);
                    switch (featureId) {
                        case 5: {
                            this.removePage(notification, element);
                            this.updateAndNotify(notification);
                            break block2;
                        }
                        case 9: {
                            this.removeOutLink(notification, element);
                            this.updateAndNotify(notification);
                            break block2;
                        }
                        case 10: {
                            this.removeInLink(notification, element);
                            this.updateAndNotify(notification);
                        }
                    }
                }
            }
            FC2PFTransformer.this.refreshPFAdapter(FC2PFTransformer.this.pageflow);
            FC2PFTransformer.this.refreshFCAdapter((EObject)FC2PFTransformer.this.facesConfig);
            FC2PFTransformer.this.isInEvent = false;
        }

        private void updateAndNotify(Notification notification) {
            FC2PFTransformer.this.pageflow.notifyModelChanged((Notification)new ENotificationImpl((InternalEObject)notification.getNotifier(), 1, 0, null, null));
        }

        public void dispose() {
        }

        public void setTarget(Notifier newTarget) {
        }
    }

    class FC2PFSynchronizer
    implements Adapter {
        static /* synthetic */ Class class$0;

        public Notifier getTarget() {
            return null;
        }

        public boolean isAdapterForType(Object type) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.FC2PFTransformer$FC2PFSynchronizer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return type == clazz;
        }

        private void processAdd(Notification notification) {
            NavigationRuleType newRule;
            Object feature = notification.getFeature();
            if (feature == FacesConfigPackage.eINSTANCE.getNavigationRuleType_NavigationCase()) {
                NavigationCaseType newCase = (NavigationCaseType)notification.getNewValue();
                FC2PFTransformer.this.updatePageflowElements(FC2PFTransformer.this.pageflow, newCase);
            } else if (feature == FacesConfigPackage.eINSTANCE.getFacesConfigType_NavigationRule() && (newRule = (NavigationRuleType)notification.getNewValue()).getNavigationCase().size() > 0) {
                int i = 0;
                while (i < newRule.getNavigationCase().size()) {
                    FC2PFTransformer.this.updatePageflowElements(FC2PFTransformer.this.pageflow, (NavigationCaseType)newRule.getNavigationCase().get(i));
                    ++i;
                }
            }
        }

        public void notifyChanged(Notification notification) {
            if (!FC2PFTransformer.this.listenToNotify || FC2PFTransformer.this.isInEvent || !(notification.getNotifier() instanceof EObject)) {
                return;
            }
            FC2PFTransformer.this.isInEvent = true;
            if (this.checkSanity(notification)) {
                int type = notification.getEventType();
                switch (type) {
                    case 3: {
                        this.processAdd(notification);
                        this.updateAndNotify(notification);
                        break;
                    }
                    case 1: {
                        this.processSet(notification);
                        this.updateAndNotify(notification);
                        break;
                    }
                    case 4: {
                        this.processRemove(notification);
                        this.updateAndNotify(notification);
                    }
                }
            }
            FC2PFTransformer.this.refreshFCAdapter((EObject)notification.getNotifier());
            FC2PFTransformer.this.refreshPFAdapter(FC2PFTransformer.this.pageflow);
            FC2PFTransformer.this.isInEvent = false;
        }

        private void updateAndNotify(Notification notification) {
            Assert.isTrue((boolean)(notification.getNotifier() instanceof InternalEObject));
            FC2PFTransformer.this.pageflow.notifyModelChanged((Notification)new ENotificationImpl((InternalEObject)notification.getNotifier(), 1, 0, null, null));
        }

        private boolean checkSanity(Notification notification) {
            return true;
        }

        private boolean isValidViewID(Object object) {
            boolean result = false;
            if (object instanceof ToViewIdType) {
                result = ((ToViewIdType)object).getTextContent() != null && ((ToViewIdType)object).getTextContent().trim().length() > 0;
            } else if (object instanceof FromViewIdType) {
                result = ((FromViewIdType)object).getTextContent() != null && ((FromViewIdType)object).getTextContent().trim().length() > 0;
            }
            return result;
        }

        private void processRemove(Notification notification) {
            if (notification.getFeature() == FacesConfigPackage.eINSTANCE.getNavigationRuleType_NavigationCase()) {
                if (notification.getOldValue() instanceof NavigationCaseType) {
                    NavigationCaseType caseType = (NavigationCaseType)notification.getOldValue();
                    PageflowLink link = (PageflowLink)FC2PFTransformer.this.mapCases2Links.get(caseType);
                    this.removeLink(link);
                }
            } else if (notification.getFeature() == FacesConfigPackage.eINSTANCE.getNavigationCaseType()) {
                if (notification.getOldValue() instanceof NavigationRuleType) {
                    NavigationRuleType rule = (NavigationRuleType)notification.getOldValue();
                    this.moveStartTo(rule, null, rule.getFromViewId());
                }
            } else if (notification.getFeature() == FacesConfigPackage.eINSTANCE.getFacesConfigType_NavigationRule() && notification.getOldValue() instanceof NavigationRuleType) {
                NavigationRuleType rule = (NavigationRuleType)notification.getOldValue();
                this.moveStartTo(rule, null, rule.getFromViewId());
            }
        }

        private void processSet(Notification notification) {
            Object feature = notification.getFeature();
            if (feature == FacesConfigPackage.eINSTANCE.getFromViewIdType_TextContent() || feature == FacesConfigPackage.eINSTANCE.getNavigationRuleType_FromViewId()) {
                this.fromViewIdChanged(notification);
            } else if (feature == FacesConfigPackage.eINSTANCE.getToViewIdType_TextContent() || feature == FacesConfigPackage.eINSTANCE.getNavigationCaseType_ToViewId()) {
                this.toViewIdChanged(notification);
            }
        }

        private void fromViewIdChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (feature == FacesConfigPackage.eINSTANCE.getNavigationRuleType_FromViewId() && notification.getNewValue() == null && notification.getOldValue() instanceof FromViewIdType) {
                PageflowPage newStart = PageflowTransform.getInstance().createPFPage("*");
                NavigationRuleType rule = (NavigationRuleType)notification.getNotifier();
                this.moveStartTo(rule, newStart, (FromViewIdType)notification.getOldValue());
            } else if (notification.getOldValue() == null && notification.getNewValue() instanceof String) {
                String fromID = (String)notification.getNewValue();
                PageflowPage newStart = FC2PFTransformer.this.findPage(fromID, FC2PFTransformer.this.pageflow);
                newStart = newStart == null ? PageflowTransform.getInstance().createPFPage(fromID) : newStart;
                NavigationRuleType rule = (NavigationRuleType)((EObject)notification.getNotifier()).eContainer();
                this.moveStartTo(rule, newStart, (FromViewIdType)notification.getNotifier());
            }
        }

        private void moveStartTo(NavigationRuleType rule, PageflowPage newStart, FromViewIdType fromViewId) {
            EList cases = rule.getNavigationCase();
            int i = 0;
            int n = cases.size();
            while (i < n) {
                NavigationCaseType caseFC = (NavigationCaseType)cases.get(i);
                PageflowLink link = (PageflowLink)FC2PFTransformer.this.mapCases2Links.get(caseFC);
                if (link.getSource() != newStart) {
                    PageflowPage start = (PageflowPage)link.getSource();
                    PageflowPage end = (PageflowPage)link.getTarget();
                    PageflowLink newLink = null;
                    if (newStart != null) {
                        newLink = FC2PFTransformer.this.createPFLink(newStart, end, caseFC);
                        FC2PFTransformer.this.mapCases2Links.put(caseFC, newLink);
                    }
                    this.removeLink(link);
                    FC2PFTransformer.this.mapCases2Links.remove(caseFC);
                    if (newLink != null) {
                        FC2PFTransformer.this.mapCases2Links.put(caseFC, newLink);
                    }
                    if (start.getOutlinks().size() == 0 && start.getInlinks().size() == 0) {
                        this.removePageflowPage(start);
                    }
                }
                ++i;
            }
        }

        private void toViewIdChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (feature == FacesConfigPackage.eINSTANCE.getNavigationCaseType_ToViewId() && notification.getNewValue() == null && notification.getOldValue() instanceof ToViewIdType) {
                NavigationCaseType rule = (NavigationCaseType)((EObject)notification.getNotifier()).eContainer();
                this.moveEndTo(rule, null, (ToViewIdType)notification.getOldValue());
            } else if (feature == FacesConfigPackage.eINSTANCE.getToViewIdType_TextContent()) {
                String toViewId = (String)notification.getNewValue();
                PageflowPage newEnd = FC2PFTransformer.this.findPage(toViewId, FC2PFTransformer.this.pageflow);
                PageflowPage pageflowPage = newEnd = newEnd == null ? PageflowTransform.getInstance().createPFPage(toViewId) : newEnd;
                if (FC2PFTransformer.this.mapCases2Links.get(notification.getNotifier()) == null) {
                    FC2PFTransformer.this.updatePageflowElements(FC2PFTransformer.this.pageflow, (NavigationCaseType)((EObject)notification.getNotifier()).eContainer());
                } else {
                    NavigationCaseType rule = (NavigationCaseType)((EObject)notification.getNotifier()).eContainer();
                    this.moveEndTo(rule, newEnd, (ToViewIdType)notification.getNotifier());
                }
            }
        }

        private void moveEndTo(NavigationCaseType caseFC, PageflowPage newEnd, ToViewIdType toViewId) {
            PageflowLink link = (PageflowLink)FC2PFTransformer.this.mapCases2Links.get(caseFC);
            PageflowPage start = (PageflowPage)link.getSource();
            PageflowPage end = (PageflowPage)link.getTarget();
            PageflowLink newLink = null;
            if (newEnd != null) {
                newLink = FC2PFTransformer.this.createPFLink(start, newEnd, caseFC);
            }
            link.getTarget().getFCElements().remove((EObject)toViewId);
            this.removeLink(link);
            FC2PFTransformer.this.mapCases2Links.remove(caseFC);
            if (newLink != null) {
                FC2PFTransformer.this.mapCases2Links.put(caseFC, newLink);
            }
            if (end.getOutlinks().size() == 0 && end.getInlinks().size() == 0) {
                this.removePageflowPage(end);
            }
        }

        private void removePageflowPage(PageflowPage source) {
            Assert.isTrue((source.getOutlinks().size() == 0 && source.getInlinks().size() == 0 ? 1 : 0) != 0);
            FC2PFTransformer.this.pageflow.getNodes().remove((Object)source);
        }

        private void removeLink(PageflowLink pLink) {
            pLink.getPageflow().getLinks().remove((Object)pLink);
            pLink.getSource().getOutlinks().remove((Object)pLink);
            pLink.getTarget().getInlinks().remove((Object)pLink);
            pLink.getFCElements().clear();
        }

        public void dispose() {
        }

        public void setTarget(Notifier newTarget) {
        }
    }
}

