/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.jsf.facesconfig.common.dialogs.ResourceOnClasspathDialog;
import org.eclipse.jst.jsf.facesconfig.emf.MessageBundleType;
import org.eclipse.jst.jsf.facesconfig.ui.NewEditorResourcesNLS;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.MessageBundleViewerSorter;
import org.eclipse.swt.widgets.Shell;

public class MessageBundleSelectionDialog
extends ResourceOnClasspathDialog {
    private List resourceBundles;
    private String selectPropertyFileMessage = NewEditorResourcesNLS.MessageBundleSection_Dialog_Message_SelectPropertyFile;
    private String alreadyExistStatusMessage = NewEditorResourcesNLS.MessageBundleSection_Dialog_Message_AlreadyExists;
    private static final String[] PROPERTIES_FILES_SUFFIXS = new String[]{"properties"};

    public MessageBundleSelectionDialog(Shell parentShell, IJavaProject project, List resourceBundles) {
        super(parentShell, project);
        this.resourceBundles = resourceBundles;
        this.setSuffixs(PROPERTIES_FILES_SUFFIXS);
        this.setTitle(NewEditorResourcesNLS.MessageBundleSection_Dialog_Title);
        this.setViewerSorter(new MessageBundleViewerSorter());
    }

    protected boolean isValidSelection(Object selection) {
        if (!super.isValidSelection(selection)) {
            this.setStatusMessage(this.selectPropertyFileMessage);
            return false;
        }
        ArrayList<Object> selectionList = new ArrayList<Object>();
        selectionList.add(selection);
        this.setResult(selectionList);
        Object result = super.getResult()[0];
        if (result == null) {
            this.setStatusMessage(this.selectPropertyFileMessage);
            return false;
        }
        String newResourceBundle = (String)result;
        if (this.isAlreadyExist(newResourceBundle)) {
            this.setStatusMessage(this.alreadyExistStatusMessage);
            return false;
        }
        return true;
    }

    private boolean isAlreadyExist(String resourceBundleString) {
        if (resourceBundleString == null || resourceBundleString.length() == 0) {
            return true;
        }
        if (this.resourceBundles == null) {
            return false;
        }
        int i = 0;
        while (i < this.resourceBundles.size()) {
            MessageBundleType node = (MessageBundleType)this.resourceBundles.get(i);
            String rbName = node.getTextContent();
            if (rbName != null && rbName.equalsIgnoreCase(resourceBundleString)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

