/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.InvalidWriteAccessModeException;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigResourceFactory;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class JARFileJSFAppConfigProvider
implements IJSFAppConfigProvider {
    public static final String JARFILE_URI_PREFIX = "jar:file:///";
    public static final String FACES_CONFIG_IN_JAR_SUFFIX = "!/META-INF/faces-config.xml";
    protected String filename = null;

    public JARFileJSFAppConfigProvider(String filename) {
        this.filename = filename;
    }

    public FacesConfigType getFacesConfigModel(boolean forWrite) throws InvalidWriteAccessModeException {
        FacesConfigType facesConfig = null;
        if (forWrite && !this.allowsWrite()) {
            throw new InvalidWriteAccessModeException(Messages.JSFAppConfigManager_InvalidWriteAccess);
        }
        if (this.filename != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(JARFILE_URI_PREFIX);
            sb.append(this.filename);
            sb.append(FACES_CONFIG_IN_JAR_SUFFIX);
            URI jarFileURI = URI.createURI((String)sb.toString());
            FacesConfigResourceFactory resourceFactory = new FacesConfigResourceFactory((RendererFactory)EMF2SAXRendererFactory.INSTANCE);
            Resource resource = resourceFactory.createResource(jarFileURI);
            try {
                EList resourceContents;
                resource.load(Collections.EMPTY_MAP);
                if (resource != null && (resourceContents = resource.getContents()) != null && resourceContents.size() > 0) {
                    facesConfig = (FacesConfigType)resourceContents.get(0);
                }
            }
            catch (IOException ioe) {
                JSFCorePlugin.log(4, ioe.getLocalizedMessage(), ioe);
            }
        }
        return facesConfig;
    }

    public void releaseFacesConfigModel() {
    }

    public boolean allowsWrite() {
        return false;
    }
}

