/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.classpath;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class JSFLibraryWizard
extends Wizard
implements INewWizard {
    private Text txtName;
    private Label lblName;
    private CCombo cboVersions;
    private Label lblVersions;
    private Button chkDeploy;
    private Button chkImpl;
    private Composite btnBar;
    private Button btnAdd;
    private Button btnRemove;
    private TableViewer jars;
    private boolean isNew = false;
    private boolean modified = false;
    private boolean implsOnly = false;
    private JSFLibrary curLibrary;
    private JSFLibrary workingCopyLibrary;
    private JSFLibraryWizardPage page;
    private static final String DESCRIPTION = Messages.JSFLibraryWizard_DESCRIPTION;
    private static final String IMPLS_ONLY_DESC = Messages.JSFLibraryWizard_IMPLS_ONLY_DESC;
    private boolean nonimplOnly = false;

    public JSFLibraryWizard(boolean b) {
        this.implsOnly = b;
    }

    public JSFLibraryWizard() {
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && selection.getFirstElement() instanceof JSFLibrary) {
            this.curLibrary = (JSFLibrary)selection.getFirstElement();
            this.workingCopyLibrary = this.curLibrary.getWorkingCopy();
        } else {
            this.isNew = true;
            this.workingCopyLibrary = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        }
        if (this.implsOnly) {
            this.setWindowTitle(Messages.JSFLibraryWizard_CreateImplementation);
        } else {
            this.setWindowTitle(this.isNew ? Messages.JSFLibraryWizard_CreateJSFLibrary : Messages.JSFLibraryWizard_EditJSFLibrary);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection, boolean nonimplonly) {
        this.init(workbench, selection);
        this.nonimplOnly = nonimplonly;
    }

    public boolean performFinish() {
        String name = this.txtName.getText().trim();
        boolean isDeployed = this.chkDeploy.getSelection();
        boolean isImplementation = this.chkImpl.getSelection();
        this.workingCopyLibrary.setName(name);
        if (this.cboVersions.getSelectionIndex() >= 0) {
            JSFVersion ver = (JSFVersion)JSFVersion.VALUES.get(this.cboVersions.getSelectionIndex());
            this.workingCopyLibrary.setJSFVersion(ver);
        }
        this.workingCopyLibrary.setDeployed(isDeployed);
        this.workingCopyLibrary.setImplementation(isImplementation);
        if (this.isNew) {
            JSFCorePlugin.getDefault().getJSFLibraryRegistry().addJSFLibrary(this.workingCopyLibrary);
        } else {
            this.curLibrary.updateValues(this.workingCopyLibrary);
        }
        JSFCorePlugin.getDefault().saveJSFLibraryRegistry();
        return true;
    }

    public void addPages() {
        this.page = new JSFLibraryWizardPage(Messages.JSFLibraryWizard_JSFLibrary);
        super.addPage((IWizardPage)this.page);
        this.page.setWizard((IWizard)this);
    }

    public JSFLibrary getJSFLibrary() {
        return this.workingCopyLibrary;
    }

    private class JSFLibraryWizardPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        private boolean initing;

        protected JSFLibraryWizardPage(String pageName) {
            super(pageName);
            this.setDescription(JSFLibraryWizard.this.implsOnly ? IMPLS_ONLY_DESC : DESCRIPTION);
            this.setTitle(Messages.JSFLibraryWizard_JSFLibrary);
        }

        public boolean isPageComplete() {
            if (!JSFLibraryWizard.this.modified) {
                return false;
            }
            return super.isPageComplete();
        }

        public void createControl(Composite parent) {
            this.initing = true;
            this.initializeDialogUnits((Control)parent);
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            c.setLayoutData((Object)new GridData(1808));
            JSFLibraryWizard.this.lblName = new Label(c, 0);
            JSFLibraryWizard.this.lblName.setText(Messages.JSFLibraryWizard_LibraryName);
            JSFLibraryWizard.this.lblName.setLayoutData((Object)new GridData(1));
            JSFLibraryWizard.this.txtName = new Text(c, 2048);
            JSFLibraryWizard.this.txtName.setLayoutData((Object)new GridData(768));
            JSFLibraryWizard.this.txtName.addModifyListener((ModifyListener)this);
            JSFLibraryWizard.this.lblVersions = new Label(c, 0);
            JSFLibraryWizard.this.lblVersions.setText(Messages.JSFLibraryWizard_VersionSupported);
            JSFLibraryWizard.this.cboVersions = new CCombo(c, 2060);
            JSFLibraryWizard.this.cboVersions.setLayoutData((Object)new GridData(768));
            JSFLibraryWizard.this.cboVersions.addModifyListener((ModifyListener)this);
            Group jarsComp = new Group(c, 0);
            jarsComp.setText(Messages.JSFLibraryWizard_LibraryJars);
            GridLayout gl1 = new GridLayout(2, false);
            jarsComp.setLayout((Layout)gl1);
            GridData gd2 = new GridData(1808);
            gd2.horizontalSpan = 2;
            jarsComp.setLayoutData((Object)gd2);
            this.createJarsViewer(jarsComp);
            this.createButtons((Composite)jarsComp);
            JSFLibraryWizard.this.chkImpl = new Button(c, 32);
            JSFLibraryWizard.this.chkImpl.setText(Messages.JSFLibraryWizard_IsJSFImplementation);
            GridData gd3 = new GridData();
            gd3.horizontalSpan = 2;
            JSFLibraryWizard.this.chkImpl.setLayoutData((Object)gd3);
            JSFLibraryWizard.this.chkImpl.addSelectionListener((SelectionListener)this);
            JSFLibraryWizard.this.chkDeploy = new Button(c, 32);
            JSFLibraryWizard.this.chkDeploy.setText(Messages.JSFLibraryWizard_DeployJars);
            GridData gd4 = new GridData();
            gd4.horizontalSpan = 2;
            JSFLibraryWizard.this.chkDeploy.setLayoutData((Object)gd4);
            JSFLibraryWizard.this.chkDeploy.addSelectionListener((SelectionListener)this);
            JSFLibraryWizard.this.chkDeploy.setVisible(false);
            this.loadVersions();
            if (!JSFLibraryWizard.this.isNew) {
                JSFLibraryWizard.this.txtName.setText(JSFLibraryWizard.this.workingCopyLibrary.getName());
                JSFLibraryWizard.this.cboVersions.setText(JSFLibraryWizard.this.workingCopyLibrary.getJSFVersion().getName());
                JSFLibraryWizard.this.chkDeploy.setSelection(JSFLibraryWizard.this.workingCopyLibrary.isDeployed());
                JSFLibraryWizard.this.chkImpl.setSelection(JSFLibraryWizard.this.workingCopyLibrary.isImplementation());
            }
            if (JSFLibraryWizard.this.implsOnly) {
                JSFLibraryWizard.this.chkImpl.setSelection(true);
                JSFLibraryWizard.this.chkImpl.setEnabled(false);
            }
            if (JSFLibraryWizard.this.nonimplOnly) {
                JSFLibraryWizard.this.chkImpl.setSelection(false);
                JSFLibraryWizard.this.chkImpl.setEnabled(false);
            }
            JSFLibraryWizard.this.jars.setInput((Object)JSFLibraryWizard.this.workingCopyLibrary);
            this.initing = false;
            this.setControl((Control)c);
            JSFLibraryWizard.this.txtName.setFocus();
            this.setPageComplete(false);
        }

        private void createJarsViewer(Group jarsComp) {
            JSFLibraryWizard.this.jars = new TableViewer((Composite)jarsComp, 2050);
            JSFLibraryWizard.this.jars.setContentProvider((IContentProvider)new IStructuredContentProvider(this){
                final /* synthetic */ JSFLibraryWizardPage this$1;
                {
                    this.this$1 = jSFLibraryWizardPage;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof JSFLibrary) {
                        return ((JSFLibrary)inputElement).getArchiveFiles().toArray();
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            JSFLibraryWizard.this.jars.setLabelProvider((IBaseLabelProvider)new ILabelProvider(this){
                private Image jarImg;
                final /* synthetic */ JSFLibraryWizardPage this$1;
                {
                    this.this$1 = jSFLibraryWizardPage;
                    this.jarImg = null;
                }

                public Image getImage(Object element) {
                    if (this.jarImg == null) {
                        ImageDescriptor desc = JSFUiPlugin.getImageDescriptor("obj16/jar_obj.gif");
                        this.jarImg = desc.createImage();
                    }
                    return this.jarImg;
                }

                public String getText(Object element) {
                    StringBuffer labelBuf = new StringBuffer();
                    if (element instanceof ArchiveFile) {
                        ArchiveFile archive = (ArchiveFile)element;
                        labelBuf.append(archive.getName());
                        if (!archive.exists()) {
                            labelBuf.append("[missing]");
                        }
                        labelBuf.append(" - ").append(archive.getPath());
                    }
                    return labelBuf.toString();
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                    if (this.jarImg != null) {
                        this.jarImg.dispose();
                    }
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(30);
            gd.heightHint = this.convertHeightInCharsToPixels(10);
            JSFLibraryWizard.this.jars.getControl().setLayoutData((Object)gd);
        }

        private void updateButtons() {
            JSFLibraryWizard.this.btnRemove.setEnabled(JSFLibraryWizard.this.jars.getSelection() != null);
        }

        private void createButtons(Composite c) {
            JSFLibraryWizard.this.btnBar = new Composite(c, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginTop = 0;
            gl.marginWidth = 0;
            JSFLibraryWizard.this.btnBar.setLayout((Layout)gl);
            JSFLibraryWizard.this.btnBar.setLayoutData((Object)new GridData(3));
            JSFLibraryWizard.this.btnAdd = new Button(JSFLibraryWizard.this.btnBar, 0);
            JSFLibraryWizard.this.btnAdd.setText(Messages.JSFLibraryWizard_Add);
            JSFLibraryWizard.this.btnAdd.setLayoutData((Object)new GridData(258));
            JSFLibraryWizard.this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ JSFLibraryWizardPage this$1;
                {
                    this.this$1 = jSFLibraryWizardPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    String cur = null;
                    String[] chosenJars = JSFLibraryWizardPage.access$0(this.this$1, cur);
                    if (chosenJars != null) {
                        int i = 0;
                        while (i < chosenJars.length) {
                            String jar = chosenJars[i];
                            if (!JSFLibraryWizard.access$17(JSFLibraryWizardPage.access$2(this.this$1)).containsArchiveFile(jar)) {
                                ArchiveFile archive = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
                                archive.setSourceLocation(jar);
                                archive.setRelativeDestLocation("WEB-INF/lib");
                                JSFLibraryWizard.access$17(JSFLibraryWizardPage.access$2(this.this$1)).getArchiveFiles().add((Object)archive);
                                JSFLibraryWizard.access$26(JSFLibraryWizardPage.access$2(this.this$1), true);
                            }
                            ++i;
                        }
                        JSFLibraryWizard.access$19(JSFLibraryWizardPage.access$2(this.this$1)).refresh();
                        JSFLibraryWizardPage.access$1(this.this$1);
                    }
                }
            });
            JSFLibraryWizard.this.btnRemove = new Button(JSFLibraryWizard.this.btnBar, 0);
            JSFLibraryWizard.this.btnRemove.setText(Messages.JSFLibraryWizard_Remove);
            JSFLibraryWizard.this.btnRemove.setLayoutData((Object)new GridData(258));
            JSFLibraryWizard.this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ JSFLibraryWizardPage this$1;
                {
                    this.this$1 = jSFLibraryWizardPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (JSFLibraryWizard.access$19(JSFLibraryWizardPage.access$2(this.this$1)).getSelection() instanceof StructuredSelection) {
                        StructuredSelection objs = (StructuredSelection)JSFLibraryWizard.access$19(JSFLibraryWizardPage.access$2(this.this$1)).getSelection();
                        if (objs != null) {
                            Iterator it = objs.iterator();
                            while (it.hasNext()) {
                                E obj = it.next();
                                ArchiveFile jar = (ArchiveFile)obj;
                                JSFLibraryWizard.access$17(JSFLibraryWizardPage.access$2(this.this$1)).getArchiveFiles().remove((Object)jar);
                                JSFLibraryWizard.access$26(JSFLibraryWizardPage.access$2(this.this$1), true);
                            }
                        }
                        JSFLibraryWizard.access$19(JSFLibraryWizardPage.access$2(this.this$1)).refresh();
                        JSFLibraryWizardPage.access$1(this.this$1);
                    }
                }
            });
        }

        private void loadVersions() {
            JSFLibraryWizard.this.cboVersions.removeAll();
            Iterator it = JSFVersion.VALUES.iterator();
            while (it.hasNext()) {
                JSFVersion ver = (JSFVersion)it.next();
                JSFLibraryWizard.this.cboVersions.add(ver.getName());
            }
        }

        private String[] openExtJarFileDialog(String existing) {
            String title = Messages.JSFLibraryWizard_ExtJarFileDialogTitle;
            FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
            dialog.setText(title);
            dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
            String filterPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath().toString();
            dialog.setFilterPath(filterPath);
            String res = dialog.open();
            if (res == null) {
                return null;
            }
            String[] fileNames = dialog.getFileNames();
            String[] elems = new String[fileNames.length];
            Path file = new Path(res);
            IPath apath = file.removeLastSegments(1);
            int i = 0;
            while (i < fileNames.length) {
                elems[i] = apath.append(fileNames[i]).toString();
                ++i;
            }
            return elems;
        }

        public void modifyText(ModifyEvent e) {
            JSFLibraryWizard.this.modified = true;
            this.validate();
            this.updateButtons();
        }

        public void widgetSelected(SelectionEvent e) {
            JSFLibraryWizard.this.modified = true;
            this.validate();
            this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void validate() {
            if (this.initing) {
                return;
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
            if (!(this.validateName() && this.validateJars() && this.validateVersion())) {
                this.setPageComplete(false);
            }
        }

        private boolean validateJars() {
            if (JSFLibraryWizard.this.getJSFLibrary().getArchiveFiles().isEmpty()) {
                this.setErrorMessage(Messages.JSFLibraryWizard_ValidateNoJars);
                return false;
            }
            return true;
        }

        private boolean validateVersion() {
            return true;
        }

        private boolean validateName() {
            if (JSFLibraryWizard.this.txtName.getText() == null || JSFLibraryWizard.this.txtName.getText().trim().equals("")) {
                this.setErrorMessage(Messages.JSFLibraryWizard_ValidateNoLibraryName);
                return false;
            }
            String aName = JSFLibraryWizard.this.txtName.getText().trim();
            if ((JSFLibraryWizard.this.isNew || !JSFLibraryWizard.this.isNew && !JSFLibraryWizard.this.curLibrary.getName().equals(aName)) && this.isNameInRegistry((Collection)JSFCorePlugin.getDefault().getJSFLibraryRegistry().getAllJSFLibraries(), aName)) {
                this.setErrorMessage(Messages.JSFLibraryWizard_ValidateExistingLibraryName);
                return false;
            }
            return true;
        }

        private boolean isNameInRegistry(Collection c, String name) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                JSFLibrary lib = (JSFLibrary)it.next();
                if (!lib.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        static /* synthetic */ String[] access$0(JSFLibraryWizardPage jSFLibraryWizardPage, String string) {
            return jSFLibraryWizardPage.openExtJarFileDialog(string);
        }

        static /* synthetic */ void access$1(JSFLibraryWizardPage jSFLibraryWizardPage) {
            jSFLibraryWizardPage.validate();
        }

        static /* synthetic */ JSFLibraryWizard access$2(JSFLibraryWizardPage jSFLibraryWizardPage) {
            return jSFLibraryWizardPage.JSFLibraryWizard.this;
        }
    }
}

