/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.api.mapping;

import org.eclipse.vorto.codegen.api.mapping.IMapped;
import org.eclipse.vorto.core.api.model.mapping.Attribute;
import org.eclipse.vorto.core.api.model.mapping.StereoTypeTarget;

public class DefaultMapped<T>
implements IMapped<T> {
    private T source;
    private StereoTypeTarget stereoType;

    public DefaultMapped(T source, StereoTypeTarget stereoType) {
        this.source = source;
        this.stereoType = stereoType;
    }

    @Override
    public T getSource() {
        return this.source;
    }

    @Override
    public String getStereoType() {
        return this.stereoType.getName();
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        for (Attribute attribute : this.stereoType.getAttributes()) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAttributeValue(String attributeName, String defaultValue) {
        for (Attribute attribute : this.stereoType.getAttributes()) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            return attribute.getValue();
        }
        return defaultValue;
    }
}

