/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.bosch.things;

import org.eclipse.vorto.codegen.api.ChainedCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.bosch.things.tasks.ValidationTaskFactory;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.Fault;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class BoschIoTThingsGenerator
implements IVortoCodeGenerator {
    public static final String JSON_SCHEMA_FILE_EXTENSION = ".schema.json";
    public static final String TARGET_PATH = "feature";

    public IGenerationResult generate(InformationModel infomodel, InvocationContext invocationContext) {
        GenerationResultZip zipOutputter = new GenerationResultZip(infomodel, this.getServiceKey());
        for (FunctionblockProperty fbp : infomodel.getProperties()) {
            FunctionBlock fb = fbp.getType().getFunctionblock();
            this.generateForFunctionblock(fb, invocationContext, "feature/" + fbp.getType().getNamespace() + "." + fbp.getType().getName() + "_" + fbp.getType().getVersion(), JSON_SCHEMA_FILE_EXTENSION, (IGeneratedWriter)zipOutputter);
        }
        return zipOutputter;
    }

    public void generateForFunctionblock(FunctionBlock fb, InvocationContext context, String targetPath, String jsonFileExt, IGeneratedWriter outputter) {
        Fault fault;
        Status status;
        if (fb == null) {
            throw new RuntimeException("fb is null");
        }
        String stateTargetPath = String.valueOf(targetPath) + "/state";
        String operationTargetPath = String.valueOf(targetPath) + "/operations";
        String eventTargetPath = String.valueOf(targetPath) + "/events";
        Configuration configuration = fb.getConfiguration();
        if (configuration != null) {
            this.generateTask(configuration, context, outputter, ValidationTaskFactory.getConfigurationValidationTask(jsonFileExt, stateTargetPath));
        }
        if ((status = fb.getStatus()) != null) {
            this.generateTask(status, context, outputter, ValidationTaskFactory.getStatusValidationTask(jsonFileExt, stateTargetPath));
        }
        if ((fault = fb.getFault()) != null) {
            this.generateTask(fault, context, outputter, ValidationTaskFactory.getFaultValidationTask(jsonFileExt, stateTargetPath));
        }
        if (configuration != null || status != null || fault != null) {
            this.generateTask(fb, context, outputter, ValidationTaskFactory.getStateValidationTask(jsonFileExt, stateTargetPath));
        }
        if (fb.getEvents() != null) {
            for (Event event : fb.getEvents()) {
                this.generateTask(event, context, outputter, ValidationTaskFactory.getEventValidationTask(jsonFileExt, eventTargetPath));
            }
        }
        if (fb.getOperations() != null) {
            for (Operation op : fb.getOperations()) {
                this.generateTask(op, context, outputter, ValidationTaskFactory.getOperationParametersValidationTask(jsonFileExt, operationTargetPath), ValidationTaskFactory.getOperationReturnTypeValidationTask(jsonFileExt, operationTargetPath));
            }
        }
    }

    private <K> void generateTask(K element, InvocationContext context, IGeneratedWriter outputter, ICodeGeneratorTask<K> ... tasks) {
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        ICodeGeneratorTask<K>[] iCodeGeneratorTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ICodeGeneratorTask<K> task = iCodeGeneratorTaskArray[n2];
            generator.addTask(task);
            ++n2;
        }
        generator.generate(element, context, outputter);
    }

    public String getServiceKey() {
        return "boschiotthings";
    }
}

