/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.function;

import com.google.common.base.Function;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import org.eclipse.vorto.repository.model.ServerResponseView;
import org.eclipse.vorto.repository.model.UploadResultView;

public class StringToUploadResult
implements Function<String, UploadResultView> {
    private Gson gson = new GsonBuilder().create();

    public UploadResultView apply(String input) {
        List<UploadResultView> result = ((ServerResponseView)this.gson.fromJson(input, ServerResponseView.class)).getObj();
        if (result == null) {
            return this.handlePreviousVersionUploadResult(input);
        }
        return result.get(0);
    }

    private UploadResultView handlePreviousVersionUploadResult(String input) {
        UploadResultView uploadResult = null;
        try {
            uploadResult = (UploadResultView)this.gson.fromJson(input, UploadResultView.class);
            if (uploadResult != null) {
                return uploadResult;
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return this.emptyUploadResult();
    }

    private UploadResultView emptyUploadResult() {
        UploadResultView errorResult = new UploadResultView();
        errorResult.setErrorMessage("Error while uploading to remote repository.");
        errorResult.setValid(false);
        return errorResult;
    }
}

