/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.validation;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;

public class ValidatorUtils {
    public static final ModelTypeBasedChildrenSupplier entityTypeToChildrenSupplierFunction = ValidatorUtils.newModelTypeChildrenSupplier(ValidatorUtils.newEntityToFunctionMap());

    public static EObject getParentOfType(EObject obj, Class<?> type) {
        boolean _equals = Objects.equal((Object)obj, null);
        if (_equals) {
            return null;
        }
        boolean _isInstance = type.isInstance(obj);
        if (_isInstance) {
            return obj;
        }
        EObject _eContainer = obj.eContainer();
        return ValidatorUtils.getParentOfType(_eContainer, type);
    }

    public static boolean hasCircularReference(Model parent, Model child, ModelTypeBasedChildrenSupplier modelTypeChildrenSupplier) {
        boolean _notEquals;
        boolean _isEquals = ValidatorUtils.isEquals(parent, child);
        if (_isEquals) {
            return true;
        }
        Class<?> _class = child.getClass();
        Function childrenSupplier = (Function)modelTypeChildrenSupplier.apply(_class);
        boolean bl = _notEquals = !Objects.equal((Object)childrenSupplier, null);
        if (_notEquals) {
            Collection _apply = (Collection)childrenSupplier.apply((Object)child);
            for (Model childrenOfChildren : _apply) {
                boolean _hasCircularReference = ValidatorUtils.hasCircularReference(parent, childrenOfChildren, modelTypeChildrenSupplier);
                if (!_hasCircularReference) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEquals(Model a, Model b) {
        if (a instanceof Entity && b instanceof Entity || a instanceof Enum && b instanceof Enum || a instanceof FunctionblockModel && b instanceof FunctionblockModel || a instanceof InformationModel && b instanceof InformationModel) {
            String _namespace_1;
            boolean _and = false;
            boolean _and_1 = false;
            String _namespace = a.getNamespace();
            boolean _equals = _namespace.equals(_namespace_1 = b.getNamespace());
            if (!_equals) {
                _and_1 = false;
            } else {
                boolean _equals_1;
                String _name = a.getName();
                String _name_1 = b.getName();
                _and_1 = _equals_1 = _name.equals(_name_1);
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_2;
                String _version = a.getVersion();
                String _version_1 = b.getVersion();
                _and = _equals_2 = _version.equals(_version_1);
            }
            return _and;
        }
        return false;
    }

    private static HashMap<Class<?>, Function<Model, Collection<Model>>> newEntityToFunctionMap() {
        HashMap entityToFunctionMap = new HashMap();
        EntityChildrenSupplier _entityChildrenSupplier = new EntityChildrenSupplier();
        entityToFunctionMap.put(Entity.class, _entityChildrenSupplier);
        return entityToFunctionMap;
    }

    public static ModelTypeBasedChildrenSupplier newModelTypeChildrenSupplier(final Map<Class<?>, Function<Model, Collection<Model>>> entityToFunctionMap) {
        return new ModelTypeBasedChildrenSupplier(){

            public Function<Model, Collection<Model>> apply(Class<?> input) {
                Set _entrySet = entityToFunctionMap.entrySet();
                for (Map.Entry entry : _entrySet) {
                    Class _key = (Class)entry.getKey();
                    boolean _isAssignableFrom = _key.isAssignableFrom(input);
                    if (!_isAssignableFrom) continue;
                    return (Function)entry.getValue();
                }
                return null;
            }
        };
    }

    public static abstract class AbstractChildrenSupplier
    implements Function<Model, Collection<Model>> {
        public Collection<Model> getReferenceModels(Collection<Property> properties) {
            ArrayList models = Lists.newArrayList();
            for (Property property : properties) {
                PropertyType _type = property.getType();
                Collection<Model> _referenceModels = this.getReferenceModels(_type);
                models.addAll(_referenceModels);
            }
            return models;
        }

        public Collection<Model> getReferenceModels(PropertyType type) {
            ArrayList models = Lists.newArrayList();
            if (type instanceof ObjectPropertyType) {
                ObjectPropertyType propertyType = (ObjectPropertyType)type;
                Type _type = propertyType.getType();
                models.add(_type);
            } else if (type instanceof DictionaryPropertyType) {
                DictionaryPropertyType dictionaryType = (DictionaryPropertyType)type;
                PropertyType _keyType = dictionaryType.getKeyType();
                Collection<Model> _referenceModels = this.getReferenceModels(_keyType);
                models.addAll(_referenceModels);
                PropertyType _valueType = dictionaryType.getValueType();
                Collection<Model> _referenceModels_1 = this.getReferenceModels(_valueType);
                models.addAll(_referenceModels_1);
            }
            return models;
        }
    }

    public static class EntityChildrenSupplier
    extends AbstractChildrenSupplier {
        public Collection<Model> apply(Model input) {
            boolean _notEquals;
            ArrayList children = Lists.newArrayList();
            Entity parent = (Entity)input;
            Entity _superType = parent.getSuperType();
            boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
            if (_notEquals) {
                Entity _superType_1 = parent.getSuperType();
                children.add(_superType_1);
            }
            EList _properties = parent.getProperties();
            Collection<Model> _referenceModels = this.getReferenceModels((Collection<Property>)_properties);
            children.addAll(_referenceModels);
            return children;
        }
    }

    public static interface ModelTypeBasedChildrenSupplier
    extends Function<Class<?>, Function<Model, Collection<Model>>> {
    }
}

