/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.model;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.vorto.core.api.model.model.ModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;

public class ModelId
implements Comparable<ModelId> {
    private static final String UNDERSCORE = "_";
    private ModelType modelType;
    private String name;
    private String namespace;
    private String version;

    public ModelId(ModelType modelType, String name, String namespace, String version) {
        this.modelType = modelType;
        this.name = name;
        this.namespace = namespace;
        this.version = version;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public ModelReference asModelReference() {
        ModelReference modelReference = ModelFactory.eINSTANCE.createModelReference();
        modelReference.setImportedNamespace(String.valueOf(this.namespace) + "." + this.name);
        modelReference.setVersion(this.version);
        return modelReference;
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append("modelType=" + (Object)((Object)this.modelType));
        sb.append(",namespace=" + this.namespace);
        sb.append(",name=" + this.name);
        sb.append(",version=" + this.version);
        return sb.toString();
    }

    public String toString() {
        return "ModelId [modelType=" + (Object)((Object)this.modelType) + ", name=" + this.name + ", namespace=" + this.namespace + ", version=" + this.version + "]";
    }

    @Override
    public int compareTo(ModelId o) {
        if (o == null || o.getName() == null) {
            return -1;
        }
        return o.getName().compareTo(this.getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.modelType == null ? 0 : this.modelType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelId other = (ModelId)obj;
        if (this.modelType != other.modelType) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getFileName() {
        return String.valueOf(this.namespace) + UNDERSCORE + this.name + UNDERSCORE + this.delimitVersion(this.version) + this.getModelType().getExtension();
    }

    private String delimitVersion(String version) {
        return StringUtils.replace((String)version, (String)".", (String)UNDERSCORE);
    }
}

