/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.vorto.core.api.repository.Attachment;
import org.eclipse.vorto.core.api.repository.AuthenticationException;
import org.eclipse.vorto.core.api.repository.CheckInModelException;
import org.eclipse.vorto.core.api.repository.ConfigurationException;
import org.eclipse.vorto.core.api.repository.RepositoryException;
import org.eclipse.vorto.repository.Activator;
import org.eclipse.vorto.repository.ConnectionInfo;
import org.eclipse.vorto.repository.HttpStatus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RestClient {
    private ConnectionInfo connectionInfo;
    private static final String RESOURCE_URL = "/rest/";

    public RestClient(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public <Result> Result executeGet(String query, final Function<String, Result> responseConverter) throws ClientProtocolException, IOException {
        ProxyConfiguration proxyProvider = this.getProxyConfiguration();
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(proxyProvider.credentialsProvider).build();
        HttpUriRequest request = RequestBuilder.get().setConfig(proxyProvider.requestConfig).setUri(this.createQuery(query)).build();
        return (Result)client.execute(request, (ResponseHandler)new DefaultResponseHandler<Result>(this){

            @Override
            public Result handleSuccess(HttpResponse response) throws ClientProtocolException, IOException {
                return responseConverter.apply((Object)IOUtils.toString((InputStream)response.getEntity().getContent()));
            }
        });
    }

    public Attachment executeGetAttachment(String query) throws ClientProtocolException, IOException {
        ProxyConfiguration proxyProvider = this.getProxyConfiguration();
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(proxyProvider.credentialsProvider).build();
        HttpUriRequest request = RequestBuilder.get().setConfig(proxyProvider.requestConfig).setUri(this.createQuery(query)).build();
        return (Attachment)client.execute(request, (ResponseHandler)new DefaultResponseHandler<Attachment>(this){

            @Override
            public Attachment handleSuccess(HttpResponse response) throws ClientProtocolException, IOException {
                String content_disposition = response.getFirstHeader("Content-Disposition").getValue();
                String filename = content_disposition.substring(content_disposition.indexOf("filename = ") + "filename = ".length());
                long length = response.getEntity().getContentLength();
                String type = response.getEntity().getContentType().toString();
                byte[] content = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
                return new Attachment(filename, length, type, content);
            }
        });
    }

    public <Result> Result executePost(String query, HttpEntity content, final Function<String, Result> responseConverter) throws ClientProtocolException, IOException {
        ProxyConfiguration proxyProvider = this.getProxyConfiguration();
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(proxyProvider.credentialsProvider).build();
        HttpUriRequest request = RequestBuilder.post().setConfig(proxyProvider.requestConfig).setUri(this.createQuery(query)).addHeader(this.createSecurityHeader()).setEntity(content).build();
        return (Result)client.execute(request, (ResponseHandler)new DefaultResponseHandler<Result>(this){

            @Override
            public Result handleSuccess(HttpResponse response) throws ClientProtocolException, IOException {
                return responseConverter.apply((Object)IOUtils.toString((InputStream)response.getEntity().getContent()));
            }

            @Override
            protected Result handleFailure(HttpResponse response) throws ClientProtocolException, IOException {
                throw new CheckInModelException("Error in uploading file to remote repository");
            }
        });
    }

    public void executePut(String query) throws ClientProtocolException, IOException {
        ProxyConfiguration proxyProvider = this.getProxyConfiguration();
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(proxyProvider.credentialsProvider).build();
        HttpUriRequest request = RequestBuilder.put().setConfig(proxyProvider.requestConfig).setUri(this.createQuery(query)).addHeader(this.createSecurityHeader()).build();
        client.execute(request);
    }

    private String createQuery(String queryFragment) {
        StringBuilder connectionUrl = new StringBuilder();
        connectionUrl.append(this.connectionInfo.getUrl()).append(RESOURCE_URL);
        if (!Strings.isNullOrEmpty((String)queryFragment)) {
            connectionUrl.append(queryFragment);
        }
        return connectionUrl.toString();
    }

    private ProxyConfiguration getProxyConfiguration() {
        IProxyService proxyService = RestClient.getProxyService();
        IProxyData[] proxyDataForHost = proxyService.select(URI.create(this.connectionInfo.getUrl()));
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        IProxyData[] iProxyDataArray = proxyDataForHost;
        int n = proxyDataForHost.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            if (!Strings.isNullOrEmpty((String)data.getHost())) {
                HttpHost proxyConfig = new HttpHost(data.getHost(), data.getPort(), data.getType());
                configBuilder.setProxy(proxyConfig);
                if (!Strings.isNullOrEmpty((String)data.getUserId())) {
                    credsProvider.setCredentials(new AuthScope(data.getHost(), data.getPort()), (Credentials)new UsernamePasswordCredentials(data.getUserId(), data.getPassword()));
                }
            }
            ++n2;
        }
        return new ProxyConfiguration(configBuilder.build(), (CredentialsProvider)credsProvider);
    }

    private static IProxyService getProxyService() {
        BundleContext bc = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bc.getServiceReference(IProxyService.class.getName());
        IProxyService service = (IProxyService)bc.getService(serviceReference);
        return service;
    }

    private Header createSecurityHeader() {
        return new BasicHeader("Authorization", "Basic " + this.createAuth());
    }

    private String createAuth() {
        return new String(Base64.encodeBase64((byte[])(String.valueOf(this.connectionInfo.getUserName()) + ":" + this.connectionInfo.getPassword()).getBytes()));
    }

    private abstract class DefaultResponseHandler<T>
    implements ResponseHandler<T> {
        private DefaultResponseHandler() {
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                return this.handleSuccess(response);
            }
            if (statusCode == 401) {
                throw new AuthenticationException();
            }
            if (statusCode == 400 || statusCode == 404) {
                throw new ConfigurationException();
            }
            return this.handleFailure(response);
        }

        protected T handleFailure(HttpResponse response) throws ClientProtocolException, IOException {
            HttpStatus status = HttpStatus.statusFor(response.getStatusLine().getStatusCode());
            throw new RepositoryException("Error : request returned the status code: " + status.getCode() + " - " + status.getMessage());
        }

        protected abstract T handleSuccess(HttpResponse var1) throws ClientProtocolException, IOException;
    }

    private class ProxyConfiguration {
        private RequestConfig requestConfig;
        private CredentialsProvider credentialsProvider;

        public ProxyConfiguration(RequestConfig requestConfig, CredentialsProvider credentialsProvider) {
            this.requestConfig = requestConfig;
            this.credentialsProvider = credentialsProvider;
        }
    }
}

