/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.command;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.perspective.util.ImageUtil;
import org.eclipse.vorto.perspective.view.ILocalModelWorkspace;

public abstract class DeleteModelAction
extends Action {
    private ILocalModelWorkspace workspace;

    public DeleteModelAction(ILocalModelWorkspace workspace) {
        super("Delete", ImageDescriptor.createFromImage((Image)ImageUtil.getImage("delete.gif")));
        this.workspace = workspace;
    }

    public static Action newInstance(ILocalModelWorkspace workspace, final TreeViewer viewer, final IModelElement model) {
        return new DeleteModelAction(workspace){

            @Override
            protected TreeViewer getViewer() {
                return viewer;
            }

            @Override
            protected IModelElement getSelectedElement() {
                return model;
            }
        };
    }

    public void run() {
        IModelElement modelElement = this.getSelectedElement();
        boolean isOKOrYes = MessageDialog.open((int)3, (Shell)this.getViewer().getControl().getShell(), (String)"Delete Model", (String)("Are you sure you want to delete the model " + modelElement.getId().getName() + " ?"), (int)0);
        if (isOKOrYes) {
            this.deleteResource(this.getViewer().getControl().getShell(), (IResource)modelElement.getModelFile());
        }
    }

    private void deleteResource(Shell shell, final IResource selectedResource) {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        try {
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Delete Model", 100);
                    try {
                        selectedResource.delete(true, monitor);
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract IModelElement getSelectedElement();

    protected abstract TreeViewer getViewer();
}

