/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.coap.client.templates;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.coap.CoAPUtils;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CoAPClientOperationTemplate
implements ITemplate<Operation> {
    private String primitiveTypeWrapper_suffix;
    private String paramSet_suffix;
    private ITemplate<Param> parameterTemplate;

    public CoAPClientOperationTemplate(String primitiveTypeWrapper_suffix, String paramSet_suffix, ITemplate<Param> parameterTemplate) {
        this.primitiveTypeWrapper_suffix = primitiveTypeWrapper_suffix;
        this.paramSet_suffix = paramSet_suffix;
        this.parameterTemplate = parameterTemplate;
    }

    public String getContent(Operation op, InvocationContext invocationContext) {
        boolean _notEquals_2;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* ");
        String _description = op.getDescription();
        _builder.append((Object)_description, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        boolean _or = false;
        ReturnType _returnType = op.getReturnType();
        if (_returnType instanceof ReturnObjectType) {
            _or = true;
        } else {
            boolean _equals;
            ReturnType _returnType_1 = op.getReturnType();
            _or = _equals = Objects.equal((Object)_returnType_1, null);
        }
        if (_or) {
            _builder.append((Object)"public ");
            String _returnTypeAsString = CoAPUtils.getReturnTypeAsString(op);
            _builder.append((Object)_returnTypeAsString, "");
            _builder.append((Object)" ");
            String _name = op.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"(");
            String _parameterString = this.getParameterString(op, invocationContext);
            _builder.append((Object)_parameterString, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"public ");
            String _returnTypeAsString_1 = CoAPUtils.getReturnTypeAsString(op);
            _builder.append((Object)_returnTypeAsString_1, "");
            _builder.append((Object)" ");
            String _name_1 = op.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"(");
            String _parameterString_1 = this.getParameterString(op, invocationContext);
            _builder.append((Object)_parameterString_1, "");
            _builder.append((Object)") throws Exception {");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList _params = op.getParams();
        boolean _isEmpty = _params.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _notEquals;
            _builder.append((Object)"\t");
            String _name_2 = op.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper, "\t");
            _builder.append((Object)this.paramSet_suffix, "\t");
            _builder.append((Object)" paramSet = new ");
            String _name_3 = op.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper_1, "\t");
            _builder.append((Object)"ParamSet();");
            _builder.newLineIfNotEmpty();
            EList _params_1 = op.getParams();
            for (Param param : _params_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"paramSet.set");
                String _name_4 = param.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_4);
                _builder.append((Object)_firstUpper_2, "\t");
                _builder.append((Object)"(");
                String _name_5 = param.getName();
                _builder.append((Object)_name_5, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"byte[] payload = Client.serializePayload(paramSet);");
            _builder.newLine();
            ReturnType _returnType_2 = op.getReturnType();
            boolean bl2 = _notEquals = !Objects.equal((Object)_returnType_2, null);
            if (_notEquals) {
                _builder.append((Object)"\t");
                _builder.append((Object)"final Response response = Client.sendRequest(BASE_URI + \"/\" + \"");
                String _name_6 = op.getName();
                String _firstLower = StringExtensions.toFirstLower((String)_name_6);
                _builder.append((Object)_firstLower, "\t");
                _builder.append((Object)"\", CoapMethod.POST, payload);");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"Client.sendRequest(BASE_URI + \"/\" + \"");
                String _name_7 = op.getName();
                String _firstLower_1 = StringExtensions.toFirstLower((String)_name_7);
                _builder.append((Object)_firstLower_1, "\t");
                _builder.append((Object)"\", CoapMethod.POST, payload);");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _notEquals_1;
            ReturnType _returnType_3 = op.getReturnType();
            boolean bl3 = _notEquals_1 = !Objects.equal((Object)_returnType_3, null);
            if (_notEquals_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"final Response response = Client.sendRequest(BASE_URI + \"/\" + \"");
                String _name_8 = op.getName();
                String _firstLower_2 = StringExtensions.toFirstLower((String)_name_8);
                _builder.append((Object)_firstLower_2, "\t");
                _builder.append((Object)"\", CoapMethod.POST);");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"Client.sendRequest(BASE_URI + \"/\" + \"");
                String _name_9 = op.getName();
                String _firstLower_3 = StringExtensions.toFirstLower((String)_name_9);
                _builder.append((Object)_firstLower_3, "\t");
                _builder.append((Object)"\", CoapMethod.POST, payload);");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        ReturnType _returnType_4 = op.getReturnType();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_returnType_4, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t");
            _builder.append((Object)"if(response != null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if(response.getCode().value < 100) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if(response.getPayloadSize() > 0) {");
            _builder.newLine();
            ReturnType _returnType_5 = op.getReturnType();
            if (_returnType_5 instanceof ReturnObjectType) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                String returnType = CoAPUtils.getReturnTypeAsString(op);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"final Object o = Client.deserializePayload(");
                _builder.append((Object)returnType, "\t\t\t\t");
                _builder.append((Object)".class, response.getPayload());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if(o instanceof ");
                _builder.append((Object)returnType, "\t\t\t\t");
                _builder.append((Object)"){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return (");
                _builder.append((Object)returnType, "\t\t\t\t\t");
                _builder.append((Object)") o;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"final Object o = Client.deserializePayload(");
                String _name_10 = op.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_10);
                _builder.append((Object)_firstUpper_3, "\t\t\t\t");
                _builder.append((Object)this.primitiveTypeWrapper_suffix, "\t\t\t\t");
                _builder.append((Object)".class, response.getPayload());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if(o instanceof ");
                String _name_11 = op.getName();
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_11);
                _builder.append((Object)_firstUpper_4, "\t\t\t\t");
                _builder.append((Object)this.primitiveTypeWrapper_suffix, "\t\t\t\t");
                _builder.append((Object)"){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"final ");
                String _name_12 = op.getName();
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_12);
                _builder.append((Object)_firstUpper_5, "\t\t\t\t\t");
                _builder.append((Object)this.primitiveTypeWrapper_suffix, "\t\t\t\t\t");
                _builder.append((Object)" result = (");
                String _name_13 = op.getName();
                String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_13);
                _builder.append((Object)_firstUpper_6, "\t\t\t\t\t");
                _builder.append((Object)this.primitiveTypeWrapper_suffix, "\t\t\t\t\t");
                _builder.append((Object)") o;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return result.getValue();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            ReturnType _returnType_6 = op.getReturnType();
            if (_returnType_6 instanceof ReturnObjectType) {
                _builder.append((Object)"\t");
                _builder.append((Object)"return null;");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"throw new Exception(\"Request failed!\");");
                _builder.newLine();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    public String getParameterString(Operation op, InvocationContext invocationContext) {
        String result = "";
        EList _params = op.getParams();
        for (Param param : _params) {
            String _plus;
            String _content = this.parameterTemplate.getContent((Object)param, invocationContext);
            result = _plus = String.valueOf(result) + ", " + _content;
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)result);
        if (_isNullOrEmpty) {
            return "";
        }
        int _length = result.length();
        String _substring = result.substring(2, _length);
        String _replaceAll = _substring.replaceAll("\n", "");
        return _replaceAll.replaceAll("\r", "");
    }
}

