/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.url;

import org.eclipse.virgo.snaps.core.internal.webapp.url.ImmutablePathTranslation;
import org.eclipse.virgo.snaps.core.internal.webapp.url.PathTranslation;
import org.eclipse.virgo.snaps.core.internal.webapp.url.UrlPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExactUrlPattern
implements UrlPattern {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String pattern;

    public ExactUrlPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matches(String path) {
        boolean matches = this.pattern.equals(path);
        if (matches) {
            this.logger.info("Path '{}' matches pattern '{}'", (Object)path, (Object)this.pattern);
        } else {
            this.logger.info("Path '{}' does not match pattern '{}'", (Object)path, (Object)this.pattern);
        }
        return matches;
    }

    @Override
    public PathTranslation translate(String servletPath) {
        this.logger.info("Did not translate path '{}'", (Object)servletPath);
        return new ImmutablePathTranslation(servletPath, null);
    }
}

