/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.equinox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Stack;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.virgo.kernel.equinox.extensions.hooks.BundleFileWrapper;
import org.eclipse.virgo.kernel.osgi.framework.ImportExpander;
import org.eclipse.virgo.kernel.osgi.framework.ManifestTransformer;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;

public class TransformedManifestProvidingBundleFileWrapper
implements BundleFileWrapper {
    private final ImportExpander importExpander;
    private final ThreadLocal<Stack<ManifestTransformer>> manifestTransformer = new ManifestTransformerStackThreadLocal();

    public TransformedManifestProvidingBundleFileWrapper(ImportExpander importExpander) {
        this.importExpander = importExpander;
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile) {
        return new TransformedManifestProvidingBundleFile(bundleFile, this.importExpander);
    }

    public void pushManifestTransformer(ManifestTransformer manifestTransformer) {
        this.manifestTransformer.get().push(manifestTransformer);
    }

    public void popManifestTransformer() {
        this.manifestTransformer.get().pop();
    }

    private static final class ManifestTransformerStackThreadLocal
    extends ThreadLocal<Stack<ManifestTransformer>> {
        private ManifestTransformerStackThreadLocal() {
        }

        @Override
        public Stack<ManifestTransformer> initialValue() {
            return new Stack<ManifestTransformer>();
        }
    }

    private static class TransformedManifestBundleEntry
    extends BundleEntry {
        private final byte[] manifestBytes;
        private final long time;

        private TransformedManifestBundleEntry(BundleManifest transformedManifest) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformedManifest.write((Writer)new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
            this.manifestBytes = baos.toByteArray();
            this.time = System.currentTimeMillis();
        }

        public URL getFileURL() {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.manifestBytes);
        }

        public URL getLocalURL() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "MANIFEST.MF";
        }

        public long getSize() {
            return this.manifestBytes.length;
        }

        public long getTime() {
            return this.time;
        }
    }

    private class TransformedManifestProvidingBundleFile
    extends BundleFile {
        private final BundleFile bundleFile;
        private final ImportExpander importExpander;
        private volatile BundleEntry manifestEntry;
        private final Object monitor = new Object();

        private TransformedManifestProvidingBundleFile(BundleFile bundleFile, ImportExpander importExpander) {
            this.bundleFile = bundleFile;
            this.importExpander = importExpander;
        }

        public void close() throws IOException {
            this.bundleFile.close();
        }

        public boolean containsDir(String dir) {
            return this.bundleFile.containsDir(dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BundleEntry getEntry(String path) {
            if (path.equals("META-INF/MANIFEST.MF")) {
                Object object = this.monitor;
                synchronized (object) {
                    if (this.manifestEntry == null) {
                        BundleManifest originalManifest;
                        ManifestTransformer manifestTransformer;
                        block22: {
                            BundleEntry entry = this.bundleFile.getEntry(path);
                            Stack manifestTransformers = (Stack)TransformedManifestProvidingBundleFileWrapper.this.manifestTransformer.get();
                            manifestTransformer = !manifestTransformers.isEmpty() ? (ManifestTransformer)manifestTransformers.peek() : null;
                            if (entry != null) {
                                try {
                                    Throwable throwable = null;
                                    Object var8_9 = null;
                                    try (InputStreamReader manifestReader = new InputStreamReader(entry.getInputStream(), StandardCharsets.UTF_8);){
                                        originalManifest = BundleManifestFactory.createBundleManifest((Reader)manifestReader);
                                        break block22;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException ioe) {
                                    throw new RuntimeException(ioe);
                                }
                            }
                            originalManifest = BundleManifestFactory.createBundleManifest();
                        }
                        BundleManifest transformedManifest = originalManifest;
                        if (manifestTransformer != null) {
                            transformedManifest = manifestTransformer.transform(originalManifest);
                        }
                        try {
                            this.importExpander.expandImports(Collections.singletonList(transformedManifest));
                        }
                        catch (UnableToSatisfyDependenciesException utsde) {
                            throw new RuntimeException(utsde);
                        }
                        try {
                            this.manifestEntry = new TransformedManifestBundleEntry(transformedManifest);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                return this.manifestEntry;
            }
            return this.bundleFile.getEntry(path);
        }

        public Enumeration getEntryPaths(String path) {
            return this.bundleFile.getEntryPaths(path);
        }

        public File getFile(String path, boolean nativeCode) {
            return this.bundleFile.getFile(path, nativeCode);
        }

        public void open() throws IOException {
            this.bundleFile.open();
        }

        public File getBaseFile() {
            return this.bundleFile.getBaseFile();
        }

        public URL getResourceURL(String path, long hostBundleID, int index) {
            return this.bundleFile.getResourceURL(path, hostBundleID, index);
        }

        public URL getResourceURL(String path, long hostBundleID) {
            return this.bundleFile.getResourceURL(path, hostBundleID);
        }

        public URL getResourceURL(String path, BaseData hostData, int index) {
            return this.bundleFile.getResourceURL(path, hostData, index);
        }
    }
}

