/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import org.eclipse.virgo.kernel.deployer.model.GCRoots;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;

public final class ExistingNodeLocator
implements GraphNode.DirectedAcyclicGraphVisitor<InstallArtifact> {
    private final String scopeName;
    private GraphNode<InstallArtifact> foundNode = null;
    private final String type;
    private final String name;
    private final VersionRange versionRange;

    public static GraphNode<InstallArtifact> findSharedNode(GCRoots gcRoots, ArtifactIdentity artifactIdentity) {
        ExistingNodeLocator visitor = new ExistingNodeLocator(artifactIdentity.getType(), artifactIdentity.getName(), VersionRange.createExactRange((Version)artifactIdentity.getVersion()), artifactIdentity.getScopeName());
        for (InstallArtifact gcRoot : gcRoots) {
            gcRoot.getGraph().visit((GraphNode.DirectedAcyclicGraphVisitor)visitor);
        }
        return visitor.getFoundNode();
    }

    public static GraphNode<InstallArtifact> findSharedNode(GCRoots gcRoots, String type, String name, VersionRange versionRange, String scopeName) {
        ExistingNodeLocator visitor = new ExistingNodeLocator(type, name, versionRange, scopeName);
        for (InstallArtifact gcRoot : gcRoots) {
            gcRoot.getGraph().visit((GraphNode.DirectedAcyclicGraphVisitor)visitor);
        }
        return visitor.getFoundNode();
    }

    public static GraphNode<InstallArtifact> findSharedNode(GCRoots gcRoots, GraphNode<InstallArtifact> installGraph) {
        InstallArtifact installArtifact = (InstallArtifact)installGraph.getValue();
        ArtifactIdentity artifactIdentity = new ArtifactIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), installArtifact.getScopeName());
        return ExistingNodeLocator.findSharedNode(gcRoots, artifactIdentity);
    }

    ExistingNodeLocator(@NonNull String type, @NonNull String name, @NonNull VersionRange versionRange, String scopeName) {
        this.type = type;
        this.name = name;
        this.versionRange = versionRange;
        this.scopeName = scopeName;
    }

    public boolean visit(GraphNode<InstallArtifact> node) {
        InstallArtifact candidate = (InstallArtifact)node.getValue();
        if (this.foundNode == null && this.matches(candidate)) {
            this.foundNode = node;
        }
        return this.foundNode == null;
    }

    private boolean matches(InstallArtifact candidate) {
        return candidate.getType().equals(this.type) && candidate.getName().equals(this.name) && (this.scopeName == null && candidate.getScopeName() == null || this.scopeName != null && this.scopeName.equals(candidate.getScopeName())) && this.versionRange.includes(candidate.getVersion());
    }

    public GraphNode<InstallArtifact> getFoundNode() {
        return this.foundNode;
    }
}

