/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.Assert;

public class PortletContextScope
implements Scope,
DisposableBean {
    private final PortletContext portletContext;
    private final Map<String, Runnable> destructionCallbacks = new LinkedHashMap<String, Runnable>();

    public PortletContextScope(PortletContext portletContext) {
        Assert.notNull((Object)portletContext, (String)"PortletContext must not be null");
        this.portletContext = portletContext;
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Object scopedObject = this.portletContext.getAttribute(name);
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            this.portletContext.setAttribute(name, scopedObject);
        }
        return scopedObject;
    }

    public Object remove(String name) {
        Object scopedObject = this.portletContext.getAttribute(name);
        if (scopedObject != null) {
            this.portletContext.removeAttribute(name);
            this.destructionCallbacks.remove(name);
            return scopedObject;
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.destructionCallbacks.put(name, callback);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    public void destroy() {
        for (Runnable runnable : this.destructionCallbacks.values()) {
            runnable.run();
        }
        this.destructionCallbacks.clear();
    }
}

