/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.service.event.TopicPermission;

final class TopicPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -614647783533924048L;
    private final Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof TopicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        TopicPermission tp = (TopicPermission)permission;
        String name = tp.getName();
        int newMask = tp.getActionsMask();
        TopicPermissionCollection topicPermissionCollection = this;
        synchronized (topicPermissionCollection) {
            TopicPermission existing = (TopicPermission)this.permissions.get(name);
            if (existing != null) {
                int oldMask = existing.getActionsMask();
                if (oldMask != newMask) {
                    this.permissions.put(name, new TopicPermission(name, oldMask | newMask));
                }
            } else {
                this.permissions.put(name, tp);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        int last;
        TopicPermission x;
        if (!(permission instanceof TopicPermission)) {
            return false;
        }
        TopicPermission requested = (TopicPermission)permission;
        String name = requested.getName();
        int desired = requested.getActionsMask();
        int effective = 0;
        TopicPermissionCollection topicPermissionCollection = this;
        synchronized (topicPermissionCollection) {
            if (this.all_allowed && (x = (TopicPermission)this.permissions.get("*")) != null && ((effective |= x.getActionsMask()) & desired) == desired) {
                return true;
            }
            x = (TopicPermission)this.permissions.get(name);
        }
        if (x != null && ((effective |= x.getActionsMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf("/", offset)) != -1) {
            name = name.substring(0, last + 1) + "*";
            TopicPermissionCollection topicPermissionCollection2 = this;
            synchronized (topicPermissionCollection2) {
                x = (TopicPermission)this.permissions.get(name);
            }
            if (x != null && ((effective |= x.getActionsMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

