/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.startup;

import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.springframework.osgi.service.importer.OsgiServiceDependency;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;

public class MandatoryServiceDependency
implements OsgiServiceDependency {
    protected final Filter filter;
    protected final String filterAsString;
    protected final boolean isMandatory;
    protected final BundleContext bundleContext;
    private final String beanName;
    private OsgiServiceDependency serviceDependency;

    public MandatoryServiceDependency(BundleContext bc, Filter serviceFilter, boolean isMandatory, String beanName) {
        this.filter = serviceFilter;
        this.filterAsString = this.filter.toString();
        this.isMandatory = isMandatory;
        this.bundleContext = bc;
        this.beanName = beanName;
        this.serviceDependency = new OsgiServiceDependency(){

            public String getBeanName() {
                return MandatoryServiceDependency.this.beanName;
            }

            public Filter getServiceFilter() {
                return MandatoryServiceDependency.this.filter;
            }

            public boolean isMandatory() {
                return MandatoryServiceDependency.this.isMandatory;
            }
        };
    }

    public MandatoryServiceDependency(BundleContext bc, OsgiServiceDependency dependency) {
        this(bc, dependency.getServiceFilter(), dependency.isMandatory(), dependency.getBeanName());
    }

    public boolean matches(ServiceEvent event) {
        return this.filter.match(event.getServiceReference());
    }

    public boolean isServicePresent() {
        return !this.isMandatory || OsgiServiceReferenceUtils.isServicePresent((BundleContext)this.bundleContext, (String)this.filterAsString);
    }

    public String toString() {
        return "Dependency on [" + this.filterAsString + "] (from bean [" + this.beanName + "])";
    }

    public Filter getServiceFilter() {
        return this.filter;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MandatoryServiceDependency that = (MandatoryServiceDependency)o;
        if (this.isMandatory != that.isMandatory) {
            return false;
        }
        return !(this.filterAsString != null ? !this.filterAsString.equals(that.filterAsString) : that.filterAsString != null);
    }

    public int hashCode() {
        int result = this.filterAsString != null ? this.filterAsString.hashCode() : 0;
        result = 29 * result + (this.isMandatory ? 1 : 0);
        return result;
    }

    public OsgiServiceDependency getServiceDependency() {
        return this.serviceDependency;
    }
}

