/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.lifecycle;

import java.util.Objects;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventType;

public class UnmodifiableActivationLifeCycle
extends ActivationLifeCycle {
    protected UnmodifiableActivationLifeCycle(ActivationState inactiveState) {
        super(inactiveState);
    }

    @Override
    public boolean addStateTransition(ActivationState from, EventType event, ActivationState to) {
        throw new UnsupportedOperationException("Life cycle is unmodifiable!");
    }

    protected boolean internalAddStateTransition(ActivationState activationState, EventType eventType, ActivationState activationState2) {
        return super.addStateTransition(activationState, eventType, activationState2);
    }

    public static UnmodifiableActivationLifeCycle copyOf(ActivationLifeCycle lifeCycle) {
        if (lifeCycle instanceof UnmodifiableActivationLifeCycle) {
            return (UnmodifiableActivationLifeCycle)lifeCycle;
        }
        Objects.requireNonNull(lifeCycle, "Null life cycle cannot be copied!");
        UnmodifiableActivationLifeCycle lc = new UnmodifiableActivationLifeCycle(lifeCycle.getInactiveState());
        for (ActivationLifeCycle.Transition cell : lifeCycle.getStateTransitions()) {
            lc.internalAddStateTransition(cell.getFrom(), cell.getEvent(), cell.getTo());
        }
        return lc;
    }
}

