/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.initialselectors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.TrajectoryWithStateFitness;
import org.eclipse.viatra.dse.evolutionary.interfaces.IInitialPopulationSelector;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.specific.ConflictResolvers;
import org.eclipse.viatra.transformation.evm.specific.resolver.FixedPriorityConflictResolver;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class FixedPriorityInitialSelector
implements IInitialPopulationSelector {
    private ThreadContext context;
    private DesignSpaceManager dsm;
    private Set<TrajectoryFitness> initialPopulation;
    private int populationSize;
    private int maxDepth = -1;
    private boolean acceptTrajectoryAtMaxDepth;
    protected HashMap<BatchTransformationRule<?, ?>, Integer> priorities;
    private IObjective objective;
    private boolean isInterrupted = false;
    protected Logger logger = Logger.getLogger(IStrategy.class);

    public FixedPriorityInitialSelector() {
        this.priorities = new HashMap();
    }

    public FixedPriorityInitialSelector withRulePriority(BatchTransformationRule<?, ?> rule, int priority) {
        this.priorities.put(rule, priority);
        return this;
    }

    public FixedPriorityInitialSelector withHardObjective(IObjective objective) {
        this.objective = objective;
        return this;
    }

    public FixedPriorityInitialSelector withMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public FixedPriorityInitialSelector alwaysAcceptTrajectoryIfMaxDepthReached() {
        this.acceptTrajectoryAtMaxDepth = true;
        return this;
    }

    @Override
    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.dsm = context.getDesignSpaceManager();
        this.initialPopulation = new HashSet<TrajectoryFitness>(this.populationSize);
        Objects.requireNonNull(this.objective, "Hard objective is missing for FixedPriorityInitialSelector.");
        Preconditions.checkState((boolean)this.objective.isHardObjective(), (String)"Given objective is not hard objective for FixedPriorityInitialSelector.");
        for (BatchTransformationRule batchTransformationRule : context.getGlobalContext().getTransformations()) {
            if (this.priorities.containsKey(batchTransformationRule)) continue;
            throw new IllegalStateException("Missing rule priority for FixedPriorityInitialSelector.");
        }
        FixedPriorityConflictResolver fixedPriorityResolver = ConflictResolvers.createFixedPriorityResolver();
        for (Map.Entry<BatchTransformationRule<?, ?>, Integer> entry : this.priorities.entrySet()) {
            fixedPriorityResolver.setPriority(entry.getKey().getRuleSpecification(), entry.getValue().intValue());
        }
        context.changeActivationOrdering(fixedPriorityResolver.createConflictSet());
        this.objective.init(context);
        this.logger.info((Object)"FixedPriorityInitialSelector inited.");
    }

    public void explore() {
        while (!this.isInterrupted && this.initialPopulation.size() < this.populationSize) {
            Double fitness = this.objective.getFitness(this.context);
            boolean hardObjectiveIsSatisfied = this.objective.satisifiesHardObjective(fitness);
            if (this.maxDepth >= 0 && this.maxDepth <= this.context.getDepth()) {
                if (hardObjectiveIsSatisfied || this.acceptTrajectoryAtMaxDepth) {
                    this.saveTrajectory();
                }
                this.dsm.undoUntilRoot();
                continue;
            }
            if (hardObjectiveIsSatisfied) {
                this.saveTrajectory();
                this.dsm.undoUntilRoot();
                continue;
            }
            this.dsm.executeRandomActivationId();
        }
        this.context.changeActivationOrderingBack();
        this.logger.info((Object)"FixedPriorityInitialSelector finished.");
    }

    private void saveTrajectory() {
        TrajectoryWithStateFitness traj = new TrajectoryWithStateFitness(this.dsm.getTrajectoryInfo(), this.context.calculateFitness());
        this.initialPopulation.add(traj);
        this.logger.debug((Object)("Initial trajectory found: " + traj.toString()));
    }

    public void interruptStrategy() {
        this.isInterrupted = true;
    }

    @Override
    public Set<TrajectoryFitness> getInitialPopulation() {
        return this.initialPopulation;
    }
}

