/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.evaluation;

import java.util.List;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.IEvaluationStrategy;
import org.eclipse.viatra.dse.objectives.ObjectiveComparatorHelper;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class FrontsAndCrowdingDistanceEvaluationStrategy
implements IEvaluationStrategy {
    private ObjectiveComparatorHelper helper;

    @Override
    public void init(ThreadContext context) {
        this.helper = context.getObjectiveComparatorHelper();
        this.helper.setComputeCrowdingDistance(true);
    }

    @Override
    public List<? extends List<TrajectoryFitness>> evaluatePopulation(List<TrajectoryFitness> currentPopulation) {
        for (TrajectoryFitness trajectoryFitness : currentPopulation) {
            this.helper.addTrajectoryFitness(trajectoryFitness);
        }
        List fronts = this.helper.getFronts();
        this.helper.clearTrajectoryFitnesses();
        return fronts;
    }
}

