/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.quickfix;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeSystem;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Expression;
import org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterRef;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguageFactory;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Type;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.ui.quickfix.XbaseQuickfixProvider;

public class EMFPatternLanguageQuickfixProvider
extends XbaseQuickfixProvider {
    private static final String WHITELIST_CONTEXT = "org.eclipse.viatra.documentation.help.whitelist";
    private static final String USAGECOUNTING_CONTEXT = "org.eclipse.viatra.documentation.help.usagecounting";
    private static final String AGGREGATED_CHAIN_CONTEXT = "org.eclipse.viatra.documentation.help.aggregated-chain";
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private EMFTypeInferrer typeInferrer;
    @Inject
    private EMFTypeSystem typeSystem;
    @Inject
    @Named(value="org.eclipse.viatra.query.vql.enabledexplanations")
    private boolean explanationsEnabled;

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.identifier_as_keyword")
    public void escapeKeywordAsIdentifier(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Prefix Identifier", "Adds a ^ prefix to the identifier", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument document = context.getXtextDocument();
                document.replace(issue.getOffset().intValue(), 0, "^");
            }
        });
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.missing_parameter_type")
    public void inferMissingParameterType(final Issue issue, IssueResolutionAcceptor acceptor) {
        String[] stringArray = issue.getData();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String data = stringArray[n2];
            if (data.startsWith("java:")) {
                final String typeName = data.substring("java:".length());
                acceptor.accept(issue, "Insert Java type '" + typeName + "'", "Declares the inferred type " + typeName + " for the variable.", null, new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        Variable var = (Variable)element;
                        JavaType typeRef = PatternLanguageFactory.eINSTANCE.createJavaType();
                        JvmType jvmType = EMFPatternLanguageQuickfixProvider.this.typeProviderFactory.findOrCreateTypeProvider(element.eResource().getResourceSet()).findTypeByName(typeName);
                        typeRef.setClassRef((JvmDeclaredType)jvmType);
                        var.setType((Type)typeRef);
                    }
                });
            } else {
                acceptor.accept(issue, "Insert EMF type '" + data + "'", "Declares the inferred type " + data + " for the variable. \n\n", null, new IModification(){

                    public void apply(IModificationContext context) throws Exception {
                        IXtextDocument document = context.getXtextDocument();
                        document.replace(issue.getOffset() + issue.getLength(), 0, " : " + data);
                    }
                });
            }
            ++n2;
        }
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.parameter_type_ambiguous")
    public void addAmbiguousParameterType(final Issue issue, IssueResolutionAcceptor acceptor) {
        String[] stringArray = issue.getData();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            final String data = stringArray[n2];
            acceptor.accept(issue, "Insert type '" + data + "'", "Declares the inferred type " + data + " for the variable. \n\nWarning! When not matching the entire ResourceSet, \nthis might slightly change the results of the pattern; \nlook at the documentation of Query Scopes for details.", null, new IModification(){

                public void apply(IModificationContext context) throws Exception {
                    IXtextDocument document = context.getXtextDocument();
                    document.replace(issue.getOffset() + issue.getLength(), 0, " : " + data);
                }
            });
            ++n2;
        }
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.missing_import")
    public void addMissingPackageImport(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add missing import", "Add missing import", null, context -> {
            IXtextDocument document = context.getXtextDocument();
            Integer offset = (Integer)document.readOnly(state -> {
                VQLImportSection importSection = (VQLImportSection)Iterators.find((Iterator)state.getAllContents(), (Predicate)Predicates.instanceOf(VQLImportSection.class), null);
                ICompositeNode node = NodeModelUtils.getNode((EObject)importSection);
                return node.getTotalEndOffset();
            });
            if (offset != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n");
                sb.append("import \"");
                sb.append(issue.getData()[0]);
                sb.append("\"");
                document.replace(offset.intValue(), 0, sb.toString());
            }
        });
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.missing_import_dependency")
    public void addDependency(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add dependency", "Add the required bundle to the manifest.mf file.", null, (IModification)new AddDependency(issue));
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.no_iq_runtime_on_classpath")
    public void addLibrary(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData().length > 1) {
            return;
        }
        acceptor.accept(issue, "Add dependency", String.format("Add the required bundle '%s' to the manifest.mf file.", issue.getData()[0]), null, (IModification)new AddDependency(issue));
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.local_variable_referenced_once")
    public void handleSingleUseVariables(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Prefix Variable", "Adds a _ prefix to the variable to mark it as single-use", null, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument document = context.getXtextDocument();
                document.replace(issue.getOffset().intValue(), 0, "_");
            }
        });
        acceptor.accept(issue, "Add as parameter", "Adds the local variable as a parameter", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                VariableReference varRef = (VariableReference)element;
                Pattern containingPattern = (Pattern)EcoreUtil2.getContainerOfType((EObject)varRef, Pattern.class);
                Parameter parameter = PatternLanguageFactory.eINSTANCE.createParameter();
                containingPattern.getParameters().add((Object)parameter);
                parameter.setName(varRef.getVar());
                Type type = EMFPatternLanguageQuickfixProvider.this.typeSystem.convertToVQLType((EObject)varRef, EMFPatternLanguageQuickfixProvider.this.typeInferrer.getType((Expression)varRef));
                parameter.setType(type);
                for (PatternBody body : containingPattern.getBodies()) {
                    ParameterRef reference = PatternLanguageFactory.eINSTANCE.createParameterRef();
                    reference.setName(varRef.getVar());
                    reference.setReferredParam((Variable)parameter);
                    Optional<Variable> variable = body.getVariables().stream().filter(v -> Objects.equals(v.getName(), varRef.getVar())).findFirst();
                    if (variable.isPresent()) {
                        EcoreUtil.replace((EObject)((EObject)variable.get()), (EObject)reference);
                        continue;
                    }
                    body.getVariables().add((Object)reference);
                }
            }
        });
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.aggregated_feature_chain")
    public void explainAggregatedChain(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainWithHelp(issue, acceptor, AGGREGATED_CHAIN_CONTEXT);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.local_variable_no_quantifying_reference")
    public void explainUsageCounting1(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainWithHelp(issue, acceptor, USAGECOUNTING_CONTEXT);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.local_variable_no_positive_reference")
    public void explainUsageCounting2(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainWithHelp(issue, acceptor, USAGECOUNTING_CONTEXT);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.local_variable_quantified_reference")
    public void explainUsageCounting3(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainWithHelp(issue, acceptor, USAGECOUNTING_CONTEXT);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.symbolic_variable_never_referenced")
    public void explainUsageCounting4(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainWithHelp(issue, acceptor, USAGECOUNTING_CONTEXT);
    }

    @Fix(value="org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.check_with_impure_java_calls")
    public void explainImpureCall(Issue issue, IssueResolutionAcceptor acceptor) {
        this.explainWithHelp(issue, acceptor, WHITELIST_CONTEXT);
    }

    private void explainWithHelp(Issue issue, IssueResolutionAcceptor acceptor, String helpContextID) {
        if (this.explanationsEnabled) {
            acceptor.accept(issue, "Explain message", "", null, context -> PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpContextID));
        }
    }

    private static final class AddDependency
    implements IModification {
        private final Issue issue;

        private AddDependency(Issue issue) {
            this.issue = issue;
        }

        public void apply(IModificationContext context) throws CoreException, BadLocationException {
            URI uriToProblem = this.issue.getUriToProblem();
            if (uriToProblem.isPlatform()) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFile((IPath)new Path(uriToProblem.toPlatformString(true)));
                if (file.exists() && !file.isReadOnly()) {
                    ProjectGenerationHelper.ensureBundleDependencies((IProject)file.getProject(), Arrays.asList(this.issue.getData()));
                }
                IXtextDocument document = context.getXtextDocument();
                document.replace(this.issue.getOffset().intValue(), 1, document.get(this.issue.getOffset().intValue(), 1));
            }
        }
    }
}

