/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless;

import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.AdaptableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.FallThroughCapableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.DefaultMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.UpdateSplittingMailbox;

public class BehaviorChangingMailbox
implements FallThroughCapableMailbox {
    protected boolean fallThrough = false;
    protected boolean split = false;
    protected AdaptableMailbox wrapped;
    protected final Receiver receiver;
    protected final ReteContainer container;
    protected CommunicationGroup group;

    public BehaviorChangingMailbox(Receiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.wrapped = new DefaultMailbox(receiver, container);
        this.wrapped.setAdapter(this);
    }

    @Override
    public void postMessage(Direction direction, Tuple update, Timestamp timestamp) {
        if (this.fallThrough && !this.container.isExecutingDelayedCommands()) {
            this.receiver.update(direction, update, timestamp);
        } else {
            this.wrapped.postMessage(direction, update, timestamp);
        }
    }

    @Override
    public void deliverAll(MessageSelector kind) {
        this.wrapped.deliverAll(kind);
    }

    public String toString() {
        return "A_MBOX -> " + String.valueOf(this.wrapped);
    }

    public void setSplitFlag(boolean splitValue) {
        if (this.split != splitValue) {
            assert (this.isEmpty());
            this.wrapped = splitValue ? new UpdateSplittingMailbox(this.receiver, this.container) : new DefaultMailbox(this.receiver, this.container);
            this.wrapped.setAdapter(this);
            this.split = splitValue;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }

    @Override
    public boolean isFallThrough() {
        return this.fallThrough;
    }

    @Override
    public void setFallThrough(boolean fallThrough) {
        this.fallThrough = fallThrough;
    }
}

