/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.construction.quasitree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.BuildHelper;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PApply;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PEnumerate;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PStart;
import org.eclipse.viatra.query.runtime.matchers.psystem.DeferredPConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.viatra.query.runtime.rete.construction.quasitree.JoinCandidate;
import org.eclipse.viatra.query.runtime.rete.construction.quasitree.JoinOrderingHeuristics;
import org.eclipse.viatra.query.runtime.rete.util.ReteHintOptions;

public class QuasiTreeLayout
implements IQueryPlannerStrategy {
    private IQueryBackendHintProvider hintProvider;
    private IQueryBackendContext backendContext;
    private QueryAnalyzer queryAnalyzer;

    public QuasiTreeLayout(IQueryBackendContext backendContext) {
        this(backendContext, backendContext.getHintProvider());
    }

    public QuasiTreeLayout(IQueryBackendContext backendContext, IQueryBackendHintProvider hintProvider) {
        this.backendContext = backendContext;
        this.hintProvider = hintProvider;
        this.queryAnalyzer = backendContext.getQueryAnalyzer();
    }

    public SubPlan plan(PBody pSystem, Logger logger, IQueryMetaContext context) {
        return new Scaffold(pSystem, logger, context).run();
    }

    public class Scaffold {
        PBody pSystem;
        PQuery query;
        IQueryMetaContext context;
        private QueryEvaluationHint hints;
        SubPlanFactory planFactory;
        Set<DeferredPConstraint> deferredConstraints = null;
        Set<EnumerablePConstraint> enumerableConstraints = null;
        Set<ConstantValue> constantConstraints = null;
        Set<SubPlan> forefront = new LinkedHashSet<SubPlan>();
        Logger logger;

        Scaffold(PBody pSystem, Logger logger, IQueryMetaContext context) {
            this.pSystem = pSystem;
            this.logger = logger;
            this.context = context;
            this.planFactory = new SubPlanFactory(pSystem);
            this.query = pSystem.getPattern();
            this.hints = QuasiTreeLayout.this.hintProvider.getQueryEvaluationHint(this.query);
        }

        public SubPlan run() {
            try {
                this.logger.debug((Object)String.format("%s: patternbody build started for %s", this.getClass().getSimpleName(), this.query.getFullyQualifiedName()));
                this.deferredConstraints = this.pSystem.getConstraintsOfType(DeferredPConstraint.class);
                this.enumerableConstraints = this.pSystem.getConstraintsOfType(EnumerablePConstraint.class);
                this.constantConstraints = this.pSystem.getConstraintsOfType(ConstantValue.class);
                for (EnumerablePConstraint enumerable : this.enumerableConstraints) {
                    SubPlan plan = this.planFactory.createSubPlan((POperation)new PEnumerate(enumerable), new SubPlan[0]);
                    this.admitSubPlan(plan);
                }
                if (this.enumerableConstraints.isEmpty()) {
                    SubPlan plan = this.planFactory.createSubPlan((POperation)new PStart(new PVariable[0]), new SubPlan[0]);
                    this.admitSubPlan(plan);
                }
                while (this.forefront.size() > 1) {
                    List<JoinCandidate> candidates = this.generateJoinCandidates();
                    JoinOrderingHeuristics ordering = new JoinOrderingHeuristics();
                    JoinCandidate selectedJoin = Collections.min(candidates, ordering);
                    this.doJoin(selectedJoin);
                }
                assert (this.forefront.size() == 1);
                SubPlan preFinalPlan = this.forefront.iterator().next();
                SubPlan finalPlan = this.planFactory.createSubPlan((POperation)new PProject(this.pSystem.getSymbolicParameterVariables()), new SubPlan[]{preFinalPlan});
                BuildHelper.finalCheck((PBody)this.pSystem, (SubPlan)finalPlan, (IQueryMetaContext)this.context);
                this.logger.debug((Object)String.format("%s: patternbody query plan concluded for %s as: %s", this.getClass().getSimpleName(), this.query.getFullyQualifiedName(), finalPlan.toLongString()));
                return finalPlan;
            }
            catch (RetePatternBuildException ex) {
                ex.setPatternDescription(this.query);
                throw ex;
            }
        }

        public List<JoinCandidate> generateJoinCandidates() {
            ArrayList<JoinCandidate> candidates = new ArrayList<JoinCandidate>();
            int bIndex = 0;
            for (SubPlan b : this.forefront) {
                int aIndex = 0;
                for (SubPlan a : this.forefront) {
                    if (aIndex++ >= bIndex) break;
                    candidates.add(new JoinCandidate(a, b, QuasiTreeLayout.this.queryAnalyzer));
                }
                ++bIndex;
            }
            return candidates;
        }

        private void admitSubPlan(SubPlan plan) {
            SubPlan trimmed;
            if (((Boolean)ReteHintOptions.prioritizeConstantFiltering.getValueOrDefault(this.hints)).booleanValue()) {
                for (ConstantValue constantConstraint : this.constantConstraints) {
                    if (plan.getAllEnforcedConstraints().contains(constantConstraint) || !plan.getVisibleVariables().containsAll(constantConstraint.getAffectedVariables())) continue;
                    plan = this.planFactory.createSubPlan((POperation)new PApply((PConstraint)constantConstraint), new SubPlan[]{plan});
                }
            }
            plan = trimmed = BuildHelper.trimUnneccessaryVariables((SubPlanFactory)this.planFactory, (SubPlan)plan, (boolean)true, (QueryAnalyzer)QuasiTreeLayout.this.queryAnalyzer);
            for (DeferredPConstraint deferred : this.deferredConstraints) {
                if (plan.getAllEnforcedConstraints().contains(deferred) || !deferred.isReadyAt(plan, this.context)) continue;
                this.admitSubPlan(this.planFactory.createSubPlan((POperation)new PApply((PConstraint)deferred), new SubPlan[]{plan}));
                return;
            }
            this.forefront.add(plan);
        }

        private void doJoin(JoinCandidate selectedJoin) {
            this.forefront.remove(selectedJoin.getPrimary());
            this.forefront.remove(selectedJoin.getSecondary());
            this.admitSubPlan(selectedJoin.getJoinedPlan(this.planFactory));
        }
    }
}

