/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.tuple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;

public abstract class AbstractTuple
implements ITuple {
    @Override
    public Object[] getElements() {
        Object[] allElements = new Object[this.getSize()];
        int i = 0;
        while (i < allElements.length) {
            allElements[i] = this.get(i);
            ++i;
        }
        return allElements;
    }

    @Override
    public <T> Set<T> getDistinctElements() {
        Object[] elements;
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            result.add(object);
            ++n2;
        }
        return result;
    }

    @Override
    public Map<Object, Integer> invertIndex() {
        HashMap<Object, Integer> result = new HashMap<Object, Integer>();
        int i = 0;
        while (i < this.getSize()) {
            result.put(this.get(i), i);
            ++i;
        }
        return result;
    }

    @Override
    public Map<Object, List<Integer>> invertIndexWithMupliplicity() {
        HashMap<Object, List<Integer>> result = new HashMap<Object, List<Integer>>();
        int i = 0;
        while (i < this.getSize()) {
            Object value = this.get(i);
            List indices = result.computeIfAbsent(value, v -> new ArrayList());
            indices.add(i);
            ++i;
        }
        return result;
    }

    protected IndexOutOfBoundsException raiseIndexingError(int index) {
        return new IndexOutOfBoundsException(String.format("No value at position %d for %s instance %s", index, this.getClass().getSimpleName(), this));
    }

    protected boolean internalEquals(ITuple other) {
        if (this.getSize() != other.getSize()) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (result && i < this.getSize()) {
            Object ours = this.get(i);
            Object theirs = other.get(i);
            result = result && Objects.equals(ours, theirs);
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("T(");
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            s.append(o == null ? "null" : o.toString());
            s.append(';');
            ++n2;
        }
        s.append(')');
        return s.toString();
    }

    protected int doCalcHash() {
        int PRIME = 31;
        int hash = 1;
        int i = 0;
        while (i < this.getSize()) {
            hash *= 31;
            Object element = this.get(i);
            if (element != null) {
                hash += element.hashCode();
            }
            ++i;
        }
        return hash;
    }
}

