/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.recipes.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesPackage;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;

public class RecipeRecognizer {
    private static long nextRecipeEquivalenceClassID = 0L;
    Map<EClass, Set<ReteNodeRecipe>> canonicalRecipesByClass = new HashMap<EClass, Set<ReteNodeRecipe>>();
    Map<Long, ReteNodeRecipe> canonicalRecipeByEquivalenceClassID = new HashMap<Long, ReteNodeRecipe>();
    private IQueryRuntimeContext runtimeContext;

    public RecipeRecognizer(IQueryRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public RecipeRecognizer() {
        this(null);
    }

    public ReteNodeRecipe peekCanonicalRecipe(ReteNodeRecipe recipe) {
        for (Long classID : recipe.getEquivalenceClassIDs()) {
            ReteNodeRecipe knownRecipe = this.canonicalRecipeByEquivalenceClassID.get(classID);
            if (knownRecipe == null) continue;
            return knownRecipe;
        }
        Set<ReteNodeRecipe> sameClassRecipes = this.getSameClassCanonicalRecipes(recipe);
        for (ReteNodeRecipe knownRecipe : sameClassRecipes) {
            if (!this.isEquivalentRecipe(recipe, knownRecipe)) continue;
            recipe.getEquivalenceClassIDs().add((Object)((Long)knownRecipe.getEquivalenceClassIDs().get(0)));
            return knownRecipe;
        }
        return null;
    }

    public void makeCanonical(ReteNodeRecipe recipe) {
        if (recipe.getEquivalenceClassIDs().isEmpty()) {
            recipe.getEquivalenceClassIDs().add((Object)nextRecipeEquivalenceClassID++);
        }
        for (Long classID : recipe.getEquivalenceClassIDs()) {
            this.canonicalRecipeByEquivalenceClassID.put(classID, recipe);
        }
        this.getSameClassCanonicalRecipes(recipe).add(recipe);
    }

    public ReteNodeRecipe canonicalizeRecipe(ReteNodeRecipe recipe) {
        ReteNodeRecipe knownRecipe = this.peekCanonicalRecipe(recipe);
        if (knownRecipe == null) {
            knownRecipe = recipe;
            this.makeCanonical(recipe);
        }
        return knownRecipe;
    }

    public boolean isKnownCanonicalRecipe(ReteNodeRecipe recipe) {
        if (recipe.getEquivalenceClassIDs().isEmpty()) {
            return false;
        }
        ReteNodeRecipe knownRecipe = this.canonicalRecipeByEquivalenceClassID.get(recipe.getEquivalenceClassIDs().get(0));
        return recipe == knownRecipe;
    }

    private Set<ReteNodeRecipe> getSameClassCanonicalRecipes(ReteNodeRecipe recipe) {
        Set<ReteNodeRecipe> sameClassRecipes = this.canonicalRecipesByClass.get(recipe.eClass());
        if (sameClassRecipes == null) {
            sameClassRecipes = new HashSet<ReteNodeRecipe>();
            this.canonicalRecipesByClass.put(recipe.eClass(), sameClassRecipes);
        }
        return sameClassRecipes;
    }

    private boolean isEquivalentRecipe(ReteNodeRecipe recipe, ReteNodeRecipe knownRecipe) {
        return new EqualityHelper(this.runtimeContext).equals(recipe, knownRecipe);
    }

    private static class EqualityHelper
    extends EcoreUtil.EqualityHelper {
        private static final long serialVersionUID = -8841971394686015188L;
        private static final EAttribute RETE_NODE_RECIPE_EQUIVALENCE_CLASS_IDS = RecipesPackage.eINSTANCE.getReteNodeRecipe_EquivalenceClassIDs();
        private static final EAttribute CONSTANT_RECIPE_CONSTANT_VALUES = RecipesPackage.eINSTANCE.getConstantRecipe_ConstantValues();
        private static final EAttribute DISCRIMINATOR_BUCKET_RECIPE_BUCKET_KEY = RecipesPackage.eINSTANCE.getDiscriminatorBucketRecipe_BucketKey();
        private IQueryRuntimeContext runtimeContext;

        public EqualityHelper(IQueryRuntimeContext runtimeContext) {
            this.runtimeContext = runtimeContext;
        }

        protected boolean haveEqualFeature(EObject eObject1, EObject eObject2, EStructuralFeature feature) {
            if (RETE_NODE_RECIPE_EQUIVALENCE_CLASS_IDS.equals(feature)) {
                return true;
            }
            if (this.runtimeContext != null && DISCRIMINATOR_BUCKET_RECIPE_BUCKET_KEY.equals(feature)) {
                Object val1 = eObject1.eGet(feature);
                Object val2 = eObject2.eGet(feature);
                if (val1 != null && val2 != null) {
                    return this.runtimeContext.wrapElement(val1).equals(this.runtimeContext.wrapElement(val2));
                }
                return val1 == null && val2 == null;
            }
            return super.haveEqualFeature(eObject1, eObject2, feature);
        }

        public boolean equals(EObject eObject1, EObject eObject2) {
            EList<Long> eqClassIDs2;
            EList<Long> eqClassIDs1;
            if (eObject1 instanceof ReteNodeRecipe && eObject2 instanceof ReteNodeRecipe && !Collections.disjoint(eqClassIDs1 = ((ReteNodeRecipe)eObject1).getEquivalenceClassIDs(), eqClassIDs2 = ((ReteNodeRecipe)eObject2).getEquivalenceClassIDs())) {
                return true;
            }
            return super.equals(eObject1, eObject2);
        }
    }
}

