/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime;

import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.addon.validation.core.ValidationEngine;
import org.eclipse.viatra.addon.validation.core.api.IConstraint;
import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;
import org.eclipse.viatra.addon.validation.core.api.IValidationEngine;
import org.eclipse.viatra.addon.validation.core.listeners.ConstraintListener;
import org.eclipse.viatra.addon.validation.runtime.ConstraintExtensionRegistry;
import org.eclipse.viatra.addon.validation.runtime.MarkerManagerViolationListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;

public class ConstraintAdapter {
    private final IResource resourceForEditor;
    private final IValidationEngine engine;
    private final ConstraintListener constraintListener;

    public ConstraintAdapter(IEditorPart editorPart, Notifier notifier, Logger logger) {
        this(ConstraintAdapter.getIResourceForEditor(editorPart), ConstraintExtensionRegistry.getConstraintSpecificationsForEditorId(editorPart.getSite().getId()), new MarkerManagerViolationListener(ConstraintAdapter.getIResourceForEditor(editorPart), logger), notifier, logger);
    }

    public ConstraintAdapter(IResource resourceForEditor, Set<IConstraintSpecification> constraintSpecificationsForEditorId, ConstraintListener constraintListener, Notifier notifier, Logger logger) {
        this.resourceForEditor = resourceForEditor;
        ViatraQueryEngine queryEngine = ViatraQueryEngine.on((QueryScope)new EMFScope(notifier));
        this.engine = ValidationEngine.builder().setEngine(queryEngine).setLogger(logger).build();
        this.engine.initialize();
        this.constraintListener = Objects.requireNonNull(constraintListener);
        for (IConstraintSpecification constraint : constraintSpecificationsForEditorId) {
            IConstraint coreConstraint = this.engine.addConstraintSpecification(constraint);
            coreConstraint.addListener(this.constraintListener);
        }
    }

    private static IResource getIResourceForEditor(IEditorPart editorPart) {
        Object o;
        IEditorInput input = editorPart.getEditorInput();
        IResource resource = null;
        if (input != null && (o = input.getAdapter(IFile.class)) instanceof IResource) {
            resource = (IResource)o;
        }
        return resource;
    }

    public void dispose() {
        this.constraintListener.dispose();
        this.engine.dispose();
    }

    protected IResource getResourceForEditor() {
        return this.resourceForEditor;
    }
}

