/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.launcher;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystemPackage;
import org.eclipse.viatra.examples.cps.deployment.DeploymentPackage;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityPackage;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchOptimized;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchQueryLocalSearch;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchQueryOnly;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchSimple;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchViatra;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.CPSTransformationWrapper;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.ExplicitTraceability;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.PartialBatch;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.QueryResultTraceability;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.ViatraTransformation;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.StatisticsBasedConstraintCostFunction;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;

public enum TransformationType {
    BATCH_SIMPLE{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new BatchSimple();
        }
    }
    ,
    BATCH_OPTIMIZED{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new BatchOptimized();
        }
    }
    ,
    BATCH_VIATRA_QUERY_RETE{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = new QueryEvaluationHint(null, (IQueryBackendFactory)new ReteBackendFactory());
            return new BatchQueryOnly(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefaultFlatten().build();
            QueryEvaluationHint traceHint = LocalSearchHints.getDefaultFlatten().setCostFunction((ICostFunction)new EndOfTransformationCostFunction()).build();
            return new BatchQueryLocalSearch(hint, traceHint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH_GENERIC{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefaultGeneric().setCostFunction((ICostFunction)new EndOfTransformationCostFunction()).build();
            return new BatchQueryLocalSearch(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH_WO_INDEXER{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefaultNoBase().build();
            return new BatchQueryLocalSearch(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_TRANSFORMATION{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new BatchViatra();
        }

        @Override
        public boolean isDebuggable() {
            return true;
        }
    }
    ,
    INCR_VIATRA_QUERY_RESULT_TRACEABILITY{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new QueryResultTraceability();
        }
    }
    ,
    INCR_VIATRA_EXPLICIT_TRACEABILITY{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new ExplicitTraceability();
        }
    }
    ,
    INCR_VIATRA_AGGREGATED{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new PartialBatch();
        }
    }
    ,
    INCR_VIATRA_TRANSFORMATION{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new ViatraTransformation();
        }

        @Override
        public boolean isDebuggable() {
            return true;
        }
    };


    private TransformationType() {
    }

    public abstract CPSTransformationWrapper getWrapper();

    public boolean isDebuggable() {
        return false;
    }

    /* synthetic */ TransformationType(String string, int n, TransformationType transformationType) {
        this();
    }

    private final class EndOfTransformationCostFunction
    extends StatisticsBasedConstraintCostFunction {
        final Map<IInputKey, IInputKey> substitutions = Maps.newHashMap();

        public EndOfTransformationCostFunction() {
            this.substitutions.put((IInputKey)new EClassTransitiveInstancesKey(TraceabilityPackage.Literals.CPS2_DEPLOYMENT_TRACE), (IInputKey)new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            this.substitutions.put((IInputKey)new EClassTransitiveInstancesKey(DeploymentPackage.Literals.DEPLOYMENT_ELEMENT), (IInputKey)new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            this.substitutions.put((IInputKey)new EStructuralFeatureInstancesKey((EStructuralFeature)TraceabilityPackage.Literals.CPS2_DEPLOYMENT_TRACE__CPS_ELEMENTS), (IInputKey)new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            this.substitutions.put((IInputKey)new EStructuralFeatureInstancesKey((EStructuralFeature)TraceabilityPackage.Literals.CPS2_DEPLOYMENT_TRACE__DEPLOYMENT_ELEMENTS), (IInputKey)new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            this.substitutions.put((IInputKey)new EStructuralFeatureInstancesKey((EStructuralFeature)TraceabilityPackage.Literals.CPS_TO_DEPLOYMENT__TRACES), (IInputKey)new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
        }

        public long countTuples(IConstraintEvaluationContext input, IInputKey supplierKey) {
            EClass eclass;
            if (supplierKey instanceof EClassTransitiveInstancesKey && TraceabilityPackage.Literals.CPS_TO_DEPLOYMENT.equals(eclass = (EClass)((EClassTransitiveInstancesKey)supplierKey).getEmfKey())) {
                return 1L;
            }
            if (this.substitutions.containsKey(supplierKey)) {
                return input.getRuntimeContext().countTuples(this.substitutions.get(supplierKey), TupleMask.empty((int)supplierKey.getArity()), (ITuple)Tuples.staticArityFlatTupleOf());
            }
            return input.getRuntimeContext().countTuples(supplierKey, TupleMask.empty((int)supplierKey.getArity()), (ITuple)Tuples.staticArityFlatTupleOf());
        }
    }
}

