/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.addon.validation.core.Constraint;
import org.eclipse.viatra.addon.validation.core.Violation;
import org.eclipse.viatra.addon.validation.core.violationkey.ViolationKey;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;

public class ViolationCreationProcessor
implements IMatchProcessor<IPatternMatch> {
    private Constraint constraint;
    private Map<ViolationKey, Violation> violationMap;
    private Logger logger;

    public ViolationCreationProcessor(Constraint constraint, Logger logger, Map<ViolationKey, Violation> violationMap) {
        this.constraint = constraint;
        this.logger = logger;
        this.violationMap = violationMap;
    }

    public void process(IPatternMatch match) {
        Map<String, Object> keyObjectMap = this.constraint.getSpecification().getKeyObjects(match);
        if (!keyObjectMap.isEmpty()) {
            this.violationMap.computeIfAbsent(this.constraint.getViolationKey(match), key -> {
                Violation violation = new Violation();
                violation.setConstraint(this.constraint);
                violation.setKeyObjects(this.constraint.getSpecification().getKeyObjects(match));
                violation.setMessage(ViatraQueryRuntimeHelper.getMessage((IPatternMatch)match, (String)this.constraint.getSpecification().getMessageFormat()));
                violation.addMatch(match);
                return violation;
            });
        } else {
            this.logger.error((Object)"Error getting Violation key objects!");
        }
    }
}

