/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.TreeLayoutObserver;
import org.eclipse.gef4.layout.interfaces.ContextListener;
import org.eclipse.gef4.layout.interfaces.ExpandCollapseManager;
import org.eclipse.gef4.layout.interfaces.LayoutContext;
import org.eclipse.gef4.layout.interfaces.LayoutListener;
import org.eclipse.gef4.layout.interfaces.NodeLayout;
import org.eclipse.gef4.layout.interfaces.SubgraphLayout;

public class SpaceTreeLayoutAlgorithm
implements LayoutAlgorithm {
    public static final int TOP_DOWN = 1;
    public static final int BOTTOM_UP = 2;
    public static final int LEFT_RIGHT = 3;
    public static final int RIGHT_LEFT = 4;
    private TreeLayoutObserver.TreeNodeFactory spaceTreeNodeFactory = new TreeLayoutObserver.TreeNodeFactory(){

        public TreeLayoutObserver.TreeNode createTreeNode(NodeLayout nodeLayout, TreeLayoutObserver observer) {
            return new SpaceTreeNode(nodeLayout, observer);
        }
    };
    private SpaceTreeExpandCollapseManager expandCollapseManager = new SpaceTreeExpandCollapseManager();
    private ContextListener contextListener = new ContextListener.Stub(){

        public boolean boundsChanged(LayoutContext context) {
            boolean previousBoundsWrong = SpaceTreeLayoutAlgorithm.this.bounds == null || SpaceTreeLayoutAlgorithm.this.bounds.getWidth() * SpaceTreeLayoutAlgorithm.this.bounds.getHeight() <= 0.0;
            SpaceTreeLayoutAlgorithm.this.bounds = context.getBounds();
            if (SpaceTreeLayoutAlgorithm.this.bounds.getWidth() * SpaceTreeLayoutAlgorithm.this.bounds.getHeight() > 0.0 && previousBoundsWrong) {
                SpaceTreeLayoutAlgorithm.this.expandCollapseManager.maximizeExpansion((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getSuperRoot());
                SpaceTreeLayoutAlgorithm.this.refreshLayout(false);
            }
            return false;
        }
    };
    private LayoutListener layoutListener = new LayoutListener(){

        public boolean subgraphResized(LayoutContext context, SubgraphLayout subgraph) {
            return this.defaultSubgraphHandle(context, subgraph);
        }

        public boolean subgraphMoved(LayoutContext context, SubgraphLayout subgraph) {
            return this.defaultSubgraphHandle(context, subgraph);
        }

        public boolean nodeResized(LayoutContext context, NodeLayout node) {
            SpaceTreeLayoutAlgorithm.this.setAvailableSpace(SpaceTreeLayoutAlgorithm.this.getAvailableSpace() + ((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node)).spaceRequiredForNode());
            boolean result = this.defaultNodeHandle(context, node);
            SpaceTreeLayoutAlgorithm.this.setAvailableSpace(0.0);
            return result;
        }

        public boolean nodeMoved(LayoutContext context, NodeLayout node) {
            return this.defaultNodeHandle(context, node);
        }

        private boolean defaultSubgraphHandle(LayoutContext context, SubgraphLayout subgraph) {
            SpaceTreeNode node = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(subgraph.getNodes()[0]);
            while (node != null && node.node != null && node.node.getSubgraph() == subgraph) {
                node = (SpaceTreeNode)node.parent;
            }
            if (node != null && node.subgraph == subgraph) {
                node.adjustPosition(subgraph.getLocation());
                if (context.isDynamicLayoutEnabled()) {
                    ((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getSuperRoot()).flushLocationChanges(0.0);
                    node.refreshSubgraphLocation();
                    context.flushChanges(false);
                }
            }
            return false;
        }

        private boolean defaultNodeHandle(LayoutContext context, NodeLayout node) {
            if (SpaceTreeLayoutAlgorithm.this.bounds.getWidth() * SpaceTreeLayoutAlgorithm.this.bounds.getHeight() <= 0.0) {
                return false;
            }
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            spaceTreeNode.adjustPosition(node.getLocation());
            if (context.isDynamicLayoutEnabled()) {
                ((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getSuperRoot()).flushLocationChanges(0.0);
                spaceTreeNode.refreshSubgraphLocation();
                context.flushChanges(false);
            }
            return false;
        }
    };
    private int direction = 1;
    private double leafGap = 15.0;
    private double branchGap = this.leafGap + 5.0;
    private double layerGap = 20.0;
    private boolean directionChanged = false;
    private LayoutContext context;
    private Rectangle bounds;
    private TreeLayoutObserver treeObserver;
    private double availableSpace;
    private ArrayList spaceTreeLayers = new ArrayList();
    private SpaceTreeNode protectedNode = null;
    private boolean animate = false;

    public void setLeafGap(double value) {
        this.leafGap = value;
    }

    public void setBranchGap(double value) {
        this.branchGap = value;
    }

    public void setLayerGap(double value) {
        this.layerGap = value;
    }

    public double getLeafGap() {
        return this.leafGap;
    }

    public double getBranchGap() {
        return this.branchGap;
    }

    public double getLayerGap() {
        return this.layerGap;
    }

    public SpaceTreeLayoutAlgorithm() {
    }

    public SpaceTreeLayoutAlgorithm(int direction, boolean animate) {
        this.setDirection(direction);
        this.animate = animate;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction == this.direction) {
            return;
        }
        if (direction == 1 || direction == 2 || direction == 3 || direction == 4) {
            this.direction = direction;
            if (this.context != null) {
                this.directionChanged = true;
                if (this.context.isDynamicLayoutEnabled()) {
                    this.checkPendingChangeDirection();
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid direction: " + direction);
        }
    }

    public void applyLayout(boolean clean) {
        this.bounds = this.context.getBounds();
        if (this.bounds.getWidth() * this.bounds.getHeight() == 0.0) {
            return;
        }
        if (clean) {
            this.treeObserver.recomputeTree();
            this.expandCollapseManager.maximizeExpansion((SpaceTreeNode)this.treeObserver.getSuperRoot());
        }
        SpaceTreeNode superRoot = (SpaceTreeNode)this.treeObserver.getSuperRoot();
        superRoot.flushExpansionChanges();
        superRoot.flushLocationChanges(0.0);
        this.checkPendingChangeDirection();
    }

    public void setLayoutContext(LayoutContext context) {
        if (this.context != null) {
            this.context.removeContextListener(this.contextListener);
            this.context.removeLayoutListener(this.layoutListener);
            this.treeObserver.stop();
        }
        this.context = context;
        context.addContextListener(this.contextListener);
        context.addLayoutListener(this.layoutListener);
        this.treeObserver = new TreeLayoutObserver(context, this.spaceTreeNodeFactory);
        this.bounds = context.getBounds();
    }

    public LayoutContext getLayoutContext() {
        return this.context;
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.expandCollapseManager;
    }

    private void checkPendingChangeDirection() {
        if (this.directionChanged) {
            SubgraphLayout[] subgraphs = this.context.getSubgraphs();
            int subgraphDirection = this.getSubgraphDirection();
            int i = 0;
            while (i < subgraphs.length) {
                subgraphs[i].setDirection(subgraphDirection);
                ++i;
            }
            this.directionChanged = false;
        }
    }

    private int getSubgraphDirection() {
        switch (this.direction) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new RuntimeException();
    }

    protected void refreshLayout(boolean animation) {
        if (!this.context.isDynamicLayoutEnabled()) {
            return;
        }
        SpaceTreeNode superRoot = (SpaceTreeNode)this.treeObserver.getSuperRoot();
        if (animation && superRoot.flushCollapseChanges()) {
            this.context.flushChanges(animation);
        }
        if (superRoot.flushLocationChanges(0.0) && animation) {
            this.context.flushChanges(animation);
        }
        superRoot.flushExpansionChanges();
        superRoot.flushLocationChanges(0.0);
        this.context.flushChanges(animation);
    }

    private double getAvailableSpace() {
        double result = this.direction == 1 || this.direction == 2 ? this.bounds.getWidth() : this.bounds.getHeight();
        result = Math.max(result, this.availableSpace);
        for (SpaceTreeLayer layer : this.spaceTreeLayers) {
            if (layer.nodes.isEmpty()) break;
            SpaceTreeNode first = (SpaceTreeNode)layer.nodes.get(0);
            SpaceTreeNode last = (SpaceTreeNode)layer.nodes.get(layer.nodes.size() - 1);
            result = Math.max(result, last.positionInLayer - first.positionInLayer + (first.spaceRequiredForNode() + last.spaceRequiredForNode()) / 2.0);
        }
        return result;
    }

    private void setAvailableSpace(double availableSpace) {
        this.availableSpace = availableSpace;
    }

    private double expectedDistance(SpaceTreeNode node, SpaceTreeNode neighbor) {
        double expectedDistance = (node.spaceRequiredForNode() + neighbor.spaceRequiredForNode()) / 2.0;
        return expectedDistance += node.parent == neighbor.parent ? this.leafGap : this.branchGap;
    }

    private NodeSnapshot[][] takeSnapShot() {
        NodeSnapshot[][] result = new NodeSnapshot[this.spaceTreeLayers.size()][];
        int i = 0;
        while (i < result.length) {
            SpaceTreeLayer layer = (SpaceTreeLayer)this.spaceTreeLayers.get(i);
            result[i] = new NodeSnapshot[layer.nodes.size()];
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = new NodeSnapshot();
                result[i][j].node = (SpaceTreeNode)layer.nodes.get(j);
                result[i][j].position = result[i][j].node.positionInLayer;
                result[i][j].expanded = result[i][j].node.expanded;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void revertToShanpshot(NodeSnapshot[][] snapShot) {
        int i = 0;
        while (i < snapShot.length) {
            SpaceTreeLayer layer = (SpaceTreeLayer)this.spaceTreeLayers.get(i);
            layer.nodes.clear();
            int j = 0;
            while (j < snapShot[i].length) {
                snapShot[i][j].node.positionInLayer = snapShot[i][j].position;
                snapShot[i][j].node.expanded = snapShot[i][j].expanded;
                layer.nodes.add(snapShot[i][j].node);
                ++j;
            }
            ++i;
        }
    }

    private class NodeSnapshot {
        SpaceTreeNode node;
        double position;
        boolean expanded;

        private NodeSnapshot() {
        }
    }

    private class SpaceTreeExpandCollapseManager
    implements ExpandCollapseManager {
        private SpaceTreeExpandCollapseManager() {
        }

        public void initExpansion(LayoutContext context) {
        }

        public void setExpanded(LayoutContext context, NodeLayout node, boolean expanded) {
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            if (expanded) {
                this.maximizeExpansion(spaceTreeNode);
                SpaceTreeLayoutAlgorithm.this.refreshLayout(SpaceTreeLayoutAlgorithm.this.animate);
            } else if (spaceTreeNode.expanded) {
                spaceTreeNode.expanded = false;
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(spaceTreeNode.depth + 1)).removeNodes(spaceTreeNode.children);
                SpaceTreeLayoutAlgorithm.this.refreshLayout(SpaceTreeLayoutAlgorithm.this.animate);
            }
        }

        public boolean canExpand(LayoutContext context, NodeLayout node) {
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            if (spaceTreeNode != null) {
                return !spaceTreeNode.children.isEmpty();
            }
            return false;
        }

        public boolean canCollapse(LayoutContext context, NodeLayout node) {
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            if (spaceTreeNode != null) {
                return spaceTreeNode.expanded && !spaceTreeNode.children.isEmpty();
            }
            return false;
        }

        public void maximizeExpansion(SpaceTreeNode nodeToExpand) {
            SpaceTreeLayoutAlgorithm.this.protectedNode = nodeToExpand;
            double availableSpace = SpaceTreeLayoutAlgorithm.this.getAvailableSpace();
            double requiredSpace = 0.0;
            ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(nodeToExpand.depth + 1)).removeNodes(nodeToExpand.children);
            ArrayList<SpaceTreeNode> nodesInThisLayer = null;
            ArrayList<SpaceTreeNode> nodesInNextLayer = new ArrayList<SpaceTreeNode>();
            nodesInNextLayer.add(nodeToExpand);
            double spaceRequiredInNextLayer = nodeToExpand.spaceRequiredForNode();
            int layer = 0;
            while (!nodesInNextLayer.isEmpty()) {
                NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
                requiredSpace = Math.max(requiredSpace, spaceRequiredInNextLayer);
                spaceRequiredInNextLayer = 0.0;
                nodesInThisLayer = nodesInNextLayer;
                nodesInNextLayer = new ArrayList();
                int numOfNodesWithChildren = 0;
                for (SpaceTreeNode node : nodesInThisLayer) {
                    if (node.children.isEmpty()) continue;
                    node.expanded = true;
                    spaceRequiredInNextLayer += node.spaceRequiredForChildren();
                    nodesInNextLayer.addAll(node.children);
                    ++numOfNodesWithChildren;
                }
                for (SpaceTreeNode node : nodesInNextLayer) {
                    node.expanded = false;
                }
                if (numOfNodesWithChildren == 0) break;
                boolean addedNewLayer = false;
                if (((spaceRequiredInNextLayer += SpaceTreeLayoutAlgorithm.this.branchGap * (double)(numOfNodesWithChildren - 1)) <= requiredSpace || spaceRequiredInNextLayer <= availableSpace || layer < 1 && nodeToExpand.depth + layer < 1) && !nodesInNextLayer.isEmpty()) {
                    SpaceTreeLayer childLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(nodeToExpand.depth + layer + 1);
                    childLayer.addNodes(nodesInNextLayer);
                    SpaceTreeNode firstChild = (SpaceTreeNode)nodesInNextLayer.get(0);
                    SpaceTreeNode lastChild = (SpaceTreeNode)nodesInNextLayer.get(nodesInNextLayer.size() - 1);
                    double boundsWidth = spaceRequiredInNextLayer - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                    double startPosition = Math.max((availableSpace - boundsWidth) / 2.0, firstChild.spaceRequiredForNode() / 2.0);
                    SpaceTreeLayoutAlgorithm.this.setAvailableSpace(spaceRequiredInNextLayer);
                    childLayer.fitNodesWithinBounds(nodesInNextLayer, startPosition, startPosition + boundsWidth);
                    SpaceTreeLayoutAlgorithm.this.setAvailableSpace(0.0);
                    if (nodeToExpand.childrenPositionsOK(nodesInThisLayer) || layer == 0 || nodeToExpand.depth + layer < 1) {
                        addedNewLayer = true;
                    }
                }
                if (!addedNewLayer) {
                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                    break;
                }
                ++layer;
            }
            nodeToExpand.centerParentsBottomUp();
            nodeToExpand.centerParentsTopDown();
        }
    }

    private class SpaceTreeLayer {
        public ArrayList nodes = new ArrayList();
        private final int depth;
        public double thickness = 0.0;

        public SpaceTreeLayer(int depth) {
            this.depth = depth;
        }

        public void addNodes(List nodesToAdd) {
            ListIterator<SpaceTreeNode> layerIterator = this.nodes.listIterator();
            SpaceTreeNode previousNode = null;
            for (SpaceTreeNode nodeToAdd : nodesToAdd) {
                SpaceTreeNode nodeInLayer = null;
                while (layerIterator.hasNext()) {
                    nodeInLayer = (SpaceTreeNode)layerIterator.next();
                    if (nodeInLayer.order >= nodeToAdd.order) break;
                    double expectedPostion = previousNode == null ? 0.0 : previousNode.positionInLayer + SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nodeInLayer);
                    nodeInLayer.positionInLayer = Math.max(nodeInLayer.positionInLayer, expectedPostion);
                    previousNode = nodeInLayer;
                }
                if (nodeInLayer == null) {
                    layerIterator.add(nodeToAdd);
                } else if (nodeInLayer.order == nodeToAdd.order) {
                    layerIterator.set(nodeToAdd);
                } else {
                    if (nodeInLayer.order > nodeToAdd.order) {
                        layerIterator.previous();
                    }
                    layerIterator.add(nodeToAdd);
                }
                layerIterator.previous();
            }
            while (layerIterator.hasNext()) {
                SpaceTreeNode nodeInLayer = (SpaceTreeNode)layerIterator.next();
                double expectedPostion = previousNode == null ? 0.0 : previousNode.positionInLayer + SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nodeInLayer);
                nodeInLayer.positionInLayer = Math.max(nodeInLayer.positionInLayer, expectedPostion);
                previousNode = nodeInLayer;
            }
            this.refreshThickness();
        }

        public void removeNode(SpaceTreeNode node) {
            if (this.nodes.remove(node)) {
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1)).removeNodes(node.children);
                this.refreshThickness();
            }
        }

        public void removeNodes(List nodesToRemove) {
            if (this.nodes.removeAll(nodesToRemove)) {
                SpaceTreeLayer nextLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                for (SpaceTreeNode nodeToRemove : nodesToRemove) {
                    nextLayer.removeNodes(nodeToRemove.children);
                }
                this.refreshThickness();
            }
        }

        public void checkThickness(SpaceTreeNode node) {
            double nodeThickness = 0.0;
            Dimension size = node.node.getSize();
            double d = nodeThickness = SpaceTreeLayoutAlgorithm.this.direction == 1 || SpaceTreeLayoutAlgorithm.this.direction == 2 ? size.height : size.width;
            if (node.subgraph != null && node.subgraph.isGraphEntity()) {
                size = node.subgraph.getSize();
                nodeThickness += SpaceTreeLayoutAlgorithm.this.direction == 1 || SpaceTreeLayoutAlgorithm.this.direction == 2 ? size.height : size.width;
            }
            this.thickness = Math.max(this.thickness, nodeThickness);
        }

        public void refreshThickness() {
            this.thickness = 0.0;
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                this.checkThickness((SpaceTreeNode)iterator.next());
            }
        }

        public void fitNodesWithinBounds(List nodeList, double startPosition, double endPosition) {
            double expectedDistance;
            SpaceTreeNode previousNode;
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            SpaceTreeNode[] nodes = nodeList.toArray(new SpaceTreeNode[nodeList.size()]);
            double initialStartPosition = nodes[0].positionInLayer;
            double initialNodesBredth = nodes[nodes.length - 1].positionInLayer - initialStartPosition;
            double[] desiredPositions = new double[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                double initialPositionAsPercent = initialNodesBredth > 0.0 ? (nodes[i].positionInLayer - initialStartPosition) / initialNodesBredth : 0.0;
                desiredPositions[i] = initialPositionAsPercent * (endPosition - startPosition);
                ++i;
            }
            i = 1;
            while (i < nodes.length) {
                previousNode = nodes[i - 1];
                SpaceTreeNode node = nodes[i];
                expectedDistance = SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, node);
                if (desiredPositions[i] - desiredPositions[i - 1] < expectedDistance) {
                    desiredPositions[i] = desiredPositions[i - 1] + expectedDistance;
                }
                ++i;
            }
            if (desiredPositions[nodes.length - 1] > endPosition - startPosition) {
                desiredPositions[nodes.length - 1] = endPosition - startPosition;
                i = nodes.length - 1;
                while (i > 0) {
                    previousNode = nodes[i - 1];
                    SpaceTreeNode node = nodes[i];
                    expectedDistance = SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, node);
                    if (!(desiredPositions[i] - desiredPositions[i - 1] < expectedDistance)) break;
                    desiredPositions[i - 1] = desiredPositions[i] - expectedDistance;
                    --i;
                }
            }
            i = 0;
            while (i < nodeList.size()) {
                SpaceTreeNode node = (SpaceTreeNode)nodeList.get(i);
                double desiredPosition = startPosition + desiredPositions[i];
                this.moveNode(node, desiredPosition);
                if (Math.abs(node.positionInLayer - desiredPosition) > 0.5) {
                    startPosition += node.positionInLayer - desiredPosition;
                    i = -1;
                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                }
                ++i;
            }
        }

        public void moveNode(SpaceTreeNode node, double newPosition) {
            Collections.sort(this.nodes, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((SpaceTreeNode)arg0).order - ((SpaceTreeNode)arg1).order;
                }
            });
            double positionInLayerAtStart = node.positionInLayer;
            if (newPosition >= positionInLayerAtStart) {
                this.moveNodeForward(node, newPosition);
            }
            if (newPosition <= positionInLayerAtStart) {
                this.moveNodeBackward(node, newPosition);
            }
        }

        private void moveNodeForward(SpaceTreeNode nodeToMove, double newPosition) {
            int nodeIndex = this.nodes.indexOf(nodeToMove);
            if (nodeIndex == -1) {
                throw new IllegalArgumentException("node not on this layer");
            }
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            boolean firstRun = true;
            block0: while (firstRun || nodeToMove.positionInLayer < newPosition) {
                firstRun = false;
                double requiredSpace = 0.0;
                SpaceTreeNode previousNode = nodeToMove;
                int i = nodeIndex + 1;
                while (i < this.nodes.size()) {
                    SpaceTreeNode nextNode = (SpaceTreeNode)this.nodes.get(i);
                    requiredSpace += SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nextNode);
                    previousNode = nextNode;
                    ++i;
                }
                if ((requiredSpace += previousNode.spaceRequiredForNode() / 2.0) > SpaceTreeLayoutAlgorithm.this.getAvailableSpace() - newPosition) {
                    boolean removed = false;
                    int i2 = nodeIndex;
                    while (i2 < this.nodes.size()) {
                        SpaceTreeNode nextNode = (SpaceTreeNode)this.nodes.get(i2);
                        if (SpaceTreeLayoutAlgorithm.this.protectedNode == null || !SpaceTreeLayoutAlgorithm.this.protectedNode.isAncestorOf(nextNode) && !nextNode.parent.isAncestorOf(SpaceTreeLayoutAlgorithm.this.protectedNode)) {
                            this.collapseNode((SpaceTreeNode)nextNode.parent);
                            if (nextNode.parent == nodeToMove.parent) break block0;
                            removed = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!removed) {
                        newPosition = SpaceTreeLayoutAlgorithm.this.getAvailableSpace() - requiredSpace;
                        SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                        continue;
                    }
                }
                SpaceTreeNode currentNodeToMove = nodeToMove;
                double newPositionForCurrent = newPosition;
                int i3 = nodeIndex;
                while (i3 < this.nodes.size()) {
                    currentNodeToMove.positionInLayer = newPositionForCurrent;
                    if (currentNodeToMove.firstChild) {
                        SpaceTreeNode parent = (SpaceTreeNode)currentNodeToMove.parent;
                        if (this.depth > 0 && parent.positionInLayer <= newPositionForCurrent) {
                            SpaceTreeLayer parentLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth - 1);
                            parentLayer.moveNodeForward(parent, newPositionForCurrent);
                            if (parent.positionInLayer < newPositionForCurrent) {
                                double delta = newPositionForCurrent - parent.positionInLayer;
                                newPosition -= delta;
                                SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                continue block0;
                            }
                        }
                    }
                    if (currentNodeToMove.expanded && !currentNodeToMove.children.isEmpty()) {
                        SpaceTreeNode lastChild = (SpaceTreeNode)currentNodeToMove.children.get(currentNodeToMove.children.size() - 1);
                        if (lastChild.positionInLayer < newPositionForCurrent) {
                            SpaceTreeNode firstChild = (SpaceTreeNode)currentNodeToMove.children.get(0);
                            SpaceTreeLayer childLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                            double expectedDistanceBetweenChildren = currentNodeToMove.spaceRequiredForChildren() - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                            childLayer.moveNodeForward(firstChild, newPositionForCurrent - expectedDistanceBetweenChildren);
                            if (currentNodeToMove.expanded && lastChild.positionInLayer < newPositionForCurrent) {
                                childLayer.moveNodeForward(lastChild, newPositionForCurrent);
                                if (lastChild.positionInLayer < newPositionForCurrent) {
                                    double delta = newPositionForCurrent - lastChild.positionInLayer;
                                    newPosition -= delta;
                                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                    continue block0;
                                }
                            }
                        }
                    }
                    if (i3 < this.nodes.size() - 1) {
                        SpaceTreeNode nextNode = (SpaceTreeNode)this.nodes.get(i3 + 1);
                        currentNodeToMove = nextNode;
                        if (currentNodeToMove.positionInLayer > (newPositionForCurrent += SpaceTreeLayoutAlgorithm.this.expectedDistance(currentNodeToMove, nextNode))) continue block0;
                    }
                    ++i3;
                }
            }
        }

        private void moveNodeBackward(SpaceTreeNode nodeToMove, double newPosition) {
            int nodeIndex = this.nodes.indexOf(nodeToMove);
            if (nodeIndex == -1) {
                throw new IllegalArgumentException("node not on this layer");
            }
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            boolean firstRun = true;
            block0: while (firstRun || nodeToMove.positionInLayer > newPosition) {
                firstRun = false;
                double requiredSpace = 0.0;
                SpaceTreeNode previousNode = nodeToMove;
                int i = nodeIndex - 1;
                while (i >= 0) {
                    SpaceTreeNode nextNode = (SpaceTreeNode)this.nodes.get(i);
                    requiredSpace += SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nextNode);
                    previousNode = nextNode;
                    --i;
                }
                if ((requiredSpace += previousNode.spaceRequiredForNode() / 2.0) > newPosition) {
                    boolean removed = false;
                    int i2 = nodeIndex;
                    while (i2 >= 0) {
                        SpaceTreeNode nextNode = (SpaceTreeNode)this.nodes.get(i2);
                        if (SpaceTreeLayoutAlgorithm.this.protectedNode == null || !SpaceTreeLayoutAlgorithm.this.protectedNode.isAncestorOf(nextNode) && !nextNode.parent.isAncestorOf(SpaceTreeLayoutAlgorithm.this.protectedNode)) {
                            this.collapseNode((SpaceTreeNode)nextNode.parent);
                            if (nextNode.parent == nodeToMove.parent) break block0;
                            nodeIndex -= nextNode.parent.children.size();
                            removed = true;
                            break;
                        }
                        --i2;
                    }
                    if (!removed) {
                        newPosition = requiredSpace;
                        SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                        continue;
                    }
                }
                SpaceTreeNode currentNodeToMove = nodeToMove;
                double newPositionForCurrent = newPosition;
                int i3 = nodeIndex;
                while (i3 >= 0) {
                    currentNodeToMove.positionInLayer = newPositionForCurrent;
                    if (currentNodeToMove.lastChild) {
                        SpaceTreeNode parent = (SpaceTreeNode)currentNodeToMove.parent;
                        if (this.depth > 0 && parent.positionInLayer >= newPositionForCurrent) {
                            SpaceTreeLayer parentLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth - 1);
                            parentLayer.moveNodeBackward(parent, newPositionForCurrent);
                            if (parent.positionInLayer > newPositionForCurrent) {
                                double delta = parent.positionInLayer - newPositionForCurrent;
                                newPosition += delta;
                                SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                continue block0;
                            }
                        }
                    }
                    if (currentNodeToMove.expanded && !currentNodeToMove.children.isEmpty()) {
                        SpaceTreeNode firstChild = (SpaceTreeNode)currentNodeToMove.children.get(0);
                        if (firstChild.positionInLayer > newPositionForCurrent) {
                            SpaceTreeNode lastChild = (SpaceTreeNode)currentNodeToMove.children.get(currentNodeToMove.children.size() - 1);
                            SpaceTreeLayer childLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                            double expectedDistanceBetweenChildren = currentNodeToMove.spaceRequiredForChildren() - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                            childLayer.moveNodeBackward(lastChild, newPositionForCurrent + expectedDistanceBetweenChildren);
                            if (currentNodeToMove.expanded && firstChild.positionInLayer > newPositionForCurrent) {
                                childLayer.moveNodeBackward(firstChild, newPositionForCurrent);
                                if (firstChild.positionInLayer > newPositionForCurrent) {
                                    double delta = firstChild.positionInLayer - newPositionForCurrent;
                                    newPosition += delta;
                                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                    continue block0;
                                }
                            }
                        }
                    }
                    if (i3 > 0) {
                        SpaceTreeNode nextNode = (SpaceTreeNode)this.nodes.get(i3 - 1);
                        currentNodeToMove = nextNode;
                        if (currentNodeToMove.positionInLayer < (newPositionForCurrent -= SpaceTreeLayoutAlgorithm.this.expectedDistance(currentNodeToMove, nextNode))) continue block0;
                    }
                    --i3;
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Layer ").append(this.depth).append(": ");
            for (SpaceTreeNode node : this.nodes) {
                buffer.append(node.node).append(", ");
            }
            return buffer.toString();
        }

        private void collapseNode(SpaceTreeNode node) {
            node.expanded = false;
            SpaceTreeLayer layer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(node.depth + 1);
            layer.removeNodes(node.children);
            for (SpaceTreeNode child : node.children) {
                if (!child.expanded) continue;
                this.collapseNode(child);
            }
        }
    }

    private class SpaceTreeNode
    extends TreeLayoutObserver.TreeNode {
        public SubgraphLayout subgraph;
        public boolean expanded;
        public double positionInLayer;

        public SpaceTreeNode(NodeLayout node, TreeLayoutObserver owner) {
            super(node, owner);
            this.subgraph = null;
            this.expanded = false;
        }

        protected void addChild(TreeLayoutObserver.TreeNode child) {
            super.addChild(child);
            SpaceTreeNode child2 = (SpaceTreeNode)child;
            child2.expanded = false;
            child2.setSubgraph(null);
            if (child.depth >= 0) {
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth)).removeNode(child2);
            }
            if (this.expanded) {
                SpaceTreeLayer childLayer;
                child.depth = this.depth + 1;
                if (child.depth < SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size()) {
                    childLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth);
                } else {
                    childLayer = new SpaceTreeLayer(child.depth);
                    SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.add(childLayer);
                }
                child.order = childLayer.nodes.isEmpty() ? 0 : ((SpaceTreeNode)childLayer.nodes.get((int)(childLayer.nodes.size() - 1))).order + 1;
                childLayer.addNodes(Arrays.asList(child));
            }
        }

        public void precomputeTree() {
            super.precomputeTree();
            if (this == this.owner.getSuperRoot()) {
                this.expanded = true;
                while (SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size() <= this.height) {
                    SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.add(new SpaceTreeLayer(SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size()));
                }
                if (SpaceTreeLayoutAlgorithm.this.treeObserver != null) {
                    SpaceTreeLayoutAlgorithm.this.refreshLayout(SpaceTreeLayoutAlgorithm.this.animate);
                }
            }
        }

        public SubgraphLayout collapseAllChildrenIntoSubgraph(SubgraphLayout subgraph, boolean includeYourself) {
            this.expanded = false;
            ArrayList<NodeLayout> allChildren = new ArrayList<NodeLayout>();
            LinkedList<SpaceTreeNode> nodesToVisit = new LinkedList<SpaceTreeNode>();
            nodesToVisit.addLast(this);
            while (!nodesToVisit.isEmpty()) {
                SpaceTreeNode currentNode = (SpaceTreeNode)nodesToVisit.removeFirst();
                for (SpaceTreeNode child : currentNode.children) {
                    allChildren.add(child.node);
                    child.setSubgraph(null);
                    child.expanded = false;
                    nodesToVisit.addLast(child);
                }
            }
            if (includeYourself) {
                allChildren.add(this.node);
            }
            if (allChildren.isEmpty()) {
                this.setSubgraph(null);
                return null;
            }
            NodeLayout[] childrenArray = allChildren.toArray(new NodeLayout[allChildren.size()]);
            if (subgraph == null) {
                subgraph = SpaceTreeLayoutAlgorithm.this.context.createSubgraph(childrenArray);
                subgraph.setDirection(SpaceTreeLayoutAlgorithm.this.getSubgraphDirection());
            } else {
                subgraph.addNodes(childrenArray);
            }
            if (!includeYourself) {
                this.setSubgraph(subgraph);
            }
            return subgraph;
        }

        public void setSubgraph(SubgraphLayout subgraph) {
            if (this.subgraph != subgraph) {
                this.subgraph = subgraph;
                this.refreshSubgraphLocation();
            }
        }

        public void adjustPosition(Point preferredLocation) {
            double newPositionInLayer;
            SpaceTreeLayoutAlgorithm.this.protectedNode = (SpaceTreeNode)this.owner.getSuperRoot();
            double d = newPositionInLayer = SpaceTreeLayoutAlgorithm.this.direction == 2 || SpaceTreeLayoutAlgorithm.this.direction == 1 ? preferredLocation.x : preferredLocation.y;
            if (((SpaceTreeNode)this.parent).expanded) {
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth)).moveNode(this, newPositionInLayer);
                this.centerParentsTopDown();
            }
        }

        public void refreshSubgraphLocation() {
            if (this.subgraph != null && this.subgraph.isGraphEntity()) {
                Point nodeLocation = this.node.getLocation();
                Dimension nodeSize = this.node.getSize();
                Dimension subgraphSize = this.subgraph.getSize();
                double x = 0.0;
                double y = 0.0;
                switch (SpaceTreeLayoutAlgorithm.this.direction) {
                    case 1: {
                        x = nodeLocation.x;
                        y = nodeLocation.y + (nodeSize.height + subgraphSize.height) / 2.0;
                        break;
                    }
                    case 2: {
                        x = nodeLocation.x;
                        y = nodeLocation.y - (nodeSize.height + subgraphSize.height) / 2.0;
                        break;
                    }
                    case 3: {
                        x = nodeLocation.x + (nodeSize.width + subgraphSize.width) / 2.0;
                        y = nodeLocation.y;
                        break;
                    }
                    case 4: {
                        x = nodeLocation.x - (nodeSize.width + subgraphSize.height) / 2.0;
                        y = nodeLocation.y;
                    }
                }
                this.subgraph.setLocation(x, y);
            }
            ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth)).refreshThickness();
        }

        public double spaceRequiredForNode() {
            if (this.node == null) {
                return 0.0;
            }
            switch (SpaceTreeLayoutAlgorithm.this.direction) {
                case 1: 
                case 2: {
                    return this.node.getSize().width;
                }
                case 3: 
                case 4: {
                    return this.node.getSize().height;
                }
            }
            throw new RuntimeException("invalid direction");
        }

        public double spaceRequiredForChildren() {
            if (this.children.isEmpty()) {
                return 0.0;
            }
            double result = 0.0;
            for (SpaceTreeNode child : this.children) {
                result += child.spaceRequiredForNode();
            }
            return result += SpaceTreeLayoutAlgorithm.this.leafGap * (double)(this.children.size() - 1);
        }

        public boolean childrenPositionsOK(ArrayList nodesToCheck) {
            for (SpaceTreeNode node : nodesToCheck) {
                if (node.depth < 0 || node.children.isEmpty()) continue;
                SpaceTreeNode child = (SpaceTreeNode)node.children.get(0);
                if (child.positionInLayer > node.positionInLayer) {
                    ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(node.depth)).moveNode(node, child.positionInLayer);
                    if (child.positionInLayer > node.positionInLayer) {
                        ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth)).moveNode(child, node.positionInLayer);
                        if (child.positionInLayer > node.positionInLayer) {
                            return false;
                        }
                    }
                }
                child = (SpaceTreeNode)node.children.get(node.children.size() - 1);
                if (!(child.positionInLayer < node.positionInLayer)) continue;
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(node.depth)).moveNode(node, child.positionInLayer);
                if (!(child.positionInLayer < node.positionInLayer)) continue;
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth)).moveNode(child, node.positionInLayer);
                if (!(child.positionInLayer < node.positionInLayer)) continue;
                return false;
            }
            return true;
        }

        public void centerParentsBottomUp() {
            if (!this.children.isEmpty() && this.expanded) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((SpaceTreeNode)iterator.next()).centerParentsBottomUp();
                }
                if (this.depth >= 0) {
                    SpaceTreeNode firstChild = (SpaceTreeNode)this.children.get(0);
                    SpaceTreeNode lastChild = (SpaceTreeNode)this.children.get(this.children.size() - 1);
                    SpaceTreeLayer layer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth);
                    layer.moveNode(this, (firstChild.positionInLayer + lastChild.positionInLayer) / 2.0);
                }
            }
        }

        public void centerParentsTopDown() {
            if (this == this.owner.getSuperRoot()) {
                this.positionInLayer = SpaceTreeLayoutAlgorithm.this.getAvailableSpace() / 2.0;
            }
            if (!this.children.isEmpty() && this.expanded) {
                SpaceTreeNode firstChild = (SpaceTreeNode)this.children.get(0);
                SpaceTreeNode lastChild = (SpaceTreeNode)this.children.get(this.children.size() - 1);
                double offset = this.positionInLayer - (firstChild.positionInLayer + lastChild.positionInLayer) / 2.0;
                if (firstChild.positionInLayer - firstChild.spaceRequiredForNode() / 2.0 + offset < 0.0) {
                    offset = -firstChild.positionInLayer + firstChild.spaceRequiredForNode() / 2.0;
                }
                double availableSpace = SpaceTreeLayoutAlgorithm.this.getAvailableSpace();
                if (lastChild.positionInLayer + lastChild.spaceRequiredForNode() / 2.0 + offset > availableSpace) {
                    offset = availableSpace - lastChild.positionInLayer - lastChild.spaceRequiredForNode() / 2.0;
                }
                SpaceTreeLayer layer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                layer.fitNodesWithinBounds(this.children, firstChild.positionInLayer + offset, lastChild.positionInLayer + offset);
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((SpaceTreeNode)iterator.next()).centerParentsTopDown();
                }
            }
        }

        public void flushExpansionChanges() {
            if (this.node != null) {
                this.node.prune(null);
            }
            if (this.expanded) {
                this.setSubgraph(null);
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((SpaceTreeNode)iterator.next()).flushExpansionChanges();
                }
            }
            if (!this.expanded && this.subgraph == null) {
                this.collapseAllChildrenIntoSubgraph(null, false);
            }
        }

        public boolean flushCollapseChanges() {
            if (!this.expanded) {
                int newNumberOfChildrenInSubgraph;
                int numberOfChildrenInSubgraph = this.subgraph == null ? 0 : this.subgraph.countNodes();
                this.collapseAllChildrenIntoSubgraph(this.subgraph, false);
                int n = newNumberOfChildrenInSubgraph = this.subgraph == null ? 0 : this.subgraph.countNodes();
                if (numberOfChildrenInSubgraph != newNumberOfChildrenInSubgraph && newNumberOfChildrenInSubgraph > 0) {
                    this.refreshSubgraphLocation();
                }
                return numberOfChildrenInSubgraph != newNumberOfChildrenInSubgraph;
            }
            if (this.expanded && this.subgraph == null) {
                boolean madeChagnes = false;
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    boolean bl = madeChagnes = ((SpaceTreeNode)iterator.next()).flushCollapseChanges() || madeChagnes;
                }
                return madeChagnes;
            }
            return false;
        }

        public boolean flushLocationChanges(double thicknessSoFar) {
            boolean madeChanges = false;
            if (this.node != null) {
                Dimension nodeSize = this.node.getSize();
                double x = 0.0;
                double y = 0.0;
                switch (SpaceTreeLayoutAlgorithm.this.direction) {
                    case 1: {
                        x = SpaceTreeLayoutAlgorithm.this.bounds.getX() + this.positionInLayer;
                        y = thicknessSoFar + nodeSize.height / 2.0;
                        break;
                    }
                    case 2: {
                        x = SpaceTreeLayoutAlgorithm.this.bounds.getX() + this.positionInLayer;
                        y = SpaceTreeLayoutAlgorithm.this.bounds.getY() + SpaceTreeLayoutAlgorithm.this.bounds.getHeight() - thicknessSoFar - nodeSize.height / 2.0;
                        break;
                    }
                    case 3: {
                        x = thicknessSoFar + nodeSize.height / 2.0;
                        y = SpaceTreeLayoutAlgorithm.this.bounds.getY() + this.positionInLayer;
                        break;
                    }
                    case 4: {
                        x = SpaceTreeLayoutAlgorithm.this.bounds.getX() + SpaceTreeLayoutAlgorithm.this.bounds.getWidth() - thicknessSoFar - nodeSize.height / 2.0;
                        y = SpaceTreeLayoutAlgorithm.this.bounds.getY() + this.positionInLayer;
                    }
                }
                Point currentLocation = this.node.getLocation();
                if (currentLocation.x != x || currentLocation.y != y) {
                    this.node.setLocation(x, y);
                    this.refreshSubgraphLocation();
                    madeChanges = true;
                }
            }
            if (this.expanded && this.subgraph == null) {
                thicknessSoFar += (this.depth >= 0 ? ((SpaceTreeLayer)((SpaceTreeLayoutAlgorithm)SpaceTreeLayoutAlgorithm.this).spaceTreeLayers.get((int)this.depth)).thickness : 0.0) + SpaceTreeLayoutAlgorithm.this.layerGap;
                for (SpaceTreeNode child : this.children) {
                    boolean bl = madeChanges = child.flushLocationChanges(thicknessSoFar) || madeChanges;
                }
            }
            return madeChanges;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.depth) {
                sb.append(" ");
                ++i;
            }
            if (this.node != null) {
                sb.append(this.node.toString());
            }
            sb.append("|" + this.order);
            sb.append('\n');
            for (SpaceTreeNode child : this.children) {
                sb.append(child.toString());
            }
            return sb.toString();
        }
    }
}

