/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.fixed;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.EmptyIterator;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.set.fixed.AbstractMemoryEfficientMutableSet;
import org.eclipse.collections.impl.set.fixed.SingletonSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class EmptySet<T>
extends AbstractMemoryEfficientMutableSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    EmptySet() {
    }

    private Object readResolve() {
        return Sets.fixedSize.of();
    }

    @Override
    public EmptySet<T> clone() {
        return this;
    }

    public int size() {
        return 0;
    }

    @Override
    public boolean contains(Object obj) {
        return false;
    }

    public T getFirst() {
        return null;
    }

    public T getLast() {
        return null;
    }

    public void each(Procedure<? super T> procedure) {
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
    }

    public Iterator<T> iterator() {
        return EmptyIterator.getInstance();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set set = (Set)other;
        return set.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T min() {
        throw new NoSuchElementException();
    }

    @Override
    public T max() {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        return Sets.fixedSize.of();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        return target;
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return Sets.fixedSize.of();
    }

    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        return target;
    }

    public MutableSet<T> with(T element) {
        return new SingletonSet<T>(element);
    }

    public MutableSet<T> without(T element) {
        return this;
    }
}

