/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleCharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.DoubleCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleCharMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleCharMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.DoubleCharPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleCharProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

/**
 * ImmutableDoubleCharHashMap is the non-modifiable equivalent of {@link DoubleCharHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableDoubleCharHashMap implements ImmutableDoubleCharMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableDoubleCharMap delegate;

    ImmutableDoubleCharHashMap(DoubleCharMap delegate)
    {
        this.delegate = new DoubleCharHashMap(delegate);
    }

    public char get(double key)
    {
        return this.delegate.get(key);
    }

    public char getIfAbsent(double key, char ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(double key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(char value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleCharProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<DoubleCharPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableDoubleCharMap select(DoubleCharPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleCharMap reject(DoubleCharPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableDoubleCharMap toImmutable()
    {
        return this;
    }

    public CharIterator charIterator()
    {
        return new UnmodifiableCharIterator(this.delegate.charIterator());
    }

    public void forEach(CharProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(CharPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public char max()
    {
        return this.delegate.max();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public char min()
    {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public char[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public char[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(char value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList()
    {
        return this.delegate.toList();
    }

    public MutableCharSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleCharMap newWithKeyValue(double key, char value)
    {
        MutableDoubleCharMap map = new DoubleCharHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleCharMap newWithoutKey(double key)
    {
        MutableDoubleCharMap map = new DoubleCharHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleCharMap newWithoutAllKeys(DoubleIterable keys)
    {
        MutableDoubleCharMap map = new DoubleCharHashMap(this.size());
        map.putAll(this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableDoubleCharMapSerializationProxy(this);
    }

    protected static class ImmutableDoubleCharMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private DoubleCharMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableDoubleCharMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableDoubleCharMapSerializationProxy(DoubleCharMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedDoubleCharProcedure()
                {
                    @Override
                    public void safeValue(double key, char value) throws IOException
                    {
                        out.writeDouble(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableDoubleCharMap deserializedMap = new DoubleCharHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readDouble(), in.readChar());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
