/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableShortBag extends MutableShortCollection, ShortBag
{
    void addOccurrences(short item, int occurrences);

    boolean removeOccurrences(short item, int occurrences);

    MutableShortBag select(ShortPredicate predicate);

    MutableShortBag reject(ShortPredicate predicate);

    <V> MutableBag<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortBag with(short element);

    MutableShortBag without(short element);

    MutableShortBag withAll(ShortIterable elements);

    MutableShortBag withoutAll(ShortIterable elements);

    MutableShortBag asUnmodifiable();

    MutableShortBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableShortBag toImmutable();
}
