/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.FieldInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldInfoTest {
    private IFieldInfo fFieldInfo1 = null;
    private IFieldInfo fFieldInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fFieldInfo1 = factory.getFieldInfo1();
        this.fFieldInfo2 = factory.getFieldInfo2();
    }

    @Test
    public void testFiledInfo() {
        FieldInfo fixture = new FieldInfo("field");
        Assert.assertNotNull((Object)fixture);
        Assert.assertEquals((Object)"field", (Object)fixture.getName());
        Assert.assertNull((Object)fixture.getFieldType());
    }

    @Test
    public void testEventInfoCopy() {
        FieldInfo info = new FieldInfo((FieldInfo)this.fFieldInfo1);
        Assert.assertEquals((Object)this.fFieldInfo1.getName(), (Object)info.getName());
        Assert.assertEquals((Object)this.fFieldInfo1.getFieldType(), (Object)info.getFieldType());
    }

    @Test
    public void testEventCopy2() {
        try {
            FieldInfo info = null;
            new FieldInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetFieldType() {
        FieldInfo info = new FieldInfo((FieldInfo)this.fFieldInfo1);
        info.setFieldType("string");
        Assert.assertEquals((Object)"string", (Object)info.getFieldType());
    }

    @Test
    public void testToString() {
        String result = this.fFieldInfo1.toString();
        Assert.assertEquals((Object)"[FieldInfo([TraceInfo(Name=intfield)],type=int", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fFieldInfo1.equals(this.fFieldInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fFieldInfo2.equals(this.fFieldInfo2));
        Assert.assertTrue((String)"equals", (!this.fFieldInfo1.equals(this.fFieldInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fFieldInfo2.equals(this.fFieldInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        FieldInfo info1 = new FieldInfo((FieldInfo)this.fFieldInfo1);
        FieldInfo info2 = new FieldInfo((FieldInfo)this.fFieldInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fFieldInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fFieldInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fFieldInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fFieldInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        FieldInfo info1 = new FieldInfo((FieldInfo)this.fFieldInfo1);
        FieldInfo info2 = new FieldInfo((FieldInfo)this.fFieldInfo1);
        FieldInfo info3 = new FieldInfo((FieldInfo)this.fFieldInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fFieldInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fFieldInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        FieldInfo info1 = new FieldInfo((FieldInfo)this.fFieldInfo1);
        FieldInfo info2 = new FieldInfo((FieldInfo)this.fFieldInfo2);
        Assert.assertTrue((String)"hashCode", (this.fFieldInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fFieldInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fFieldInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fFieldInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

