/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.tests.perf;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.ArrayListStore;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.LazyArrayListStore;
import org.eclipse.tracecompass.internal.segmentstore.core.treemap.TreeMapStore;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.segmentstore.core.tests.historytree.HistoryTreeSegmentStoreStub;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=Parameterized.class)
@NonNullByDefault
public class SegmentStoreBenchmark {
    private static final int DEFAULT_SAMPLE = 1000;
    private static final int DEFAULT_LOOP_COUNT = 10;
    private final ISegmentStore<@NonNull BasicSegment> fSegStore;
    private final String fName;
    private final Performance fPerf;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() throws IOException {
        return Arrays.asList({"Array list store", new ArrayListStore()}, {"Lazy array list store", new LazyArrayListStore()}, {"Treemap store", new TreeMapStore()}, {"HT store", new HistoryTreeSegmentStoreStub((Path)NonNullUtils.checkNotNull((Object)Files.createTempFile("tmpSegStore", null, new FileAttribute[0])), 0L, BasicSegment.BASIC_SEGMENT_READ_FACTORY)});
    }

    public SegmentStoreBenchmark(String name, ISegmentStore<@NonNull BasicSegment> segStore) {
        this.fSegStore = segStore;
        this.fName = name;
        this.fPerf = (Performance)NonNullUtils.checkNotNull((Object)Performance.getDefault());
    }

    protected long getSegmentStoreSize() {
        return 1000000L;
    }

    @Test
    public void test1Ordered() {
        PerformanceMeter pMorderedInsertion = this.fPerf.createPerformanceMeter("Ordered Insertion: " + this.fName);
        int size = 1;
        int[] fuzz = new int[1];
        int i = 0;
        while (i < 10) {
            this.fSegStore.clear();
            pMorderedInsertion.start();
            SegmentStoreBenchmark.populate(size, fuzz, this.fSegStore, 0L, this.getSegmentStoreSize());
            pMorderedInsertion.stop();
            ++i;
        }
        pMorderedInsertion.commit();
    }

    @Test
    public void test2FuzzyOrder() {
        int[] fuzz = SegmentStoreBenchmark.fuzzyArray(1000);
        this.fullTest(1000, fuzz, "Fuzzy");
    }

    @Test
    public void test3Random() {
        int[] fuzz = SegmentStoreBenchmark.randomArray(1000);
        this.fullTest(1000, fuzz, "Random");
    }

    @Test
    public void test4FuzzyInsertIterTwice() {
        int[] fuzz = SegmentStoreBenchmark.fuzzyArray(1000);
        this.insertIterTwice(1000, fuzz, "Fuzzy");
    }

    @Test
    public void test5RandomInsertIterTwice() {
        int[] fuzz = SegmentStoreBenchmark.randomArray(1000);
        this.insertIterTwice(1000, fuzz, "Random");
    }

    private static int[] randomArray(int size) {
        int[] fuzz = new int[1000];
        Random rng = new Random(10L);
        int i = 0;
        while (i < 1000) {
            fuzz[i] = Math.abs(rng.nextInt());
            ++i;
        }
        return fuzz;
    }

    private static int[] fuzzyArray(int size) {
        int[] fuzz = new int[1000];
        Random rng = new Random(10L);
        int i = 0;
        while (i < 1000) {
            fuzz[i] = rng.nextInt(1000);
            ++i;
        }
        return fuzz;
    }

    private void fullTest(int size, int[] fuzz, String distributionName) {
        PerformanceMeter pMinsertion = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " Insertion: " + this.fName);
        PerformanceMeter pMiterateStart = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " Iterate sorted by start: " + this.fName);
        PerformanceMeter pMiterateEnd = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " Iterate sorted by end: " + this.fName);
        PerformanceMeter pMiterateDuration = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " Iterate sorted by length: " + this.fName);
        int i = 0;
        while (i < 10) {
            this.fSegStore.clear();
            pMinsertion.start();
            SegmentStoreBenchmark.populate(size, fuzz, this.fSegStore, 0L, this.getSegmentStoreSize());
            pMinsertion.stop();
            if (i == 0) {
                SegmentStoreBenchmark.assertOrder(this.fSegStore, SegmentComparators.INTERVAL_START_COMPARATOR);
                SegmentStoreBenchmark.assertOrder(this.fSegStore, SegmentComparators.INTERVAL_END_COMPARATOR);
                SegmentStoreBenchmark.assertOrder(this.fSegStore, SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
            }
            pMiterateStart.start();
            int count = SegmentStoreBenchmark.sortedIterate(this.fSegStore, SegmentComparators.INTERVAL_START_COMPARATOR);
            pMiterateStart.stop();
            Assert.assertEquals((long)this.fSegStore.size(), (long)count);
            pMiterateEnd.start();
            count = SegmentStoreBenchmark.sortedIterate(this.fSegStore, SegmentComparators.INTERVAL_END_COMPARATOR);
            pMiterateEnd.stop();
            Assert.assertEquals((long)this.fSegStore.size(), (long)count);
            pMiterateDuration.start();
            count = SegmentStoreBenchmark.sortedIterate(this.fSegStore, SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
            pMiterateDuration.stop();
            Assert.assertEquals((long)this.fSegStore.size(), (long)count);
            ++i;
        }
        pMinsertion.commit();
        pMiterateStart.commit();
        pMiterateEnd.commit();
        pMiterateDuration.commit();
    }

    private void insertIterTwice(int size, int[] fuzz, String distributionName) {
        PerformanceMeter pMinsertion1 = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " First Insertion: " + this.fName);
        PerformanceMeter pMiterate1 = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " First Iteration: " + this.fName);
        PerformanceMeter pMinsertion2 = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " Second Insertion: " + this.fName);
        PerformanceMeter pMiterate2 = this.fPerf.createPerformanceMeter(String.valueOf(distributionName) + " Second Iteration: " + this.fName);
        int i = 0;
        while (i < 10) {
            this.fSegStore.clear();
            pMinsertion1.start();
            SegmentStoreBenchmark.populate(size, fuzz, this.fSegStore, 0L, this.getSegmentStoreSize() / 2L);
            pMinsertion1.stop();
            pMiterate1.start();
            int count = SegmentStoreBenchmark.iterate(this.fSegStore);
            pMiterate1.stop();
            Assert.assertEquals((long)this.fSegStore.size(), (long)count);
            pMinsertion2.start();
            SegmentStoreBenchmark.populate(size, fuzz, this.fSegStore, this.getSegmentStoreSize() / 2L + 1L, this.getSegmentStoreSize());
            pMinsertion2.stop();
            pMiterate2.start();
            count = SegmentStoreBenchmark.iterate(this.fSegStore);
            pMiterate2.stop();
            Assert.assertEquals((long)this.fSegStore.size(), (long)count);
            ++i;
        }
        pMinsertion1.commit();
        pMiterate1.commit();
        pMinsertion2.commit();
        pMiterate2.commit();
    }

    private static int iterate(Iterable<@NonNull BasicSegment> store) {
        int count = 0;
        Iterator<@NonNull BasicSegment> iterator = store.iterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static int sortedIterate(ISegmentStore<@NonNull BasicSegment> store, Comparator<ISegment> order) {
        @NonNull Iterable iterable = store.iterator(order);
        return SegmentStoreBenchmark.iterate(iterable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertOrder(ISegmentStore<@NonNull BasicSegment> store, Comparator<@NonNull ISegment> order) {
        @NonNull Iterable iterable = store.iterator(order);
        BasicSegment prev = null;
        long count = 0L;
        for (BasicSegment segment : iterable) {
            if (prev != null) {
                Assert.assertTrue((String)("Incorrect iteration order at: " + count + ", prev: " + prev + ", current: " + segment), (order.compare((ISegment)prev, (ISegment)segment) <= 0 ? 1 : 0) != 0);
            }
            prev = segment;
            ++count;
        }
    }

    private static void populate(int size, int[] fuzz, ISegmentStore<@NonNull BasicSegment> store, long low, long high) {
        long i = low;
        while (i < high) {
            long start = i + (long)fuzz[(int)(i % (long)size)];
            store.add((Object)new BasicSegment(start, start + 10L));
            ++i;
        }
    }
}

