/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TracePythonLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceMI;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LttngVersion;
import org.eclipse.tracecompass.lttng2.control.ui.tests.service.LTTngControlServiceTest;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LTTngControlServiceMiTest
extends LTTngControlServiceTest {
    private static final String MI_TEST_STREAM = "LTTngServiceMiTest.cfg";
    private static final String SCEN_SESSION_WITH_SYSCALLS = "GetSessionWithSyscalls";
    private static final String SCEN_LIST_SESSION_2_7_COMPAT = "ListSession2.7Compat";
    private static final String SCEN_ENABLING_JUL_LOGGERS = "EnableJulLoggers";
    private static final String SCEN_ENABLING_LOG4J_LOGGERS = "EnableLog4jLoggers";
    private static final String SCEN_ENABLING_PYTHON_LOGGERS = "EnablePythonLoggers";

    @Override
    protected ILttngControlService getControlService() {
        try {
            return new LTTngControlServiceMI((ICommandShell)this.getShell(), new LttngVersion("2.7.0"));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public void testGetSessionNameGarbage() {
        try {
            this.fShell.setScenario("GetSessionGarbageOut");
            this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Override
    @Ignore
    public void testCreateLiveSession() throws ExecutionException {
        this.fShell.setScenario("CreateSessionLive");
        SessionInfo params = new SessionInfo("mysession");
        params.setLive(true);
        params.setStreamedTrace(true);
        params.setNetworkUrl("net://127.0.0.1");
        ISessionInfo sessionInfo = this.fService.createSession((ISessionInfo)params, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)sessionInfo);
        Assert.assertEquals((Object)"mysession", (Object)sessionInfo.getName());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)sessionInfo.getSessionState());
        Assert.assertTrue((boolean)sessionInfo.isStreamedTrace());
        Assert.assertTrue((boolean)sessionInfo.isLive());
        Assert.assertEquals((Object)"tcp4://127.0.0.1:5342/ [data: 5343]", (Object)sessionInfo.getSessionPath());
        List names = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals(names.get(0), (Object)"mysession");
        this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected String getTestStream() {
        return MI_TEST_STREAM;
    }

    @Override
    protected TraceLogLevel getAllEventTraceLogLevel() {
        return TraceLogLevel.TRACE_DEBUG;
    }

    @Override
    public void testGetKernelProviderNoUstVerbose() {
    }

    @Override
    public void testCreateSession2_1() {
    }

    @Override
    public void testGetKernelProviderNoUst3() {
    }

    @Override
    public void testGetKernelProviderNoKernelVerbose() {
    }

    @Override
    public void testCreateSessionVerbose2_1() {
    }

    @Override
    public void testDestroySessionVerbose() {
    }

    @Override
    public void testCreateSessionWithPrompt() {
    }

    @Override
    public void testAddContext() {
    }

    @Override
    public void testAddContextFailure() {
    }

    @Override
    public void testCreateSnapshotSession2_5() {
    }

    @Test
    public void testListSycallEvents() {
        try {
            this.fShell.setScenario(SCEN_SESSION_WITH_SYSCALLS);
            ISessionInfo session = this.fService.getSession("mysession", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((Object)"mysession", (Object)session.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120129-084256", (Object)session.getSessionPath());
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
            IDomainInfo[] domains = session.getDomains();
            Assert.assertNotNull((Object)domains);
            Assert.assertEquals((long)1L, (long)domains.length);
            Assert.assertEquals((Object)"Kernel", (Object)domains[0].getName());
            IChannelInfo[] channels = domains[0].getChannels();
            Assert.assertNotNull((Object)channels);
            Assert.assertEquals((long)1L, (long)channels.length);
            Assert.assertEquals((Object)"channel0", (Object)channels[0].getName());
            Assert.assertEquals((long)4L, (long)channels[0].getNumberOfSubBuffers());
            Assert.assertEquals((Object)"splice()", (Object)channels[0].getOutputType().getInName());
            Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channels[0].getOutputType());
            Assert.assertEquals((Object)false, (Object)channels[0].isOverwriteMode());
            Assert.assertEquals((long)200L, (long)channels[0].getReadTimer());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channels[0].getState());
            Assert.assertEquals((long)262144L, (long)channels[0].getSubBufferSize());
            Assert.assertEquals((long)0L, (long)channels[0].getSwitchTimer());
            IEventInfo[] channel0Events = channels[0].getEvents();
            Assert.assertNotNull((Object)channel0Events);
            Assert.assertEquals((long)2L, (long)channel0Events.length);
            Assert.assertEquals((Object)"read", (Object)channel0Events[0].getName());
            Assert.assertEquals((Object)TraceEventType.SYSCALL, (Object)channel0Events[0].getEventType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel0Events[0].getState());
            Assert.assertEquals((Object)"write", (Object)channel0Events[1].getName());
            Assert.assertEquals((Object)TraceEventType.SYSCALL, (Object)channel0Events[1].getEventType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel0Events[1].getState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testListSessionCompatibility_2_7() {
        try {
            this.fShell.setScenario(SCEN_LIST_SESSION_2_7_COMPAT);
            ISessionInfo session = this.fService.getSession("mysession", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((Object)"mysession", (Object)session.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20151020-085614", (Object)session.getSessionPath());
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
            IDomainInfo[] domains = session.getDomains();
            Assert.assertNotNull((Object)domains);
            Assert.assertEquals((long)2L, (long)domains.length);
            Assert.assertEquals((Object)"Kernel", (Object)domains[0].getName());
            IChannelInfo[] channels = domains[0].getChannels();
            Assert.assertNotNull((Object)channels);
            Assert.assertEquals((long)1L, (long)channels.length);
            Assert.assertEquals((Object)"channel0", (Object)channels[0].getName());
            Assert.assertEquals((long)4L, (long)channels[0].getNumberOfSubBuffers());
            Assert.assertEquals((Object)"splice()", (Object)channels[0].getOutputType().getInName());
            Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channels[0].getOutputType());
            Assert.assertEquals((Object)false, (Object)channels[0].isOverwriteMode());
            Assert.assertEquals((long)200000L, (long)channels[0].getReadTimer());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channels[0].getState());
            Assert.assertEquals((long)262144L, (long)channels[0].getSubBufferSize());
            Assert.assertEquals((long)0L, (long)channels[0].getSwitchTimer());
            IEventInfo[] channel0Events = channels[0].getEvents();
            Assert.assertNotNull((Object)channel0Events);
            Assert.assertEquals((long)2L, (long)channel0Events.length);
            Assert.assertEquals((Object)"*", (Object)channel0Events[0].getName());
            Assert.assertEquals((Object)TraceEventType.SYSCALL, (Object)channel0Events[0].getEventType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel0Events[0].getState());
            Assert.assertEquals((Object)"*", (Object)channel0Events[1].getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)channel0Events[1].getLogLevel());
            Assert.assertEquals((Object)LogLevelType.LOGLEVEL_ALL, (Object)channel0Events[1].getLogLevelType());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)channel0Events[1].getEventType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel0Events[1].getState());
            Assert.assertEquals((Object)"UST global", (Object)domains[1].getName());
            IChannelInfo[] ustChannels = domains[1].getChannels();
            Assert.assertEquals((Object)"channel0", (Object)ustChannels[0].getName());
            Assert.assertEquals((long)4L, (long)ustChannels[0].getNumberOfSubBuffers());
            Assert.assertEquals((Object)"mmap()", (Object)ustChannels[0].getOutputType().getInName());
            Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)ustChannels[0].getOutputType());
            Assert.assertEquals((Object)false, (Object)ustChannels[0].isOverwriteMode());
            Assert.assertEquals((long)0L, (long)ustChannels[0].getReadTimer());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)ustChannels[0].getState());
            Assert.assertEquals((long)4096L, (long)ustChannels[0].getSubBufferSize());
            Assert.assertEquals((long)0L, (long)ustChannels[0].getSwitchTimer());
            IEventInfo[] ustEvents = ustChannels[0].getEvents();
            Assert.assertEquals((long)1L, (long)ustEvents.length);
            Assert.assertEquals((Object)"*", (Object)ustEvents[0].getName());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)ustEvents[0].getEventType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)ustEvents[0].getState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Override
    public void testEnableJulLoggers() {
        try {
            String sessionName = "mysession";
            ArrayList<String> loggerList = new ArrayList<String>();
            String loggerName1 = "logger";
            String loggerName2 = "anotherLogger";
            String allLoggerName = "*";
            this.fShell.setScenario(SCEN_ENABLING_JUL_LOGGERS);
            loggerList.add(allLoggerName);
            this.fService.enableEvents(sessionName, null, loggerList, TraceDomainType.JUL, null, null, (IProgressMonitor)new NullProgressMonitor());
            loggerList.clear();
            loggerList.add(loggerName1);
            this.fService.enableEvents(sessionName, null, loggerList, TraceDomainType.JUL, null, null, (IProgressMonitor)new NullProgressMonitor());
            loggerList.add(loggerName2);
            this.fService.enableLogLevel(sessionName, null, loggerList, LogLevelType.LOGLEVEL_ONLY, (ITraceLogLevel)TraceJulLogLevel.JUL_WARNING, null, TraceDomainType.JUL, (IProgressMonitor)new NullProgressMonitor());
            @Nullable ISessionInfo session = this.fService.getSession(sessionName, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            List loggers = session.getDomains()[1].getLoggers();
            Assert.assertNotNull((Object)loggers);
            Assert.assertEquals((long)loggers.size(), (long)4L);
            ILoggerInfo loggerInfo = loggers.stream().filter(logger -> logger.getName().equals(loggerName2)).findFirst().get();
            Assert.assertEquals((Object)loggerName2, (Object)loggerInfo.getName());
            Assert.assertEquals((Object)TraceDomainType.JUL, (Object)loggerInfo.getDomain());
            Assert.assertEquals((Object)TraceJulLogLevel.JUL_WARNING, (Object)loggerInfo.getLogLevel());
            Assert.assertEquals((Object)LogLevelType.LOGLEVEL_ONLY, (Object)loggerInfo.getLogLevelType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)loggerInfo.getState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Override
    public void testEnableLog4jLoggers() {
        try {
            String sessionName = "mysession";
            ArrayList<String> loggerList = new ArrayList<String>();
            String loggerName1 = "logger";
            String loggerName2 = "anotherLogger";
            String allLoggerName = "*";
            this.fShell.setScenario(SCEN_ENABLING_LOG4J_LOGGERS);
            loggerList.add(allLoggerName);
            this.fService.enableEvents(sessionName, null, loggerList, TraceDomainType.LOG4J, null, null, (IProgressMonitor)new NullProgressMonitor());
            loggerList.clear();
            loggerList.add(loggerName1);
            this.fService.enableEvents(sessionName, null, loggerList, TraceDomainType.LOG4J, null, null, (IProgressMonitor)new NullProgressMonitor());
            loggerList.add(loggerName2);
            this.fService.enableLogLevel(sessionName, null, loggerList, LogLevelType.LOGLEVEL_ONLY, (ITraceLogLevel)TraceLog4jLogLevel.LOG4J_FATAL, null, TraceDomainType.LOG4J, (IProgressMonitor)new NullProgressMonitor());
            @Nullable ISessionInfo session = this.fService.getSession(sessionName, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            List loggers = session.getDomains()[1].getLoggers();
            Assert.assertNotNull((Object)loggers);
            Assert.assertEquals((long)4L, (long)loggers.size());
            ILoggerInfo loggerInfo = loggers.stream().filter(logger -> logger.getName().equals(loggerName2)).findFirst().get();
            Assert.assertEquals((Object)loggerName2, (Object)loggerInfo.getName());
            Assert.assertEquals((Object)TraceDomainType.LOG4J, (Object)loggerInfo.getDomain());
            Assert.assertEquals((Object)TraceLog4jLogLevel.LOG4J_FATAL, (Object)loggerInfo.getLogLevel());
            Assert.assertEquals((Object)LogLevelType.LOGLEVEL_ONLY, (Object)loggerInfo.getLogLevelType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)loggerInfo.getState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Override
    public void testEnablePythonLoggers() {
        try {
            String sessionName = "mysession";
            ArrayList<String> loggerList = new ArrayList<String>();
            String loggerName1 = "logger";
            String loggerName2 = "anotherLogger";
            String allLoggerName = "*";
            this.fShell.setScenario(SCEN_ENABLING_PYTHON_LOGGERS);
            loggerList.add(allLoggerName);
            this.fService.enableEvents(sessionName, null, loggerList, TraceDomainType.PYTHON, null, null, (IProgressMonitor)new NullProgressMonitor());
            loggerList.clear();
            loggerList.add(loggerName1);
            this.fService.enableEvents(sessionName, null, loggerList, TraceDomainType.PYTHON, null, null, (IProgressMonitor)new NullProgressMonitor());
            loggerList.add(loggerName2);
            this.fService.enableLogLevel(sessionName, null, loggerList, LogLevelType.LOGLEVEL_ONLY, (ITraceLogLevel)TracePythonLogLevel.PYTHON_CRITICAL, null, TraceDomainType.PYTHON, (IProgressMonitor)new NullProgressMonitor());
            @Nullable ISessionInfo session = this.fService.getSession(sessionName, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            List loggers = session.getDomains()[1].getLoggers();
            Assert.assertNotNull((Object)loggers);
            Assert.assertEquals((long)4L, (long)loggers.size());
            ILoggerInfo loggerInfo = loggers.stream().filter(logger -> logger.getName().equals(loggerName2)).findFirst().get();
            Assert.assertEquals((Object)loggerName2, (Object)loggerInfo.getName());
            Assert.assertEquals((Object)TraceDomainType.PYTHON, (Object)loggerInfo.getDomain());
            Assert.assertEquals((Object)TracePythonLogLevel.PYTHON_CRITICAL, (Object)loggerInfo.getLogLevel());
            Assert.assertEquals((Object)LogLevelType.LOGLEVEL_ONLY, (Object)loggerInfo.getLogLevelType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)loggerInfo.getState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }
}

