/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swtchart.IDisposeListener;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;
import org.eclipse.swtchart.extensions.properties.AbstractSelectorPage;
import org.eclipse.swtchart.extensions.properties.Messages;
import org.eclipse.swtchart.extensions.properties.PropertiesResources;

public class SeriesLabelPage
extends AbstractSelectorPage {
    private static final String SERIES_LABEL_FOREGROUND = "org.eclipse.swtchart.series.foreground";
    private static final String SERIES_LABEL_FONT = "org.eclipse.swtchart.series.font";
    private ISeries[] series;
    protected Button showLabelButton;
    private Label colorLabel;
    protected ColorSelector colorButton;
    private Label fontSizeLabel;
    protected Spinner fontSizeSpinner;
    protected boolean[] visibleStates;
    protected RGB[] colors;
    protected int[] fontSizes;

    public SeriesLabelPage(InteractiveChart chart, PropertiesResources resources, String title) {
        super(chart, resources, title, Messages.getString(Messages.SERIES));
        this.series = chart.getSeriesSet().getSeries();
        this.visibleStates = new boolean[this.series.length];
        this.colors = new RGB[this.series.length];
        this.fontSizes = new int[this.series.length];
    }

    @Override
    protected String[] getListItems() {
        String[] items = new String[this.series.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.series[i].getId());
            ++i;
        }
        return items;
    }

    @Override
    protected void selectInitialValues() {
        int i = 0;
        while (i < this.series.length) {
            this.visibleStates[i] = this.series[i].getLabel().isVisible();
            this.colors[i] = this.series[i].getLabel().getForeground().getRGB();
            this.fontSizes[i] = this.series[i].getLabel().getFont().getFontData()[0].getHeight();
            ++i;
        }
    }

    @Override
    protected void updateControlSelections() {
        this.showLabelButton.setSelection(this.visibleStates[this.selectedIndex]);
        this.setControlsEnable(this.visibleStates[this.selectedIndex]);
        this.colorButton.setColorValue(this.colors[this.selectedIndex]);
        this.fontSizeSpinner.setSelection(this.fontSizes[this.selectedIndex]);
    }

    @Override
    protected void addRightPanelContents(Composite parent) {
        this.addSeriesLabelPanel(parent);
    }

    private void addSeriesLabelPanel(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        this.showLabelButton = this.createCheckBoxControl(group, Messages.getString(Messages.SHOW_LABEL));
        this.showLabelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible;
                SeriesLabelPage.this.visibleStates[SeriesLabelPage.this.selectedIndex] = visible = SeriesLabelPage.this.showLabelButton.getSelection();
                SeriesLabelPage.this.setControlsEnable(visible);
            }
        });
        this.colorLabel = this.createLabelControl(group, Messages.getString(Messages.COLOR));
        this.colorButton = this.createColorButtonControl(group);
        this.colorButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SeriesLabelPage.this.colors[SeriesLabelPage.this.selectedIndex] = SeriesLabelPage.this.colorButton.getColorValue();
            }
        });
        this.fontSizeLabel = this.createLabelControl(group, Messages.getString(Messages.FONT_SIZE));
        this.fontSizeSpinner = this.createSpinnerControl(group, 8, 30);
        this.fontSizeSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SeriesLabelPage.this.fontSizes[SeriesLabelPage.this.selectedIndex] = SeriesLabelPage.this.fontSizeSpinner.getSelection();
            }
        });
    }

    protected void setControlsEnable(boolean enabled) {
        this.colorLabel.setEnabled(enabled);
        this.colorButton.setEnabled(enabled);
        this.fontSizeLabel.setEnabled(enabled);
        this.fontSizeSpinner.setEnabled(enabled);
    }

    @Override
    public void apply() {
        int i = 0;
        while (i < this.series.length) {
            this.series[i].getLabel().setVisible(this.visibleStates[i]);
            Color color = new Color((Device)Display.getDefault(), this.colors[i]);
            this.series[i].getLabel().setForeground(color);
            final String colorKey = SERIES_LABEL_FOREGROUND + this.series[i].getId();
            if (this.resources.getColor(colorKey) == null) {
                this.series[i].addDisposeListener(new IDisposeListener(){

                    public void disposed(Event e) {
                        SeriesLabelPage.this.resources.removeColor(colorKey);
                    }
                });
            }
            this.resources.put(colorKey, color);
            FontData fontData = this.series[i].getLabel().getFont().getFontData()[0];
            fontData.setHeight(this.fontSizes[i]);
            Font font = new Font((Device)Display.getDefault(), fontData);
            this.series[i].getLabel().setFont(font);
            final String fontKey = SERIES_LABEL_FONT + this.series[i].getId();
            if (this.resources.getFont(fontKey) == null) {
                this.series[i].addDisposeListener(new IDisposeListener(){

                    public void disposed(Event e) {
                        SeriesLabelPage.this.resources.removeFont(fontKey);
                    }
                });
            }
            this.resources.put(fontKey, font);
            ++i;
        }
    }

    protected void performDefaults() {
        this.visibleStates[this.selectedIndex] = false;
        this.colors[this.selectedIndex] = Display.getDefault().getSystemColor(2).getRGB();
        this.fontSizes[this.selectedIndex] = 9;
        this.updateControlSelections();
        super.performDefaults();
    }
}

