/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.markers;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Arrays;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.junit.Assert;
import org.junit.Test;

public class MarkerTest {
    @Test
    public void testConstructor() {
        Marker.PeriodicMarker marker = new Marker.PeriodicMarker("name", "label", "id", "referenceid", "color", 1.0, "ms", Range.atLeast((Comparable)Long.valueOf(0L)), 0L, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        Assert.assertEquals((Object)"name", (Object)marker.getName());
        Assert.assertEquals((Object)"label", (Object)marker.getLabel());
        Assert.assertEquals((Object)"id", (Object)marker.getId());
        Assert.assertEquals((Object)"referenceid", (Object)marker.getReferenceId());
        Assert.assertEquals((Object)"color", (Object)marker.getColor());
        Assert.assertEquals((double)1.0, (double)marker.getPeriod(), (double)0.0);
        Assert.assertEquals((Object)"ms", (Object)marker.getUnit());
        Assert.assertEquals((Object)Range.atLeast((Comparable)Long.valueOf(0L)), (Object)marker.getRange());
        Assert.assertEquals((long)0L, (long)marker.getOffset());
        Assert.assertEquals((Object)ImmutableRangeSet.of((Range)Range.all()), (Object)marker.getIndexRange());
        Assert.assertEquals((long)0L, (long)marker.getSubMarkers().size());
    }

    @Test
    public void testAddSubMarker() {
        Marker.PeriodicMarker marker = new Marker.PeriodicMarker("name", "label", "id", "referenceid", "color", 1.0, "ms", Range.atLeast((Comparable)Long.valueOf(0L)), 0L, (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        SubMarker.SplitMarker subMarkerA = new SubMarker.SplitMarker("A", "a", "a", "color", Range.atLeast((Comparable)Long.valueOf(0L)), (RangeSet)ImmutableRangeSet.of((Range)Range.all()));
        marker.addSubMarker((SubMarker)subMarkerA);
        SubMarker.WeightedMarker subMarkerB = new SubMarker.WeightedMarker("B");
        marker.addSubMarker((SubMarker)subMarkerB);
        Assert.assertEquals(Arrays.asList(subMarkerA, subMarkerB), (Object)marker.getSubMarkers());
    }

    @Test
    public void testAddSegment() {
        SubMarker.WeightedMarker subMarker = new SubMarker.WeightedMarker("name");
        MarkerSegment segmentA = new MarkerSegment("A", "a", "color1", 1);
        subMarker.addSegment(segmentA);
        MarkerSegment segmentB = new MarkerSegment("B", "b", "color2", 2);
        subMarker.addSegment(segmentB);
        Assert.assertEquals(Arrays.asList(segmentA, segmentB), (Object)subMarker.getSegments());
    }
}

