/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.StructuredTextInvocationContext;
import org.eclipse.wst.sse.ui.internal.correction.QuickFixRegistry;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public class SourceValidationQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public boolean canFix(Annotation annotation) {
        if (annotation instanceof IQuickFixableAnnotation && ((IQuickFixableAnnotation)annotation).isQuickFixableStateSet()) {
            return ((IQuickFixableAnnotation)annotation).isQuickFixable();
        }
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        IAnnotationModel model;
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        IAnnotationModel iAnnotationModel = model = viewer != null ? viewer.getAnnotationModel() : null;
        if (model == null) {
            return null;
        }
        ArrayList<ICompletionProposal> allProposals = new ArrayList<ICompletionProposal>();
        if (model instanceof IAnnotationModelExtension2) {
            Iterator iter = ((IAnnotationModelExtension2)model).getAnnotationIterator(documentOffset, length, true, true);
            while (iter.hasNext()) {
                Object o;
                ArrayList<IQuickAssistProcessor> processors = new ArrayList<IQuickAssistProcessor>();
                Annotation anno = (Annotation)iter.next();
                if (!this.canFix(anno)) continue;
                if (anno instanceof TemporaryAnnotation && (o = ((TemporaryAnnotation)anno).getAdditionalFixInfo()) instanceof IQuickAssistProcessor) {
                    processors.add((IQuickAssistProcessor)o);
                }
                QuickFixRegistry registry = QuickFixRegistry.getInstance();
                processors.addAll(Arrays.asList(registry.getQuickFixProcessors(anno)));
                Map<String, String> attributes = null;
                if (anno instanceof TemporaryAnnotation) {
                    attributes = ((TemporaryAnnotation)anno).getAttributes();
                }
                Position pos = model.getPosition(anno);
                StructuredTextInvocationContext sseContext = new StructuredTextInvocationContext(viewer, pos.getOffset(), pos.getLength(), attributes);
                int i = 0;
                while (i < processors.size()) {
                    ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                    this.collectProposals((IQuickAssistProcessor)processors.get(i), anno, (IQuickAssistInvocationContext)sseContext, proposals);
                    if (proposals.size() > 0) {
                        allProposals.addAll(proposals);
                    }
                    ++i;
                }
            }
        }
        if (allProposals.isEmpty()) {
            return null;
        }
        return allProposals.toArray(new ICompletionProposal[allProposals.size()]);
    }

    private void collectProposals(IQuickAssistProcessor processor, Annotation annotation, IQuickAssistInvocationContext invocationContext, List<ICompletionProposal> proposalsList) {
        ICompletionProposal[] proposals = processor.computeQuickAssistProposals(invocationContext);
        if (proposals != null && proposals.length > 0) {
            proposalsList.addAll(Arrays.asList(proposals));
        }
    }

    public String getErrorMessage() {
        return null;
    }
}

