/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public abstract class CleanupAction
extends TextEditorAction {
    protected Dialog fCleanupDialog;

    public CleanupAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected abstract Dialog getCleanupDialog(Shell var1);

    protected abstract IStructuredCleanupProcessor getCleanupProcessor();

    public void run() {
        StructuredTextEditor editor;
        Dialog cleanupDialog;
        if (this.getTextEditor() instanceof StructuredTextEditor && (cleanupDialog = this.getCleanupDialog((editor = (StructuredTextEditor)this.getTextEditor()).getSite().getShell())) != null && cleanupDialog.open() == 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IStructuredCleanupProcessor cleanupProcessor = CleanupAction.this.getCleanupProcessor();
                    if (cleanupProcessor != null) {
                        cleanupProcessor.cleanupModel(editor.getModel());
                    }
                }
            };
            IStructuredModel model = editor.getModel();
            if (model != null) {
                try {
                    ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                    model.beginRecording((Object)this, SSEUIMessages.Cleanup_Document_UI_, SSEUIMessages.Cleanup_Document_UI_, selection.getOffset(), selection.getLength());
                    model.aboutToChangeModel();
                    BusyIndicator.showWhile((Display)editor.getTextViewer().getControl().getDisplay(), (Runnable)runnable);
                }
                finally {
                    model.changedModel();
                    ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                    model.endRecording((Object)this, selection.getOffset(), selection.getLength());
                }
            }
        }
    }
}

