/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import org.eclipse.cdt.internal.core.natives.CNativePlugin;
import org.eclipse.cdt.internal.core.natives.Messages;
import org.eclipse.cdt.utils.pty.PTYInputStream;
import org.eclipse.cdt.utils.pty.PTYOutputStream;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.Platform;

public class PTY {
    final boolean console;
    final String slave;
    final PTYInputStream in;
    final PTYOutputStream out;
    int master;
    private static boolean hasPTY;
    private static boolean isWinPTY;
    private static boolean isConsoleModeSupported;
    private static boolean setTerminalSizeErrorAlreadyLogged;

    static {
        try {
            System.loadLibrary("pty");
            hasPTY = true;
            isWinPTY = "win32".equals(Platform.getOS());
            isConsoleModeSupported = !isWinPTY || Boolean.getBoolean("org.eclipse.cdt.core.winpty_console_mode");
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public static boolean isSupported() {
        return PTY.isSupported(Mode.CONSOLE);
    }

    public static boolean isSupported(Mode mode) {
        return hasPTY && (isConsoleModeSupported || mode == Mode.TERMINAL);
    }

    public PTY() throws IOException {
        this(Mode.CONSOLE);
    }

    public PTY(Mode mode) throws IOException {
        this(mode == Mode.CONSOLE);
    }

    @Deprecated
    public PTY(boolean console) throws IOException {
        this.console = console;
        if (console && !isConsoleModeSupported) {
            throw new IOException(Messages.Util_exception_cannotCreatePty);
        }
        String string = this.slave = hasPTY ? this.openMaster(console) : null;
        if (this.slave == null) {
            throw new IOException(Messages.Util_exception_cannotCreatePty);
        }
        this.in = new PTYInputStream(new MasterFD());
        this.out = new PTYOutputStream(new MasterFD(), !isWinPTY);
    }

    public void validateSlaveName() throws IOException {
        if (isWinPTY) {
            throw new IOException("Slave name is not valid");
        }
    }

    public String getSlaveName() {
        return this.slave;
    }

    public MasterFD getMasterFD() {
        return new MasterFD();
    }

    public final boolean isConsole() {
        return this.console;
    }

    public PTYOutputStream getOutputStream() {
        return this.out;
    }

    public PTYInputStream getInputStream() {
        return this.in;
    }

    public final void setTerminalSize(int width, int height) {
        block2: {
            try {
                this.change_window_size(this.master, width, height);
            }
            catch (UnsatisfiedLinkError ule) {
                if (setTerminalSizeErrorAlreadyLogged) break block2;
                setTerminalSizeErrorAlreadyLogged = true;
                CNativePlugin.log(Messages.Util_exception_cannotSetTerminalSize, ule);
            }
        }
    }

    public int exec_pty(Spawner spawner, String[] cmdarray, String[] envp, String dir, int[] chan) throws IOException {
        if (isWinPTY) {
            return this.exec2(cmdarray, envp, dir, chan, this.slave, this.master, this.console);
        }
        return spawner.exec2(cmdarray, envp, dir, chan, this.slave, this.master, this.console);
    }

    public int waitFor(Spawner spawner, int pid) {
        if (isWinPTY) {
            return this.waitFor(this.master, pid);
        }
        return spawner.waitFor(pid);
    }

    native String openMaster(boolean var1);

    native int change_window_size(int var1, int var2, int var3);

    native int exec2(String[] var1, String[] var2, String var3, int[] var4, String var5, int var6, boolean var7) throws IOException;

    native int waitFor(int var1, int var2);

    public class MasterFD {
        public int getFD() {
            return PTY.this.master;
        }

        void setFD(int fd) {
            PTY.this.master = fd;
        }
    }

    public static enum Mode {
        CONSOLE,
        TERMINAL;

    }
}

