/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.statevalue;

import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.junit.Assert;
import org.junit.Test;

public class StateValueCompareToTest {
    private static final ITmfStateValue BASE_INT_VALUE = TmfStateValue.newValueInt((int)10);
    private static final ITmfStateValue BIGGER_INT_VALUE = TmfStateValue.newValueInt((int)20);
    private static final ITmfStateValue SMALLER_INT_VALUE = TmfStateValue.newValueInt((int)6);
    private static final ITmfStateValue BASE_LONG_VALUE = TmfStateValue.newValueLong((long)10L);
    private static final ITmfStateValue BIGGER_LONG_VALUE = TmfStateValue.newValueLong((long)20L);
    private static final ITmfStateValue SMALLER_LONG_VALUE = TmfStateValue.newValueLong((long)6L);
    private static final ITmfStateValue MIN_LONG_VALUE = TmfStateValue.newValueLong((long)Long.MIN_VALUE);
    private static final ITmfStateValue MAX_LONG_VALUE = TmfStateValue.newValueLong((long)Long.MAX_VALUE);
    private static final ITmfStateValue BASE_DOUBLE_VALUE = TmfStateValue.newValueDouble((double)10.0);
    private static final ITmfStateValue BIGGER_DOUBLE_VALUE1 = TmfStateValue.newValueDouble((double)20.0);
    private static final ITmfStateValue BIGGER_DOUBLE_VALUE2 = TmfStateValue.newValueDouble((double)10.03);
    private static final ITmfStateValue SMALLER_DOUBLE_VALUE1 = TmfStateValue.newValueDouble((double)6.0);
    private static final ITmfStateValue SMALLER_DOUBLE_VALUE2 = TmfStateValue.newValueDouble((double)9.99);
    private static final ITmfStateValue MIN_DOUBLE_VALUE = TmfStateValue.newValueDouble((double)Double.MIN_VALUE);
    private static final ITmfStateValue MAX_DOUBLE_VALUE = TmfStateValue.newValueDouble((double)Double.MAX_VALUE);
    private static final ITmfStateValue POSITIVE_INFINITY = TmfStateValue.newValueDouble((double)Double.POSITIVE_INFINITY);
    private static final ITmfStateValue NEGATIVE_INFINITY = TmfStateValue.newValueDouble((double)Double.NEGATIVE_INFINITY);
    private static final ITmfStateValue BASE_STRING_VALUE = TmfStateValue.newValueString((String)"D");
    private static final ITmfStateValue BIGGER_STRING_VALUE = TmfStateValue.newValueString((String)"Z");
    private static final ITmfStateValue SMALLER_STRING_VALUE = TmfStateValue.newValueString((String)"A");
    private static final ITmfStateValue NULL_VALUE = TmfStateValue.nullValue();

    @Test
    public void compareIntWithInt() {
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)BASE_INT_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)BIGGER_INT_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)SMALLER_INT_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareIntWithLong() {
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)BASE_LONG_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)BIGGER_LONG_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)MAX_LONG_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)SMALLER_LONG_VALUE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)MIN_LONG_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareIntWithDouble() {
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)BASE_DOUBLE_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)BIGGER_DOUBLE_VALUE1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)BIGGER_DOUBLE_VALUE2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)MAX_DOUBLE_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)POSITIVE_INFINITY) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)SMALLER_DOUBLE_VALUE1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)SMALLER_DOUBLE_VALUE2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)MIN_DOUBLE_VALUE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)NEGATIVE_INFINITY) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareIntWithNull() {
        Assert.assertTrue((BASE_INT_VALUE.compareTo((Object)NULL_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test(expected=StateValueTypeException.class)
    public void tcompareIntWithString() {
        BASE_INT_VALUE.compareTo((Object)BASE_STRING_VALUE);
    }

    @Test
    public void compareLongWithInt() {
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)BASE_INT_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)BIGGER_INT_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)SMALLER_INT_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareLongWithLong() {
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)BASE_LONG_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)BIGGER_LONG_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)MAX_LONG_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)SMALLER_LONG_VALUE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)MIN_LONG_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareLongWithDouble() {
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)BASE_DOUBLE_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)BIGGER_DOUBLE_VALUE1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)BIGGER_DOUBLE_VALUE2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)MAX_DOUBLE_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)POSITIVE_INFINITY) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)SMALLER_DOUBLE_VALUE1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)SMALLER_DOUBLE_VALUE2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)MIN_DOUBLE_VALUE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)NEGATIVE_INFINITY) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareLongWithNull() {
        Assert.assertTrue((BASE_LONG_VALUE.compareTo((Object)NULL_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test(expected=StateValueTypeException.class)
    public void compareLongWithString() {
        BASE_LONG_VALUE.compareTo((Object)BASE_STRING_VALUE);
    }

    @Test
    public void compareDoubleWithInt() {
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)BASE_INT_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)BIGGER_INT_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)SMALLER_INT_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareDoubleWithLong() {
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)BASE_LONG_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)BIGGER_LONG_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((SMALLER_DOUBLE_VALUE2.compareTo((Object)BASE_LONG_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)MAX_LONG_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BIGGER_DOUBLE_VALUE1.compareTo((Object)SMALLER_LONG_VALUE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BIGGER_DOUBLE_VALUE2.compareTo((Object)BASE_LONG_VALUE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)MIN_LONG_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareDoubleWithDouble() {
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)BASE_DOUBLE_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)BIGGER_DOUBLE_VALUE2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)MAX_DOUBLE_VALUE) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)SMALLER_DOUBLE_VALUE2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)MIN_DOUBLE_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareDoubleWithNull() {
        Assert.assertTrue((BASE_DOUBLE_VALUE.compareTo((Object)NULL_VALUE) < 0 ? 1 : 0) != 0);
    }

    @Test(expected=StateValueTypeException.class)
    public void compareDoubleWithString() {
        BASE_DOUBLE_VALUE.compareTo((Object)BASE_STRING_VALUE);
    }

    @Test(expected=StateValueTypeException.class)
    public void compareStringWithInt() {
        BASE_STRING_VALUE.compareTo((Object)BASE_INT_VALUE);
    }

    @Test(expected=StateValueTypeException.class)
    public void compareStringWithLong() {
        BASE_STRING_VALUE.compareTo((Object)BASE_LONG_VALUE);
    }

    @Test(expected=StateValueTypeException.class)
    public void compareStringWithDouble() {
        BASE_STRING_VALUE.compareTo((Object)BASE_DOUBLE_VALUE);
    }

    @Test
    public void compareStringWithString() {
        Assert.assertTrue((BASE_STRING_VALUE.compareTo((Object)BASE_STRING_VALUE) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_STRING_VALUE.compareTo((Object)SMALLER_STRING_VALUE) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BASE_STRING_VALUE.compareTo((Object)BIGGER_STRING_VALUE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareStringWithNull() {
        Assert.assertTrue((BASE_STRING_VALUE.compareTo((Object)NULL_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareNullWithInt() {
        Assert.assertTrue((NULL_VALUE.compareTo((Object)BASE_INT_VALUE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareNullWithLong() {
        Assert.assertTrue((NULL_VALUE.compareTo((Object)BASE_LONG_VALUE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareNullWithDouble() {
        Assert.assertTrue((NULL_VALUE.compareTo((Object)BASE_DOUBLE_VALUE) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareNullWithString() {
        Assert.assertTrue((NULL_VALUE.compareTo((Object)BASE_STRING_VALUE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareNullWithNull() {
        Assert.assertTrue((NULL_VALUE.compareTo((Object)NULL_VALUE) == 0 ? 1 : 0) != 0);
    }
}

