/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SignatureBuilder;
import org.eclipse.core.runtime.CoreException;

public class TypeOfDependentExpression
extends CPPUnknownBinding
implements ICPPUnknownType,
ISerializableType {
    private final ICPPEvaluation fEvaluation;
    private boolean fIsForDecltype;
    private boolean fIsForTemplateAuto;

    public TypeOfDependentExpression(ICPPEvaluation evaluation) {
        this(evaluation, true);
    }

    public TypeOfDependentExpression(ICPPEvaluation evaluation, boolean isForDecltype) {
        super(null);
        this.fEvaluation = evaluation;
        this.fIsForDecltype = isForDecltype;
        this.fIsForTemplateAuto = false;
    }

    public ICPPEvaluation getEvaluation() {
        return this.fEvaluation;
    }

    public boolean isForDecltype() {
        return this.fIsForDecltype;
    }

    public void setIsForDecltype(boolean isForDecltype) {
        this.fIsForDecltype = isForDecltype;
    }

    public boolean isForTemplateAuto() {
        return this.fIsForTemplateAuto;
    }

    public void setForTemplateAuto(boolean isForTemplateAuto) {
        this.fIsForTemplateAuto = isForTemplateAuto;
    }

    @Override
    public boolean isSameType(IType type) {
        return type instanceof TypeOfDependentExpression && this.fEvaluation.isEquivalentTo(((TypeOfDependentExpression)type).fEvaluation);
    }

    @Override
    public TypeOfDependentExpression clone() {
        return (TypeOfDependentExpression)super.clone();
    }

    public char[] getSignature() {
        SignatureBuilder buf = new SignatureBuilder();
        try {
            this.marshal(buf);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{'?'};
        }
        return buf.getSignature();
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 11;
        if (this.fIsForDecltype) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.fIsForTemplateAuto) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        buffer.putShort(firstBytes);
        buffer.marshalEvaluation(this.fEvaluation, false);
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation eval = buffer.unmarshalEvaluation();
        if (eval != null) {
            boolean isForDecltype = (firstBytes & 0x20) != 0;
            boolean isForTemplateAuto = (firstBytes & 0x40) != 0;
            TypeOfDependentExpression expression = new TypeOfDependentExpression(eval, isForDecltype);
            expression.setForTemplateAuto(isForTemplateAuto);
            return expression;
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IBinding getOwner() {
        return null;
    }

    @Override
    public char[] getNameCharArray() {
        return this.fEvaluation.getSignature();
    }
}

