/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.TraceInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotInfoTest {
    private ISnapshotInfo fSnapshotInfo1 = null;
    private ISnapshotInfo fSnapshotInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fSnapshotInfo1 = factory.getSnapshotInfo1();
        this.fSnapshotInfo2 = factory.getSnapshotInfo2();
    }

    @Test
    public void testSnapshotInfo() {
        SnapshotInfo fixture = new SnapshotInfo("event");
        Assert.assertNotNull((Object)fixture);
        Assert.assertEquals((Object)"event", (Object)fixture.getName());
    }

    @Test
    public void testSnapshotInfo2() {
        try {
            String name = null;
            new SnapshotInfo(name);
            Assert.fail((String)"null name in custructor");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testSnapshotCopy() {
        SnapshotInfo info = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo1);
        Assert.assertEquals((Object)this.fSnapshotInfo1.getName(), (Object)info.getName());
    }

    @Test
    public void testTraceCopy2() {
        try {
            SnapshotInfo info = null;
            new SnapshotInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testSetName() {
        SnapshotInfo fixture = new SnapshotInfo("event");
        fixture.setName("newName");
        Assert.assertEquals((Object)"newName", (Object)fixture.getName());
    }

    @Test
    public void testToString_1() {
        String result = this.fSnapshotInfo1.toString();
        Assert.assertEquals((Object)"[SnapshotInfo([TraceInfo(Name=snapshot-1)],snapshotPath=/home/user/lttng-trace/mysession/,ID=1,isStreamedSnapshot=false)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fSnapshotInfo1.equals(this.fSnapshotInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fSnapshotInfo2.equals(this.fSnapshotInfo2));
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo1.equals(this.fSnapshotInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo2.equals(this.fSnapshotInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        SnapshotInfo info1 = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo1);
        SnapshotInfo info2 = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fSnapshotInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fSnapshotInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fSnapshotInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fSnapshotInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        SnapshotInfo info1 = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo1);
        SnapshotInfo info2 = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo1);
        SnapshotInfo info3 = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo2.equals(null) ? 1 : 0) != 0);
        SnapshotInfo info = new SnapshotInfo("snapshot-1");
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo1.equals(info) ? 1 : 0) != 0);
        info.setSnapshotPath(null);
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo1.equals(info) ? 1 : 0) != 0);
        info.setId(this.fSnapshotInfo1.getId());
        Assert.assertTrue((String)"equals", (!info.equals((Object)this.fSnapshotInfo1) ? 1 : 0) != 0);
        info.setSnapshotPath("/home/user/lttng-trace/mysession/");
        Assert.assertTrue((String)"equals", (boolean)this.fSnapshotInfo1.equals(info));
        info.setId(2);
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo1.equals(info) ? 1 : 0) != 0);
        info.setId(this.fSnapshotInfo1.getId());
        info.setStreamedSnapshot(true);
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo1.equals(info) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fSnapshotInfo1.equals(new TraceInfo(this.fSnapshotInfo1.getName())) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        SnapshotInfo info1 = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo1);
        SnapshotInfo info2 = new SnapshotInfo((SnapshotInfo)this.fSnapshotInfo2);
        Assert.assertTrue((String)"hashCode", (this.fSnapshotInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fSnapshotInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fSnapshotInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fSnapshotInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
        SnapshotInfo info3 = new SnapshotInfo("snapshot-1");
        Assert.assertTrue((String)"hashCode", (this.fSnapshotInfo1.hashCode() != info3.hashCode() ? 1 : 0) != 0);
        info3.setSnapshotPath(null);
        Assert.assertTrue((String)"hashCode", (this.fSnapshotInfo1.hashCode() != info3.hashCode() ? 1 : 0) != 0);
        info3.setSnapshotPath("/home/user/lttng-trace/mysession/");
        Assert.assertTrue((String)"hashCode", (this.fSnapshotInfo1.hashCode() != info3.hashCode() ? 1 : 0) != 0);
    }
}

