/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director.app;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class IUListFormatter {
    private static final String PREFIX = "${";
    private static final String LINE_SEP = System.lineSeparator();
    private String formatString;
    private Collection<String> properties;

    public IUListFormatter(String formatString) {
        this.formatString = formatString;
        this.properties = IUListFormatter.parse(formatString);
    }

    public String format(Collection<IInstallableUnit> ius) {
        StringBuilder result = new StringBuilder();
        for (IInstallableUnit iu : ius) {
            this.format(iu, result);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - LINE_SEP.length());
        }
        return result.toString();
    }

    private void format(IInstallableUnit iu, StringBuilder result) {
        String s = this.formatString;
        for (String property : this.properties) {
            Pattern pattern = Pattern.compile(String.format("\\$\\{%s\\}", property));
            if (property == null) {
                String value = iu.getProperty(property, "df_LT");
                if (value == null) {
                    value = "";
                }
                s = IUListFormatter.insert(value, pattern, s);
                continue;
            }
            switch (property) {
                case "id": {
                    s = IUListFormatter.insert(iu.getId(), pattern, s);
                    break;
                }
                case "version": {
                    s = IUListFormatter.insert(iu.getVersion().toString(), pattern, s);
                    break;
                }
                default: {
                    String value = iu.getProperty(property, "df_LT");
                    if (value == null) {
                        value = "";
                    }
                    s = IUListFormatter.insert(value, pattern, s);
                }
            }
        }
        result.append(s);
        result.append(LINE_SEP);
    }

    private static String insert(String replacement, Pattern template, String s) {
        return template.matcher(s).replaceAll(replacement);
    }

    private static Collection<String> parse(String string) {
        HashSet<String> properties = new HashSet<String>(5);
        int start = 0;
        while (start < string.length() && (start = string.indexOf(PREFIX, start)) > -1) {
            int end = string.indexOf(125, start + PREFIX.length());
            if (end > start) {
                String property = string.substring(start + PREFIX.length(), end);
                properties.add(property);
                start = end + 1;
                continue;
            }
            ++start;
        }
        return properties;
    }
}

