/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.connections.RosConnectionsAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.connections.RosConnectionsAnalysisRequirement;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.IRosModelProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.RosModelUtils;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.IRosConnectionsModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.RosConnectionsModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.trace.RosExperiment;
import org.eclipse.tracecompass.incubator.internal.ros.core.trace.RosTrace;
import org.eclipse.tracecompass.incubator.internal.ros.core.trace.layout.IRosEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class RosConnectionsModelAnalysis
extends TmfAbstractAnalysisModule
implements IRosModelProvider<IRosConnectionsModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.incubator.ros.core.analysis.model.connections";
    protected @Nullable Set<@NonNull TmfAbstractAnalysisRequirement> fAnalysisRequirements = null;
    private @Nullable IProgressMonitor fMonitor;
    private @Nullable RosConnectionsModel fModel = null;

    public RosConnectionsModelAnalysis() {
        this.setId(ID);
    }

    @Override
    public @Nullable RosConnectionsModel getModel() {
        return this.fModel;
    }

    protected boolean executeAnalysis(@NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        this.fMonitor = monitor;
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            throw new IllegalStateException();
        }
        @Nullable ITmfStateSystem ss = RosModelUtils.getStateSystemFromAnalysis(trace, RosConnectionsAnalysis.class, RosConnectionsAnalysis.getFullAnalysisId());
        if (ss == null) {
            return false;
        }
        RosConnectionsModel model = new RosConnectionsModel(ss, monitor);
        model.generateModel();
        this.fModel = model;
        return !monitor.isCanceled();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        @NonNull ImmutableSet requirements = this.fAnalysisRequirements;
        if (requirements == null) {
            RosExperiment experiment = (RosExperiment)this.getTrace();
            IRosEventLayout layout = IRosEventLayout.getDefault();
            if (experiment != null) {
                @NonNull List traces = experiment.getTraces();
                for (ITmfTrace trace : traces) {
                    if (!(trace instanceof RosTrace)) continue;
                    layout = ((RosTrace)trace).getEventLayout();
                }
            }
            this.fAnalysisRequirements = requirements = ImmutableSet.of((Object)((Object)new RosConnectionsAnalysisRequirement(Objects.requireNonNull(layout))));
        }
        return requirements;
    }

    protected @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        RosConnectionsAnalysis connections = (RosConnectionsAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, RosConnectionsAnalysis.class, (String)RosConnectionsAnalysis.getFullAnalysisId());
        if (connections == null) {
            throw new IllegalStateException("There should be an analysis for this class");
        }
        return Collections.singleton(connections);
    }

    protected void canceling() {
        IProgressMonitor mon = this.fMonitor;
        if (mon != null && !mon.isCanceled()) {
            mon.setCanceled(true);
        }
    }
}

