/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.tokenizer.TokenList;
import org.eclipse.jface.viewers.StyledString;

public class VariablesCompletionProvider
extends AbstractCompletionProvider {
    @Override
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && context.getScriptEngine() != null && (context.getTokens().size() <= 1 || this.isParameter(context)) && !this.isStringLiteral(context);
    }

    private boolean isParameter(ICompletionContext context) {
        TokenList candidates = new TokenList(context.getTokens()).getFromLast("(");
        return !candidates.isEmpty();
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        Set elements = context.getScriptEngine().getVariables().entrySet();
        List filteredEntries = elements.stream().filter(e -> !((String)e.getKey()).startsWith("__EASE_MOD_")).filter(e -> this.matchesFilterIgnoreCase((String)e.getKey())).collect(Collectors.toList());
        for (Map.Entry entry : filteredEntries) {
            StyledString styledString = new StyledString((String)entry.getKey());
            styledString.append(String.format(" : %s", this.getClassName(entry.getValue())), StyledString.DECORATIONS_STYLER);
            styledString.append(" - Variable", StyledString.QUALIFIER_STYLER);
            this.addProposal(styledString, (String)entry.getKey(), (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(Activator.getLocalImageDescriptor("/icons/eobj16/debug_local_variable.png")), 80, null);
        }
    }

    private String getClassName(Object entry) {
        return entry == null ? "null" : entry.getClass().getSimpleName();
    }
}

