/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.signal.SignalUtil;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.ui.dialog.LittlesLawDialog;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class LatencyAction
extends AbstractTraceViewAction {
    private static final TimeUnit WINDOW_TIMEUNIT = TimeUnit.SECONDS;

    public LatencyAction(TraceView view) {
        super(view);
        this.setText("Identifier-based latency");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1 && this.view.hasClaims(true);
    }

    @Override
    protected void doRun() throws TraceException {
        LittlesLawDialog dialog = new LittlesLawDialog(this.view.getEditorSite().getShell(), this.view, LittlesLawDialog.LlDialogType.LATENCY);
        if (dialog.open() == 0) {
            IPsop p = SignalUtil.getLatency((ITrace)this.view.getTrace(), (String)dialog.getIdAtt(), (TimeUnit)dialog.getTimeUnit(), (double)dialog.getPositiveDoubleValue(), (TimeUnit)WINDOW_TIMEUNIT);
            p.setAttribute("name", "latency");
            p.setAttribute("id attribute", dialog.getIdAtt());
            p.setAttribute("time unit", dialog.getTimeUnit().toString());
            p.setAttribute("convolution width", Double.toString(dialog.getPositiveDoubleValue()) + " " + String.valueOf((Object)WINDOW_TIMEUNIT));
            this.view.addExtension(p, 0);
            this.view.update();
        }
    }
}

