/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree;

import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IAttributeFilter;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.vis.jfree.ClaimScaling;
import org.jfree.data.Range;

public class TraceViewConfiguration {
    private boolean showClaims = true;
    private boolean showEvents = true;
    private boolean showClaimEvents = false;
    private boolean showDependencies = true;
    private boolean showSignals = true;
    private boolean showSignalMarkers = false;
    private boolean showClaimLabels = false;
    private final List<DisjunctionFilter> claimFilters = new ArrayList<DisjunctionFilter>();
    private final List<DisjunctionFilter> eventFilters = new ArrayList<DisjunctionFilter>();
    private final List<DisjunctionFilter> resourceFilters = new ArrayList<DisjunctionFilter>();
    private final List<DisjunctionFilter> dependencyFilters = new ArrayList<DisjunctionFilter>();
    private final List<DisjunctionFilter> signalFilters = new ArrayList<DisjunctionFilter>();
    private boolean isResourceView = false;
    private ClaimScaling claimScaling = ClaimScaling.NONE;
    private Map<TracePart, Collection<String>> describingAttributes = new HashMap<TracePart, Collection<String>>();
    private Map<TracePart, Collection<String>> groupingAttributes = new HashMap<TracePart, Collection<String>>();
    private Map<TracePart, Collection<String>> colorAttributes = new HashMap<TracePart, Collection<String>>();
    private Range range = null;
    private Map<IAttributeAware, Paint> highlightMap = new HashMap<IAttributeAware, Paint>();

    public void setRange(Range r) {
        this.range = r;
    }

    public Range getRange() {
        return this.range;
    }

    public boolean isActivityView() {
        return !this.isResourceView;
    }

    public void setActivityView() {
        this.claimScaling = ClaimScaling.NONE;
        this.isResourceView = false;
    }

    public void setResourceView() {
        this.claimScaling = ClaimScaling.RESOURCE_AMOUNT;
        this.isResourceView = true;
    }

    public boolean showClaims() {
        return this.showClaims;
    }

    public void setShowClaims(boolean showClaims) {
        this.showClaims = showClaims;
    }

    public boolean showEvents() {
        return this.showEvents;
    }

    public void setShowEvents(boolean showEvents) {
        this.showEvents = showEvents;
    }

    public boolean showClaimEvents() {
        return this.showClaimEvents;
    }

    public void setShowClaimEvents(boolean showClaimEvents) {
        this.showClaimEvents = showClaimEvents;
    }

    public boolean showDependencies() {
        return this.showDependencies;
    }

    public void setShowDependencies(boolean showDependencies) {
        this.showDependencies = showDependencies;
    }

    public boolean showSignals() {
        return this.showSignals;
    }

    public void setShowSignals(boolean showSignals) {
        this.showSignals = showSignals;
    }

    public boolean getShowSignalMarkers() {
        return this.showSignalMarkers;
    }

    public void setShowSignalMarkers(boolean b) {
        this.showSignalMarkers = b;
    }

    public boolean getShowClaimLabels() {
        return this.showClaimLabels;
    }

    public void setShowClaimLabels(boolean b) {
        this.showClaimLabels = b;
    }

    public Collection<String> getDescribingAttributes(TracePart part) {
        return this.describingAttributes.get(part);
    }

    public void setDescribingAttributes(TracePart part, Collection<String> atts) {
        this.describingAttributes.put(part, atts);
    }

    public Collection<String> getGroupingAttributes(TracePart part) {
        return this.groupingAttributes.get(part);
    }

    public void setGroupingAttributes(TracePart part, Collection<String> atts) {
        this.groupingAttributes.put(part, atts);
    }

    public Collection<String> getColoringAttributes(TracePart part) {
        return this.colorAttributes.get(part);
    }

    public void setColoringAttributes(TracePart part, Collection<String> atts) {
        this.colorAttributes.put(part, atts);
    }

    public boolean hasHighlight() {
        return this.highlightMap != null && !this.highlightMap.isEmpty();
    }

    public Map<IAttributeAware, Paint> getHighlightMap() {
        return this.highlightMap;
    }

    public void setHighlightMap(Map<IAttributeAware, Paint> highlightMap) {
        this.highlightMap = highlightMap;
    }

    public void clearHighlight() {
        this.highlightMap = new HashMap<IAttributeAware, Paint>();
    }

    public ClaimScaling getClaimScaling() {
        return this.claimScaling;
    }

    public void setClaimScaling(ClaimScaling claimScaling) {
        this.claimScaling = claimScaling;
    }

    public void clearFilters(TracePart part) {
        switch (part) {
            case ALL: {
                this.claimFilters.clear();
                this.eventFilters.clear();
                this.resourceFilters.clear();
                this.dependencyFilters.clear();
                this.signalFilters.clear();
                break;
            }
            case CLAIM: {
                this.claimFilters.clear();
                break;
            }
            case EVENT: {
                this.eventFilters.clear();
                break;
            }
            case RESOURCE: {
                this.resourceFilters.clear();
                break;
            }
            case DEPENDENCY: {
                this.dependencyFilters.clear();
                break;
            }
            case SIGNAL: {
                this.signalFilters.clear();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void addNonPersistentFilter(TracePart part, IAttributeFilter f) {
        DisjunctionFilter df = new DisjunctionFilter();
        df.addNonPersistent(f);
        this.addFilter(part, df);
    }

    public void addFilter(TracePart part, String att, List<String> includedValues) {
        DisjunctionFilter f = new DisjunctionFilter();
        f.add(new SimpleFilter(att, includedValues));
        this.addFilter(part, f);
    }

    public void addFilter(TracePart part, DisjunctionFilter f) {
        switch (part) {
            case CLAIM: {
                this.claimFilters.add(f);
                break;
            }
            case EVENT: {
                this.eventFilters.add(f);
                break;
            }
            case RESOURCE: {
                this.resourceFilters.add(f);
                break;
            }
            case DEPENDENCY: {
                this.dependencyFilters.add(f);
                break;
            }
            case SIGNAL: {
                this.signalFilters.add(f);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public boolean hasFilters() {
        return !this.claimFilters.isEmpty() || !this.eventFilters.isEmpty() || !this.resourceFilters.isEmpty() || !this.dependencyFilters.isEmpty() || !this.signalFilters.isEmpty();
    }

    public List<DisjunctionFilter> getFilters(TracePart part) {
        switch (part) {
            case CLAIM: {
                return this.claimFilters;
            }
            case EVENT: {
                return this.eventFilters;
            }
            case RESOURCE: {
                return this.resourceFilters;
            }
            case DEPENDENCY: {
                return this.dependencyFilters;
            }
            case SIGNAL: {
                return this.signalFilters;
            }
        }
        throw new IllegalStateException();
    }

    public static final class DisjunctionFilter
    implements IAttributeFilter {
        private final Set<SimpleFilter> filters = new HashSet<SimpleFilter>();
        private final Set<IAttributeFilter> nonPersistentFilters = new HashSet<IAttributeFilter>();

        public void add(SimpleFilter f) {
            this.filters.add(f);
        }

        public void addNonPersistent(IAttributeFilter f) {
            this.nonPersistentFilters.add(f);
        }

        public Set<SimpleFilter> getPersistentFilters() {
            return this.filters;
        }

        public boolean include(IAttributeAware a) {
            for (IAttributeFilter iAttributeFilter : this.filters) {
                if (!iAttributeFilter.include(a)) continue;
                return true;
            }
            for (IAttributeFilter iAttributeFilter : this.nonPersistentFilters) {
                if (!iAttributeFilter.include(a)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "filters=" + this.filters + ", nonPersistent=" + this.nonPersistentFilters;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filters == null ? 0 : this.filters.hashCode());
            result = 31 * result + (this.nonPersistentFilters == null ? 0 : this.nonPersistentFilters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DisjunctionFilter other = (DisjunctionFilter)obj;
            if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
                return false;
            }
            return !(this.nonPersistentFilters == null ? other.nonPersistentFilters != null : !this.nonPersistentFilters.equals(other.nonPersistentFilters));
        }
    }

    public static final class SimpleFilter
    implements IAttributeFilter {
        private final String attName;
        private final Set<String> includedValues = new HashSet<String>();

        public SimpleFilter(String attName, Collection<String> includedValues) {
            this.attName = attName;
            this.includedValues.addAll(includedValues);
        }

        public String getAttName() {
            return this.attName;
        }

        public Set<String> getIncludedValues() {
            return this.includedValues;
        }

        public boolean include(IAttributeAware a) {
            String val = a.getAttributeValue(this.attName);
            return val != null && this.includedValues.contains(val);
        }

        public String toString() {
            return String.valueOf(this.attName) + "=" + this.includedValues;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attName == null ? 0 : this.attName.hashCode());
            result = 31 * result + (this.includedValues == null ? 0 : this.includedValues.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleFilter other = (SimpleFilter)obj;
            if (this.attName == null ? other.attName != null : !this.attName.equals(other.attName)) {
                return false;
            }
            return !(this.includedValues == null ? other.includedValues != null : !this.includedValues.equals(other.includedValues));
        }
    }
}

