/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IRemoteLineReference;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.actions.SystemRemoteFileLineOpenWithMenu;
import org.eclipse.rse.internal.files.ui.view.DownloadAndOpenJob;
import org.eclipse.rse.internal.shells.ui.ShellResources;
import org.eclipse.rse.internal.shells.ui.ShellsUIPlugin;
import org.eclipse.rse.internal.shells.ui.actions.SystemShowInShellViewAction;
import org.eclipse.rse.internal.shells.ui.actions.SystemTerminateRemoveShellAction;
import org.eclipse.rse.internal.shells.ui.actions.SystemTerminateShellAction;
import org.eclipse.rse.internal.shells.ui.view.ShellServiceSubSystemConfigurationAdapter;
import org.eclipse.rse.internal.shells.ui.view.SystemCommandsUI;
import org.eclipse.rse.internal.shells.ui.view.SystemCommandsViewPart;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystemConfiguration;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemViewRemoteOutputAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter {
    protected IPropertyDescriptor[] _propertyDescriptors;
    private SystemCopyToClipboardAction _copyOutputAction = null;
    private SystemPasteFromClipboardAction _pasteToPromptAction = null;
    private SystemShowInShellViewAction _showInShellView = null;
    private SystemTerminateShellAction _terminateShellAction = null;
    private SystemTerminateRemoveShellAction _terminateRemoveShellAction = null;
    private IAction _exportShellHistoryAction = null;
    private IAction _exportShellOutputAction = null;
    private List _shellActions = new ArrayList();
    private IPropertyDescriptor[] _shellPropertyDescriptors;
    private IPropertyDescriptor[] _outputPropertyDescriptors;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        Object firstSelection = selection.getFirstElement();
        if (firstSelection != null) {
            if (firstSelection instanceof IRemoteOutput) {
                if (this._copyOutputAction == null) {
                    this._copyOutputAction = new SystemCopyToClipboardAction(shell, RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard());
                }
                menu.add(menuGroup, (IAction)this._copyOutputAction);
                if (selection.size() == 1 && firstSelection instanceof IRemoteLineReference) {
                    IRemoteOutput result = (IRemoteOutput)firstSelection;
                    String type = result.getType();
                    if (type.equals("prompt")) {
                        if (this._pasteToPromptAction == null) {
                            this._pasteToPromptAction = new SystemPasteFromClipboardAction(shell, RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard());
                        }
                        menu.add(menuGroup, (IAction)this._pasteToPromptAction);
                    } else if (type.equals("directory")) {
                        IRemoteOutput output = (IRemoteOutput)firstSelection;
                        output.getAbsolutePath();
                    } else {
                        IRemoteFile rfile;
                        IRemoteOutput output = (IRemoteOutput)firstSelection;
                        if (output.getAbsolutePath() != null && (rfile = SystemRemoteFileLineOpenWithMenu.outputToFile((IRemoteLineReference)output)) != null && rfile.isFile()) {
                            MenuManager submenu = new MenuManager(ShellResources.ACTION_OPEN_WITH_LABEL, "group.openwith");
                            SystemRemoteFileLineOpenWithMenu openWithMenu = new SystemRemoteFileLineOpenWithMenu();
                            openWithMenu.updateSelection(selection);
                            submenu.add((IContributionItem)openWithMenu);
                            menu.getMenuManager().appendToGroup("group.openwith", (IContributionItem)submenu);
                        }
                    }
                }
            } else if (firstSelection instanceof IRemoteCommandShell) {
                IRemoteCommandShell cmdShell = (IRemoteCommandShell)firstSelection;
                if (this._showInShellView == null) {
                    this._showInShellView = new SystemShowInShellViewAction(shell);
                }
                menu.add("group.open", (IAction)this._showInShellView);
                this.getShellActions(cmdShell.getCommandSubSystem().getParentRemoteCmdSubSystemConfiguration());
                menu.add("group.change", (IAction)this._terminateShellAction);
                menu.add("group.change", (IAction)this._terminateRemoveShellAction);
                menu.add("group.importexport", this._exportShellOutputAction);
                menu.add("group.importexport", this._exportShellHistoryAction);
            }
        } else {
            return;
        }
    }

    public List getShellActions(IRemoteCmdSubSystemConfiguration factory) {
        this.getShell();
        this._shellActions.clear();
        if (this._shellActions.size() == 0) {
            if (this._terminateShellAction == null) {
                this._terminateShellAction = new SystemTerminateShellAction(this.shell);
            }
            this._shellActions.add(this._terminateShellAction);
            if (this._terminateRemoveShellAction == null) {
                this._terminateRemoveShellAction = new SystemTerminateRemoveShellAction(this.shell);
            }
            this._shellActions.add(this._terminateRemoveShellAction);
            this._shellActions.add(new Separator());
            ShellServiceSubSystemConfigurationAdapter factoryAdapter = (ShellServiceSubSystemConfigurationAdapter)((Object)factory.getAdapter(ISubSystemConfigurationAdapter.class));
            this._exportShellOutputAction = factoryAdapter.getCommandShellOutputExportAction(this.shell);
            this._shellActions.add(this._exportShellOutputAction);
            this._exportShellHistoryAction = factoryAdapter.getCommandShellHistoryExportAction(this.shell);
            this._shellActions.add(this._exportShellHistoryAction);
        }
        return this._shellActions;
    }

    public Object getParent(Object element) {
        if (element instanceof IRemoteOutput) {
            IRemoteOutput output = (IRemoteOutput)element;
            return output.getParent();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IRemoteOutput) {
            int tagIndex;
            IRemoteOutput output = (IRemoteOutput)element;
            String text = output.getText();
            if (text.indexOf(9) > 0) {
                text = this.translateTabs(text);
            }
            if ((tagIndex = text.indexOf("BEGIN-END-TAG")) == 0) {
                return "";
            }
            if (tagIndex > 0) {
                return text.substring(0, tagIndex);
            }
            return text;
        }
        if (element instanceof IRemoteCommandShell) {
            IRemoteCommandShell outputRoot = (IRemoteCommandShell)element;
            return outputRoot.getId();
        }
        return null;
    }

    protected String translateTabs(String tabbedString) {
        int columnWidth = 8;
        int currentOffset = 0;
        StringBuffer untabbedBuf = new StringBuffer();
        int i = 0;
        while (i < tabbedString.length()) {
            char c = tabbedString.charAt(i);
            if (c == '\t') {
                untabbedBuf.append(' ');
                ++currentOffset;
                while (currentOffset % columnWidth > 0) {
                    untabbedBuf.append(' ');
                    ++currentOffset;
                }
            } else if (c == ' ') {
                untabbedBuf.append(' ');
                ++currentOffset;
            } else {
                untabbedBuf.append(c);
                ++currentOffset;
            }
            ++i;
        }
        return untabbedBuf.toString();
    }

    public String getType(Object element) {
        if (element instanceof IRemoteOutput) {
            IRemoteOutput output = (IRemoteOutput)element;
            return output.getType();
        }
        if (element instanceof IRemoteCommandShell) {
            IRemoteCommandShell root = (IRemoteCommandShell)element;
            return root.getType();
        }
        return null;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        if (element instanceof IRemoteCommandShell) {
            IRemoteCommandShell output = (IRemoteCommandShell)element;
            return output.listOutput();
        }
        return null;
    }

    public boolean hasChildren(IAdaptable element) {
        if (element instanceof IRemoteCommandShell) {
            return !(this.getViewer() instanceof SystemView);
        }
        return false;
    }

    public static IRemoteFile outputToFile(IRemoteOutput output) {
        String path;
        IRemoteFile file = null;
        Object parent = output.getParent();
        IRemoteFileSubSystem fs = null;
        if (parent instanceof IRemoteCommandShell) {
            IRemoteCommandShell root = (IRemoteCommandShell)output.getParent();
            fs = RemoteFileUtility.getFileSubSystem((IHost)root.getCommandSubSystem().getHost());
        } else if (parent instanceof IRemoteFile) {
            return (IRemoteFile)parent;
        }
        if (fs != null && (path = output.getAbsolutePath()) != null && path.length() > 0) {
            Object obj = null;
            try {
                obj = fs.getObjectWithAbsoluteName(path, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                return null;
            }
            if (obj != null && obj instanceof IRemoteFile) {
                file = (IRemoteFile)obj;
                return file;
            }
        }
        return file;
    }

    protected IEditorRegistry getEditorRegistry() {
        return RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }

    public boolean handleDoubleClick(Object element) {
        IRemoteCommandShell cmdshell;
        boolean result = false;
        if (element instanceof IRemoteOutput) {
            IRemoteOutput output = (IRemoteOutput)element;
            IRemoteFile file = SystemViewRemoteOutputAdapter.outputToFile(output);
            if (file != null && file.isFile()) {
                this.doOpen(file, output);
                return true;
            }
        } else if (element instanceof IRemoteCommandShell && (cmdshell = (IRemoteCommandShell)element).getType().equals(ShellResources.RESID_SHELLS_COMMAND_SHELL_LABEL)) {
            SystemCommandsViewPart viewPart = SystemCommandsUI.getInstance().activateCommandsView();
            viewPart.updateOutput(cmdshell);
            viewPart.showPageFor(cmdshell);
            result = true;
        }
        return result;
    }

    private void doOpen(IRemoteFile remoteFile, IRemoteOutput output) {
        ISystemEditableRemoteObject editable;
        if (!(remoteFile.isArchive() && remoteFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement() || (editable = this.getEditableRemoteObject(remoteFile)) == null)) {
            int line = output.getLine();
            int charStart = output.getCharStart();
            int charEnd = output.getCharEnd();
            try {
                boolean isOpen = editable.checkOpenInEditor() != -1;
                boolean isFileCached = this.isFileCached(editable, remoteFile);
                if (isFileCached) {
                    if (!isOpen) {
                        editable.setLocalResourceProperties();
                        editable.addAsListener();
                    }
                    editable.openEditor();
                    SystemRemoteFileLineOpenWithMenu.handleGotoLine((IRemoteFile)remoteFile, (int)line, (int)charStart, (int)charEnd);
                } else {
                    DownloadAndOpenJob oJob = new DownloadAndOpenJob(editable, false, line, charStart, charEnd);
                    oJob.schedule();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isFileCached(ISystemEditableRemoteObject editable, IRemoteFile remoteFile) {
        boolean newFile;
        IFile file = editable.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        boolean bl = newFile = !file.exists();
        if (!newFile && file.exists()) {
            long storedModifiedStamp = properties.getRemoteFileTimeStamp();
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            try {
                remoteFile = subsystem.getRemoteFileObject(remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
            long remoteModifiedStamp = remoteFile.getLastModified();
            boolean dirty = properties.getDirty();
            boolean remoteNewer = storedModifiedStamp != remoteModifiedStamp;
            String remoteEncoding = remoteFile.getEncoding();
            String storedEncoding = properties.getEncoding();
            boolean encodingChanged = storedEncoding == null || !remoteEncoding.equals(storedEncoding);
            boolean usedBinary = properties.getUsedBinaryTransfer();
            boolean isBinary = remoteFile.isBinary();
            return !dirty && !remoteNewer && usedBinary == isBinary && !encodingChanged;
        }
        return false;
    }

    public ISubSystem getSubSystem(Object element) {
        IRemoteOutput output;
        Object parent;
        if (element instanceof IRemoteCommandShell) {
            IRemoteCommandShell cmd = (IRemoteCommandShell)element;
            return cmd.getCommandSubSystem();
        }
        if (element instanceof IRemoteOutput && (parent = (output = (IRemoteOutput)element).getParent()) instanceof IRemoteCommandShell) {
            return this.getSubSystem(parent);
        }
        return null;
    }

    public String getAbsoluteName(Object element) {
        if (element instanceof IRemoteCommandShell) {
            IRemoteCommandShell cmd = (IRemoteCommandShell)element;
            return cmd.getId();
        }
        if (element instanceof IRemoteOutput) {
            IRemoteOutput out = (IRemoteOutput)element;
            String type = out.getType();
            if (type.equals("file") || type.equals("directory")) {
                return out.getAbsolutePath();
            }
            String str = this.getAbsoluteParentName(element);
            return String.valueOf(str) + ":" + out.getIndex();
        }
        return null;
    }

    public String getAbsoluteParentName(Object element) {
        return this.getAbsoluteName(this.getParent(element));
    }

    public String getSubSystemConfigurationId(Object element) {
        return null;
    }

    public String getRemoteTypeCategory(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        if (element instanceof IRemoteOutput) {
            return ((IRemoteOutput)element).getType();
        }
        if (element instanceof IRemoteCommandShell) {
            return ((IRemoteCommandShell)element).getType();
        }
        return null;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteSubSubType(Object element) {
        return null;
    }

    public String getRemoteSourceType(Object element) {
        return null;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        if (element instanceof IRemoteOutput) {
            return ((IRemoteOutput)element).getParent();
        }
        return null;
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    protected Object internalGetPropertyValue(Object key) {
        return this.getPropertyValue(key, true);
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        if (element instanceof IRemoteOutput) {
            ImageDescriptor imageDescriptor = null;
            IRemoteOutput output = (IRemoteOutput)element;
            String type = output.getType();
            if (type.equals("error")) {
                imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.errorIcon");
            } else if (type.equals("warning")) {
                imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.warningIcon");
            } else if (type.equals("informational")) {
                imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.infoIcon");
            } else if (type.equals("directory")) {
                imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfolderIcon");
            } else if (type.equals("file")) {
                String name = output.getAbsolutePath();
                imageDescriptor = this.getEditorRegistry().getImageDescriptor(name);
                if (imageDescriptor == null) {
                    imageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
                }
            } else {
                imageDescriptor = type.equals("grep") ? RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemsearchresultIcon") : (type.equals("command") ? ShellsUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.shells.ui.systemshellIcon") : (type.equals("prompt") ? ShellsUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.shells.ui.systemshellIcon") : (type.equals("process") ? RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.full/obj16/systemprocess.gifIcon") : (type.equals("envvar") ? ShellsUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.shells.ui.full/obj16/systemenvvar.gifIcon") : (type.equals("libpathenvvar") ? ShellsUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.shells.ui.full/obj16/systemenvvarlibpath.gifIcon") : (type.equals("pathenvvar") ? ShellsUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.shells.ui.full/obj16/systemenvvarpath.gifIcon") : RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemblankIcon")))))));
            }
            return imageDescriptor;
        }
        if (element instanceof IRemoteCommandShell) {
            IRemoteCommandShell command = (IRemoteCommandShell)element;
            IRemoteCmdSubSystemConfiguration factory = command.getCommandSubSystem().getParentRemoteCmdSubSystemConfiguration();
            ShellServiceSubSystemConfigurationAdapter factoryAdapter = (ShellServiceSubSystemConfigurationAdapter)((Object)factory.getAdapter(ISubSystemConfigurationAdapter.class));
            ImageDescriptor imageDescriptor = null;
            imageDescriptor = command.isActive() ? factoryAdapter.getActiveCommandShellImageDescriptor() : factoryAdapter.getInactiveCommandShellImageDescriptor();
            return imageDescriptor;
        }
        ImageDescriptor imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemblankIcon");
        return imageDescriptor;
    }

    public boolean showDelete(Object element) {
        return false;
    }

    public boolean canDelete(Object element) {
        return false;
    }

    public boolean showRefresh(Object element) {
        return false;
    }

    public boolean showOpenViewActions(Object element) {
        return false;
    }

    public boolean showRename(Object element) {
        return false;
    }

    public boolean canRename(Object element) {
        return false;
    }

    public boolean doRename(Shell shell, Object element, String name, IProgressMonitor monitor) throws Exception {
        return false;
    }

    public boolean canDrop(Object element) {
        IRemoteOutput output;
        if (element instanceof IRemoteOutput && (output = (IRemoteOutput)element).getType().equals("directory")) {
            IRemoteFile file = SystemViewRemoteOutputAdapter.outputToFile(output);
            ISystemDragDropAdapter fadapter = (ISystemDragDropAdapter)((IAdaptable)file).getAdapter(ISystemDragDropAdapter.class);
            return fadapter.canDrop((Object)file);
        }
        return false;
    }

    public boolean canDrag(Object element) {
        if (element instanceof IRemoteOutput) {
            return true;
        }
        return element instanceof IRemoteCommandShell;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        IRemoteFile file;
        IRemoteOutput output;
        String type;
        if (element instanceof List) {
            ArrayList<String> resultSet = new ArrayList<String>();
            List set = (List)element;
            int i = 0;
            while (i < set.size()) {
                resultSet.add(this.getText(set.get(i)));
                ++i;
            }
            return resultSet;
        }
        if (element instanceof IRemoteOutput && ((type = (output = (IRemoteOutput)element).getType()).equals("file") || type.equals("directory")) && (file = SystemViewRemoteOutputAdapter.outputToFile(output)) != null) {
            ISystemDragDropAdapter fadapter = (ISystemDragDropAdapter)((IAdaptable)file).getAdapter(ISystemDragDropAdapter.class);
            return fadapter.doDrag((Object)file, sameSystemType, monitor);
        }
        return this.getText(element);
    }

    public boolean validateDrop(Object src, Object target, boolean sameSystem) {
        IRemoteOutput targetOutput;
        String type;
        if (target instanceof IRemoteOutput && ((type = (targetOutput = (IRemoteOutput)target).getType()).equals("prompt") || type.equals("directory"))) {
            if (src instanceof IRemoteFile) {
                return true;
            }
            if (src instanceof IResource) {
                return true;
            }
            if (src instanceof String) {
                return true;
            }
        }
        return false;
    }

    public Object doDrop(Object src, Object target, boolean sameSystemType, boolean sameSystem, int srcType, IProgressMonitor monitor) {
        IRemoteFile folder = SystemViewRemoteOutputAdapter.outputToFile((IRemoteOutput)target);
        if (folder != null) {
            ISystemDragDropAdapter adapter = (ISystemDragDropAdapter)((IAdaptable)folder).getAdapter(ISystemDragDropAdapter.class);
            return adapter.doDrop(src, (Object)folder, sameSystemType, sameSystem, srcType, monitor);
        }
        return null;
    }

    public boolean canEdit(Object element) {
        IRemoteOutput output;
        IRemoteFile file;
        return element instanceof IRemoteOutput && (file = SystemViewRemoteOutputAdapter.outputToFile(output = (IRemoteOutput)element)) != null && file.isFile();
    }

    public ISystemEditableRemoteObject getEditableRemoteObject(Object element) {
        if (element instanceof IRemoteOutput) {
            IRemoteOutput output = (IRemoteOutput)element;
            IRemoteFile file = SystemViewRemoteOutputAdapter.outputToFile(output);
            if (file != null && file.isFile()) {
                return new SystemEditableRemoteFile(file);
            }
        } else if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            return new SystemEditableRemoteFile(file);
        }
        return null;
    }

    public String getFilterStringFor(Object object) {
        return null;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return this.getUniquePropertyDescriptors();
    }

    public IPropertyDescriptor[] getUniquePropertyDescriptors() {
        if (this.propertySourceInput instanceof IRemoteCommandShell) {
            if (this._shellPropertyDescriptors == null) {
                this._shellPropertyDescriptors = new IPropertyDescriptor[2];
                this._shellPropertyDescriptors[0] = SystemViewRemoteOutputAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.shell.status", (String)ShellResources.RESID_PROPERTY_SHELL_STATUS_LABEL, (String)ShellResources.RESID_PROPERTY_SHELL_STATUS_TOOLTIP);
                this._shellPropertyDescriptors[1] = SystemViewRemoteOutputAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.shell.context", (String)ShellResources.RESID_PROPERTY_SHELL_CONTEXT_LABEL, (String)ShellResources.RESID_PROPERTY_SHELL_CONTEXT_TOOLTIP);
            }
            return this._shellPropertyDescriptors;
        }
        if (this._outputPropertyDescriptors == null) {
            this._outputPropertyDescriptors = new IPropertyDescriptor[0];
        }
        return this._outputPropertyDescriptors;
    }

    public Object getPropertyValue(Object property, boolean formatted) {
        String name = (String)property;
        if (this.propertySourceInput instanceof IRemoteCommandShell) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)this.propertySourceInput;
            if (name.equals("org.eclipse.rse.ui.shell.status")) {
                if (cmdShell.isActive()) {
                    return ShellResources.RESID_PROPERTY_SHELL_STATUS_ACTIVE_VALUE;
                }
                return ShellResources.RESID_PROPERTY_SHELL_STATUS_INACTIVE_VALUE;
            }
            if (name.equals("org.eclipse.rse.ui.shell.context")) {
                return cmdShell.getContextString();
            }
        }
        return "";
    }

    public boolean showProperties(Object element) {
        return false;
    }
}

